/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test;

import java.util.Date;
import javax.inject.Inject;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.node.Node;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.elasticsearch.test.BareElasticSearchFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={BareElasticSearchFeature.class})
@Deploy(value={})
public class TestElasticSearchClient {
    @Inject
    protected Node elasticSearchNode;
    @Inject
    protected Client elasticSearchClient;

    @Test
    public void shouldHaveStartedElasticSearch() throws Exception {
        Assert.assertNotNull((Object)this.elasticSearchNode);
        Assert.assertNotNull((Object)this.elasticSearchClient);
        Assert.assertFalse((boolean)this.elasticSearchNode.isClosed());
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("name", "test1").field("type", "File").field("yo", "man").field("dc:title", "Yohou").field("dc:created", new Date()).endObject();
        IndexResponse response = (IndexResponse)this.elasticSearchClient.prepareIndex("nxutest", "doc", "1").setSource(builder).execute().actionGet();
        Assert.assertNotNull((Object)response.getId());
        this.elasticSearchClient.admin().indices().prepareRefresh(new String[0]).execute().actionGet();
        SearchResponse searchResponse = (SearchResponse)this.elasticSearchClient.prepareSearch(new String[]{"nxutest"}).setTypes(new String[]{"doc"}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"name", (Object)"test1")).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)1L, (long)searchResponse.getHits().getTotalHits());
        searchResponse = (SearchResponse)this.elasticSearchClient.prepareSearch(new String[]{"nxutest"}).setTypes(new String[]{"doc"}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"dc:title", (Object)"YoHou")).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)1L, (long)searchResponse.getHits().getTotalHits());
    }
}

