/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@LocalDeploy(value={"org.nuxeo.elasticsearch.core:elasticsearch-test-nested-mapping-contrib.xml"})
public class TestElasticSearchQuery {
    private static final String IDX_NAME = "nxutest";
    private static final String TYPE_NAME = "doc";
    @Inject
    protected CoreFeature coreFeature;
    @Inject
    protected CoreSession session;
    @Inject
    protected ElasticSearchService ess;
    @Inject
    ElasticSearchAdmin esa;
    @Inject
    protected WorkManager workManager;
    private int commandProcessed;

    public void assertNumberOfCommandProcessed(int processed) throws Exception {
        Assert.assertEquals((long)processed, (long)(this.esa.getTotalCommandProcessed() - this.commandProcessed));
    }

    public void waitForCompletion() throws Exception {
        this.workManager.awaitCompletion(20L, TimeUnit.SECONDS);
        this.esa.prepareWaitForIndexing().get(20L, TimeUnit.SECONDS);
        this.esa.refresh();
    }

    protected void startTransaction() {
        if (!TransactionHelper.isTransactionActive()) {
            TransactionHelper.startTransaction();
        }
        Assert.assertEquals((long)0L, (long)this.esa.getPendingWorkerCount());
        this.commandProcessed = this.esa.getTotalCommandProcessed();
    }

    @Before
    public void setupIndex() throws Exception {
        this.esa.initIndexes(true);
    }

    protected CoreSession getRestrictedSession(String userName) {
        RepositoryManager rm = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        HashMap<String, UserPrincipal> ctx = new HashMap<String, UserPrincipal>();
        ctx.put("principal", new UserPrincipal(userName, null, false, false));
        return CoreInstance.openCoreSession((String)rm.getDefaultRepositoryName(), ctx);
    }

    @Test
    public void searchWithNestedQuery() throws Exception {
        this.startTransaction();
        DocumentModel doc = this.session.createDocumentModel("/", "myFile", "File");
        ArrayList blobs = new ArrayList();
        for (int i = 1; i <= 5; ++i) {
            String name = "testfile" + i + ".txt";
            Blob nblob = Blobs.createBlob((String)new String(new char[i]).replace('\u0000', 'a'));
            nblob.setFilename(name);
            HashMap<String, Object> filesEntry = new HashMap<String, Object>();
            filesEntry.put("file", (Serializable)nblob);
            filesEntry.put("filename", name);
            blobs.add(filesEntry);
        }
        doc.setPropertyValue("files:files", (Serializable)blobs);
        doc = this.session.createDocument(doc);
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.startTransaction();
        DocumentModelList ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE files:files/*/file/name = 'testfile1.txt' AND files:files/*/file/length=3"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE files:files/file/name = 'testfile1.txt' AND files:files/file/length=3"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE files:files/file/name = 'testfile4.txt' AND files:files/file/length=3"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE files:files/*1/file/name = 'testfile3.txt' AND files:files/*1/file/length=3"));
        Assert.assertEquals((long)0L, (long)ret.totalSize());
        NestedQueryBuilder qb = QueryBuilders.nestedQuery((String)"files:files.file", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"files:files.file.name", (String)"testfile1.txt")).must((QueryBuilder)QueryBuilders.termQuery((String)"files:files.file.length", (int)3)));
        ret = this.ess.query(new NxQueryBuilder(this.session).esQuery((QueryBuilder)qb));
        Assert.assertEquals((long)0L, (long)ret.totalSize());
        qb = QueryBuilders.nestedQuery((String)"files:files.file", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"files:files.file.name", (String)"testfile3.txt")).must((QueryBuilder)QueryBuilders.termQuery((String)"files:files.file.length", (int)3)));
        ret = this.ess.query(new NxQueryBuilder(this.session).esQuery((QueryBuilder)qb));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecurity() throws Exception {
        this.startTransaction();
        DocumentModel doc = this.session.createDocumentModel("/", "aFile", "File");
        this.session.createDocument(doc);
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.startTransaction();
        DocumentModelList ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
        MatchAllQueryBuilder qb = QueryBuilders.matchAllQuery();
        ret = this.ess.query(new NxQueryBuilder(this.session).esQuery((QueryBuilder)qb));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
        try (CoreSession restrictedSession = this.getRestrictedSession("bob");){
            ret = this.ess.query(new NxQueryBuilder(restrictedSession).nxql("SELECT * FROM Document"));
            Assert.assertEquals((long)0L, (long)ret.totalSize());
            ret = this.ess.query(new NxQueryBuilder(restrictedSession).esQuery((QueryBuilder)qb));
            Assert.assertEquals((long)0L, (long)ret.totalSize());
        }
    }
}

