/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.search.SearchHit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.api.EsResult;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@LocalDeploy(value={"org.nuxeo.elasticsearch.core:elasticsearch-test-contrib.xml"})
public class TestFetchDocumentsFromEs {
    private static final String IDX_NAME = "nxutest";
    private static final String TYPE_NAME = "doc";
    @Inject
    protected CoreSession session;
    @Inject
    protected ElasticSearchService ess;
    @Inject
    protected ElasticSearchAdmin esa;

    protected void buildTree() {
        String root = "/";
        for (int i = 0; i < 10; ++i) {
            String name = "folder" + i;
            DocumentModel doc = this.session.createDocumentModel(root, name, "Folder");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("Folder" + i)));
            this.session.createDocument(doc);
            root = root + name + "/";
        }
    }

    protected void waitForAsyncIndexing() throws Exception {
        WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
        Assert.assertTrue((boolean)wm.awaitCompletion(20L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)this.esa.getPendingWorkerCount());
    }

    protected void buildAndIndexTree() throws Exception {
        if (!TransactionHelper.isTransactionActive()) {
            TransactionHelper.startTransaction();
        }
        this.buildTree();
        int n = this.esa.getTotalCommandProcessed();
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForAsyncIndexing();
        Assert.assertEquals((long)10L, (long)(this.esa.getTotalCommandProcessed() - n));
        this.esa.refresh();
        TransactionHelper.startTransaction();
        SearchResponse searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)10L, (long)searchResponse.getHits().getTotalHits());
    }

    @Test
    public void shouldLoadDocumentFromEs() throws Exception {
        this.buildAndIndexTree();
        DocumentModelList docs = this.ess.query(new NxQueryBuilder(this.session).nxql("select * from Document").limit(20).fetchFromElasticsearch());
        Assert.assertEquals((long)10L, (long)docs.totalSize());
    }

    @Test
    public void checkNotFetch() throws Exception {
        this.buildAndIndexTree();
        DocumentModelList docs = this.ess.query(new NxQueryBuilder(this.session).nxql("select * from Document").limit(20).onlyElasticsearchResponse());
        Assert.assertNull((Object)docs);
        docs = this.ess.query(new NxQueryBuilder(this.session).nxql("select * from Document").limit(20).fetchFromElasticsearch().onlyElasticsearchResponse());
        Assert.assertNull((Object)docs);
        EsResult result = this.ess.queryAndAggregate(new NxQueryBuilder(this.session).nxql("select * from Document").limit(20).onlyElasticsearchResponse());
        Assert.assertNull((Object)result.getDocuments());
        Assert.assertNull((Object)result.getAggregates());
        Assert.assertEquals((long)10L, (long)result.getElasticsearchResponse().getHits().getTotalHits());
        result = this.ess.queryAndAggregate(new NxQueryBuilder(this.session).nxql("select * from Document").limit(20).fetchFromElasticsearch().onlyElasticsearchResponse());
        Assert.assertNull((Object)result.getDocuments());
        Assert.assertNull((Object)result.getAggregates());
        Assert.assertEquals((long)10L, (long)result.getElasticsearchResponse().getHits().getTotalHits());
    }

    @Test
    public void checkPathLevel() throws Exception {
        this.buildAndIndexTree();
        EsResult result = this.ess.queryAndAggregate(new NxQueryBuilder(this.session).nxql("select * from Document").limit(20).fetchFromElasticsearch().onlyElasticsearchResponse());
        for (SearchHit sh : result.getElasticsearchResponse().getHits()) {
            String path = (String)sh.getSource().get("ecm:path");
            int pathDepth = (Integer)sh.getSource().get("ecm:path.depth");
            String[] split = path.split("/");
            Assert.assertEquals((long)split.length, (long)pathDepth);
            for (int i = 1; i < split.length; ++i) {
                Assert.assertEquals((Object)split[i], sh.getSource().get("ecm:path.level" + i));
            }
        }
    }
}

