/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test;

import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.listener.ElasticSearchInlineListener;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@LocalDeploy(value={"org.nuxeo.elasticsearch.core:elasticsearch-test-contrib.xml"})
public class TestFulltextEnabled {
    private static final String IDX_NAME = "nxutest";
    private static final String TYPE_NAME = "doc";
    @Inject
    protected CoreSession session;
    @Inject
    protected ElasticSearchService ess;
    @Inject
    ElasticSearchAdmin esa;
    @Inject
    protected WorkManager workManager;
    @Inject
    protected RuntimeHarness harness;
    @Inject
    protected CoreFeature coreFeature;
    private int commandProcessed;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    public void assertNumberOfCommandProcessed(int processed) throws Exception {
        Assert.assertEquals((long)processed, (long)(this.esa.getTotalCommandProcessed() - this.commandProcessed));
    }

    public void waitForCompletion() throws Exception {
        this.workManager.awaitCompletion(20L, TimeUnit.SECONDS);
        this.esa.prepareWaitForIndexing().get(20L, TimeUnit.SECONDS);
        this.esa.refresh();
    }

    public void sleepForFulltext() {
        this.coreFeature.getStorageConfiguration().sleepForFulltext();
    }

    protected void startTransaction() {
        if (!TransactionHelper.isTransactionActive()) {
            TransactionHelper.startTransaction();
        }
        Assert.assertEquals((long)0L, (long)this.esa.getPendingWorkerCount());
        this.commandProcessed = this.esa.getTotalCommandProcessed();
    }

    @Before
    public void setupIndex() throws Exception {
        this.esa.initIndexes(true);
    }

    @Test
    public void testFulltext() throws Exception {
        this.createFileWithBlob();
        String nxql = "SELECT * FROM Document WHERE ecm:fulltext='search'";
        DocumentModelList esRet = this.ess.query(new NxQueryBuilder(this.session).nxql(nxql));
        Assert.assertEquals((long)1L, (long)esRet.totalSize());
        this.sleepForFulltext();
        DocumentModelList coreRet = this.session.query(nxql);
        Assert.assertEquals((long)1L, (long)coreRet.totalSize());
    }

    protected void createFileWithBlob() throws Exception {
        this.startTransaction();
        ElasticSearchInlineListener.useSyncIndexing.set(true);
        DocumentModel doc = this.session.createDocumentModel("/", "myFile", "File");
        BlobHolder holder = (BlobHolder)doc.getAdapter(BlobHolder.class);
        holder.setBlob((Blob)new StringBlob("You know for search"));
        this.session.createDocument(doc);
        this.session.save();
        TransactionHelper.commitOrRollbackTransaction();
        WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
        this.waitForCompletion();
        this.startTransaction();
        DocumentModelList ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
    }
}

