/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test;

import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@LocalDeploy(value={"org.nuxeo.elasticsearch.core:disable-listener-contrib.xml", "org.nuxeo.elasticsearch.core:elasticsearch-test-contrib.xml"})
public class TestManualIndexing {
    private static final String IDX_NAME = "nxutest";
    private static final String TYPE_NAME = "doc";
    @Inject
    protected CoreSession session;
    @Inject
    protected ElasticSearchService ess;
    @Inject
    protected ElasticSearchIndexing esi;
    @Inject
    ElasticSearchAdmin esa;
    @Inject
    protected WorkManager workManager;
    private int commandProcessed;

    public void assertNumberOfCommandProcessed(int processed) throws Exception {
        Assert.assertEquals((long)processed, (long)(this.esa.getTotalCommandProcessed() - this.commandProcessed));
    }

    public void waitForCompletion() throws Exception {
        this.workManager.awaitCompletion(20L, TimeUnit.SECONDS);
        this.esa.prepareWaitForIndexing().get(20L, TimeUnit.SECONDS);
        this.esa.refresh();
    }

    protected void startTransaction() {
        if (!TransactionHelper.isTransactionActive()) {
            TransactionHelper.startTransaction();
        }
        Assert.assertEquals((long)0L, (long)this.esa.getPendingWorkerCount());
        this.commandProcessed = this.esa.getTotalCommandProcessed();
    }

    @Before
    public void setupIndex() throws Exception {
        this.esa.initIndexes(true);
    }

    @Test
    public void checkIndexing() throws Exception {
        this.startTransaction();
        DocumentModel doc = this.session.createDocumentModel("/", "testDoc", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"TestMe"));
        doc.putContextData("disableAutoIndexing", (Serializable)Boolean.TRUE);
        doc = this.session.createDocument(doc);
        this.session.save();
        IndexingCommand cmd = new IndexingCommand(doc, IndexingCommand.Type.INSERT, true, false);
        this.esi.indexNonRecursive(cmd);
        this.assertNumberOfCommandProcessed(1);
        this.esa.refresh();
        SearchResponse searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)1L, (long)searchResponse.getHits().getTotalHits());
        searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"ecm:title", (Object)"TestMe")).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)1L, (long)searchResponse.getHits().getTotalHits());
    }

    @Test
    public void checkManualAsyncIndexing() throws Exception {
        DocumentModel doc0 = this.session.createDocumentModel("/", "testNote", "Note");
        doc0.setPropertyValue("dc:title", (Serializable)((Object)"TesNote"));
        doc0 = this.session.createDocument(doc0);
        this.session.save();
        IndexingCommand cmd0 = new IndexingCommand(doc0, IndexingCommand.Type.INSERT, true, false);
        this.esi.indexNonRecursive(cmd0);
        DocumentModel doc = this.session.createDocumentModel("/", "testDoc", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"TestMe"));
        doc.putContextData("disableAutoIndexing", (Serializable)Boolean.TRUE);
        doc = this.session.createDocument(doc);
        this.session.save();
        SearchResponse searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)1L, (long)searchResponse.getHits().getTotalHits());
        searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"ecm:title", (Object)"TestMe")).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)0L, (long)searchResponse.getHits().getTotalHits());
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.startTransaction();
        IndexingCommand cmd = new IndexingCommand(doc, IndexingCommand.Type.INSERT, false, false);
        this.esi.runIndexingWorker(Arrays.asList(cmd));
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(1);
        this.startTransaction();
        searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)2L, (long)searchResponse.getHits().getTotalHits());
        searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"ecm:title", (Object)"TestMe")).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)1L, (long)searchResponse.getHits().getTotalHits());
    }
}

