/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@Deploy(value={"org.nuxeo.ecm.platform.tag"})
@LocalDeploy(value={"org.nuxeo.elasticsearch.core:elasticsearch-test-mapping-contrib.xml"})
public class TestMapping {
    @Inject
    protected CoreSession session;
    @Inject
    protected ElasticSearchService ess;
    @Inject
    ElasticSearchAdmin esa;
    private int commandProcessed;

    public void assertNumberOfCommandProcessed(int processed) throws Exception {
        Assert.assertEquals((long)processed, (long)(this.esa.getTotalCommandProcessed() - this.commandProcessed));
    }

    public void waitForIndexing() throws Exception {
        this.esa.prepareWaitForIndexing().get(20L, TimeUnit.SECONDS);
        this.esa.refresh();
    }

    public void startTransaction() {
        if (!TransactionHelper.isTransactionActive()) {
            TransactionHelper.startTransaction();
        }
        Assert.assertEquals((long)0L, (long)this.esa.getPendingWorkerCount());
        this.commandProcessed = this.esa.getTotalCommandProcessed();
    }

    @Before
    public void setUpMapping() throws Exception {
        this.esa.initIndexes(true);
    }

    @Test
    public void testIlikeSearch() throws Exception {
        this.startTransaction();
        DocumentModel doc = this.session.createDocumentModel("/", "testDoc1", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"upper case"));
        doc.setPropertyValue("dc:description", (Serializable)((Object)"UPPER CASE DESC"));
        doc = this.session.createDocument(doc);
        doc = this.session.createDocumentModel("/", "testDoc2", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"mixed case"));
        doc.setPropertyValue("dc:description", (Serializable)((Object)"MiXeD cAsE dEsC"));
        doc = this.session.createDocument(doc);
        doc = this.session.createDocumentModel("/", "testDoc3", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"lower case"));
        doc.setPropertyValue("dc:description", (Serializable)((Object)"lower case desc"));
        doc = this.session.createDocument(doc);
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForIndexing();
        this.assertNumberOfCommandProcessed(3);
        this.startTransaction();
        DocumentModelList ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE dc:description ILIKE '%Case%'"));
        Assert.assertEquals((long)3L, (long)ret.totalSize());
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE dc:description ILIKE 'Upper%'"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE dc:description ILIKE 'mixED case desc'"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE dc:description LIKE '%Case%'"));
        Assert.assertEquals((long)0L, (long)ret.totalSize());
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE dc:description LIKE 'Upper%'"));
        Assert.assertEquals((long)0L, (long)ret.totalSize());
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE dc:description LIKE 'UPPER%'"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
    }

    @Test
    public void testFulltextAnalyzer() throws Exception {
        this.startTransaction();
        DocumentModel doc = this.session.createDocumentModel("/", "testDoc1", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"new-york.jpg"));
        doc = this.session.createDocument(doc);
        doc = this.session.createDocumentModel("/", "testDoc2", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"York.jpg"));
        doc = this.session.createDocument(doc);
        doc = this.session.createDocumentModel("/", "testDoc3", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"foo_jpg"));
        doc = this.session.createDocument(doc);
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForIndexing();
        this.startTransaction();
        DocumentModelList ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE ecm:fulltext.dc:title = 'new-york.jpg'"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE ecm:fulltext.dc:title = 'new york jpg'"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE ecm:fulltext.dc:title = 'new-york'"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE ecm:fulltext.dc:title = 'york new'"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE ecm:fulltext.dc:title = 'york -new-york'"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
        Assert.assertEquals((Object)"testDoc2", (Object)((DocumentModel)ret.get(0)).getName());
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE ecm:fulltext.dc:title = 'NewYork'"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE ecm:fulltext.dc:title = 'jpg'"));
        Assert.assertEquals((long)3L, (long)ret.totalSize());
    }
}

