/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.elasticsearch.index.query.QueryBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.api.WhereClauseDefinition;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.provider.ElasticSearchNxqlPageProvider;
import org.nuxeo.elasticsearch.query.PageProviderQueryBuilder;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@LocalDeploy(value={"org.nuxeo.elasticsearch.core:pageprovider-test-contrib.xml", "org.nuxeo.elasticsearch.core:schemas-test-contrib.xml", "org.nuxeo.elasticsearch.core:elasticsearch-test-contrib.xml"})
public class TestPageProvider {
    @Inject
    protected CoreSession session;
    @Inject
    ElasticSearchIndexing esi;
    @Inject
    ElasticSearchAdmin esa;
    @Inject
    protected WorkManager workManager;
    @Inject
    ElasticSearchService ess;
    private int commandProcessed;
    private Priority consoleThresold;

    public void assertNumberOfCommandProcessed(int processed) throws Exception {
        Assert.assertEquals((long)processed, (long)(this.esa.getTotalCommandProcessed() - this.commandProcessed));
    }

    public void waitForCompletion() throws Exception {
        this.workManager.awaitCompletion(20L, TimeUnit.SECONDS);
        this.esa.prepareWaitForIndexing().get(20L, TimeUnit.SECONDS);
        this.esa.refresh();
    }

    protected void startTransaction() {
        if (!TransactionHelper.isTransactionActive()) {
            TransactionHelper.startTransaction();
        }
        Assert.assertEquals((long)0L, (long)this.esa.getPendingWorkerCount());
        this.commandProcessed = this.esa.getTotalCommandProcessed();
    }

    protected void hideWarningFromConsoleLog() {
        Logger rootLogger = Logger.getRootLogger();
        ConsoleAppender consoleAppender = (ConsoleAppender)rootLogger.getAppender("CONSOLE");
        this.consoleThresold = consoleAppender.getThreshold();
        consoleAppender.setThreshold((Priority)Level.ERROR);
    }

    protected void restoreConsoleLog() {
        if (this.consoleThresold == null) {
            return;
        }
        Logger rootLogger = Logger.getRootLogger();
        ConsoleAppender consoleAppender = (ConsoleAppender)rootLogger.getAppender("CONSOLE");
        consoleAppender.setThreshold(this.consoleThresold);
        this.consoleThresold = null;
    }

    @Before
    public void setupIndex() throws Exception {
        this.esa.initIndexes(true);
    }

    @Test
    public void ICanUseANativePageProvider() throws Exception {
        DocumentModel doc;
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("NATIVE_PP_PATTERN");
        Assert.assertNotNull((Object)ppdef);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        long pageSize = 5L;
        PageProvider pp = pps.getPageProvider("NATIVE_PP_PATTERN", ppdef, null, null, Long.valueOf(pageSize), Long.valueOf(0L), props, new Object[0]);
        Assert.assertNotNull((Object)pp);
        this.startTransaction();
        for (int i = 0; i < 10; ++i) {
            doc = this.session.createDocumentModel("/", "testDoc" + i, "File");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("TestMe" + i)));
            doc = this.session.createDocument(doc);
        }
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(10);
        this.startTransaction();
        List p = pp.getCurrentPage();
        Assert.assertEquals((long)10L, (long)pp.getResultsCount());
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((long)pageSize, (long)p.size());
        Assert.assertEquals((long)2L, (long)pp.getNumberOfPages());
        doc = (DocumentModel)p.get(0);
        Assert.assertEquals((Object)"TestMe9", (Object)doc.getTitle());
        pp.nextPage();
        p = pp.getCurrentPage();
        Assert.assertEquals((long)pageSize, (long)p.size());
        doc = (DocumentModel)p.get((int)pageSize - 1);
        Assert.assertEquals((Object)"TestMe0", (Object)doc.getTitle());
    }

    @Test
    public void ICanUseANxqlPageProvider() throws Exception {
        DocumentModel doc;
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("NXQL_PP_PATTERN");
        Assert.assertNotNull((Object)ppdef);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        long pageSize = 5L;
        ElasticSearchNxqlPageProvider pp = (ElasticSearchNxqlPageProvider)pps.getPageProvider("NXQL_PP_PATTERN", ppdef, null, null, Long.valueOf(pageSize), Long.valueOf(0L), props, new Object[0]);
        Assert.assertNotNull((Object)pp);
        this.startTransaction();
        for (int i = 0; i < 10; ++i) {
            doc = this.session.createDocumentModel("/", "testDoc" + i, "File");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("TestMe" + i)));
            doc = this.session.createDocument(doc);
        }
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(10);
        this.startTransaction();
        List p = pp.getCurrentPage();
        Assert.assertEquals((long)10L, (long)pp.getResultsCount());
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((long)pageSize, (long)p.size());
        Assert.assertEquals((long)2L, (long)pp.getNumberOfPages());
        doc = (DocumentModel)p.get(0);
        Assert.assertEquals((Object)"TestMe9", (Object)doc.getTitle());
        pp.nextPage();
        p = pp.getCurrentPage();
        Assert.assertEquals((long)pageSize, (long)p.size());
        doc = (DocumentModel)p.get((int)pageSize - 1);
        Assert.assertEquals((Object)"TestMe0", (Object)doc.getTitle());
        pageSize = 0L;
        ppdef = pps.getPageProviderDefinition("NXQL_PP_PATTERN2");
        Assert.assertNotNull((Object)ppdef);
        pp = (ElasticSearchNxqlPageProvider)pps.getPageProvider("NXQL_PP_PATTERN2", ppdef, null, null, Long.valueOf(pageSize), Long.valueOf(0L), props, new Object[0]);
        Assert.assertNotNull((Object)pp);
        p = pp.getCurrentPage();
        Assert.assertEquals((long)10L, (long)pp.getResultsCount());
        Assert.assertEquals((long)10L, (long)p.size());
        doc = (DocumentModel)p.get(0);
        Assert.assertEquals((Object)"TestMe9", (Object)doc.getTitle());
    }

    @Test
    public void ICanUseANxqlPageProviderWithParameters() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("nxql_search");
        Assert.assertNotNull((Object)ppdef);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        long pageSize = 5L;
        PageProvider pp = pps.getPageProvider("nxql_search", ppdef, null, null, Long.valueOf(pageSize), Long.valueOf(0L), props, new Object[0]);
        this.startTransaction();
        for (int i = 0; i < 10; ++i) {
            DocumentModel doc = this.session.createDocumentModel("/", "testDoc" + i, "File");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("TestMe" + i)));
            doc = this.session.createDocument(doc);
        }
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(10);
        this.startTransaction();
        Object[] params = new String[]{"Select * from File where dc:title LIKE 'Test%'"};
        pp.setParameters(params);
        List p = pp.getCurrentPage();
        String esquery = ((ElasticSearchNxqlPageProvider)pp).getCurrentQueryAsEsBuilder().toString();
        this.assertEqualsEvenUnderWindows("{\n  \"filtered\" : {\n    \"query\" : {\n      \"match\" : {\n        \"dc:title\" : {\n          \"query\" : \"Test\",\n          \"type\" : \"phrase_prefix\"\n        }\n      }\n    },\n    \"filter\" : {\n      \"terms\" : {\n        \"ecm:primaryType\" : [ \"File\" ]\n      }\n    }\n  }\n}", esquery);
        Assert.assertEquals((long)10L, (long)pp.getResultsCount());
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((long)pageSize, (long)p.size());
        Assert.assertEquals((long)2L, (long)pp.getNumberOfPages());
        DocumentModel doc = (DocumentModel)p.get(0);
    }

    @Test
    public void ICanUseANxqlPageProviderWithFixedPart() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("NXQL_PP_FIXED_PART");
        Assert.assertNotNull((Object)ppdef);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        DocumentModelImpl model = new DocumentModelImpl("/", "doc", "AdvancedSearch");
        String[] sources = new String[]{"Source1", "Source2"};
        model.setProperty("advanced_search", "source_agg", (Object)sources);
        props.put("coreSession", (Serializable)this.session);
        long pageSize = 5L;
        PageProvider pp = pps.getPageProvider("NXQL_PP_FIXED_PART", ppdef, (DocumentModel)model, null, Long.valueOf(pageSize), Long.valueOf(0L), props, new Object[0]);
        this.startTransaction();
        for (int i = 0; i < 10; ++i) {
            DocumentModel doc = this.session.createDocumentModel("/", "testDoc" + i, "File");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("TestMe" + i)));
            doc = this.session.createDocument(doc);
        }
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(10);
        this.startTransaction();
        Object[] params = new String[]{this.session.getRootDocument().getId()};
        pp.setParameters(params);
        List p = pp.getCurrentPage();
        Assert.assertEquals((long)10L, (long)pp.getResultsCount());
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((long)pageSize, (long)p.size());
        Assert.assertEquals((long)2L, (long)pp.getNumberOfPages());
        DocumentModel doc = (DocumentModel)p.get(0);
    }

    @Test
    public void ICanUseInvalidPageProvider() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("INVALID_PP");
        Assert.assertNotNull((Object)ppdef);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        PageProvider pp = pps.getPageProvider("INVALID_PP", ppdef, null, null, Long.valueOf(0L), Long.valueOf(0L), props, new Object[0]);
        Assert.assertNotNull((Object)pp);
        this.hideWarningFromConsoleLog();
        List p = pp.getCurrentPage();
        this.restoreConsoleLog();
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((long)0L, (long)p.size());
        Assert.assertEquals((Object)"Syntax error: Invalid token <ORDER BY> at offset 29", (Object)pp.getErrorMessage());
    }

    @Test
    public void testNativePredicateIn() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        WhereClauseDefinition whereClause = pps.getPageProviderDefinition("TEST_IN").getWhereClause();
        DocumentModelImpl model = new DocumentModelImpl("/", "doc", "File");
        model.setPropertyValue("dc:subjects", (Serializable)new String[]{"foo", "bar"});
        QueryBuilder qb = PageProviderQueryBuilder.makeQuery((DocumentModel)model, (WhereClauseDefinition)whereClause, null, (boolean)true);
        this.assertEqualsEvenUnderWindows("{\n  \"bool\" : {\n    \"must\" : {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"terms\" : {\n            \"dc:title\" : [ \"foo\", \"bar\" ]\n          }\n        }\n      }\n    }\n  }\n}", qb.toString());
        model.setPropertyValue("dc:subjects", (Serializable)new String[]{"foo"});
        qb = PageProviderQueryBuilder.makeQuery((DocumentModel)model, (WhereClauseDefinition)whereClause, null, (boolean)true);
        this.assertEqualsEvenUnderWindows("{\n  \"bool\" : {\n    \"must\" : {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"terms\" : {\n            \"dc:title\" : [ \"foo\" ]\n          }\n        }\n      }\n    }\n  }\n}", qb.toString());
        model.setPropertyValue("dc:subjects", (Serializable)new String[0]);
        qb = PageProviderQueryBuilder.makeQuery((DocumentModel)model, (WhereClauseDefinition)whereClause, null, (boolean)true);
        this.assertEqualsEvenUnderWindows("{\n  \"match_all\" : { }\n}", qb.toString());
    }

    @Test
    public void testNativePredicateInIntegers() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        WhereClauseDefinition whereClause = pps.getPageProviderDefinition("TEST_IN_INTEGERS").getWhereClause();
        DocumentModelImpl model = new DocumentModelImpl("/", "doc", "AdvancedSearch");
        Integer[] array1 = new Integer[]{1, 2, 3};
        model.setPropertyValue("search:integerlist", (Serializable)array1);
        QueryBuilder qb = PageProviderQueryBuilder.makeQuery((DocumentModel)model, (WhereClauseDefinition)whereClause, null, (boolean)true);
        this.assertEqualsEvenUnderWindows("{\n  \"bool\" : {\n    \"must\" : {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"terms\" : {\n            \"size\" : [ 1, 2, 3 ]\n          }\n        }\n      }\n    }\n  }\n}", qb.toString());
        List<Long> list = Arrays.asList(1L, 2L, 3L);
        model.setPropertyValue("search:integerlist", (Serializable)((Object)list));
        qb = PageProviderQueryBuilder.makeQuery((DocumentModel)model, (WhereClauseDefinition)whereClause, null, (boolean)true);
        this.assertEqualsEvenUnderWindows("{\n  \"bool\" : {\n    \"must\" : {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"terms\" : {\n            \"size\" : [ 1, 2, 3 ]\n          }\n        }\n      }\n    }\n  }\n}", qb.toString());
    }

    @Test
    public void testNativePredicateInStringList() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        WhereClauseDefinition whereClause = pps.getPageProviderDefinition("ADVANCED_SEARCH").getWhereClause();
        Object[] params = new String[]{"foo"};
        DocumentModelImpl model = new DocumentModelImpl("/", "doc", "AdvancedSearch");
        String[] arrayString = new String[]{"1", "2", "3"};
        model.setPropertyValue("search:subjects", (Serializable)arrayString);
        QueryBuilder qb = PageProviderQueryBuilder.makeQuery((DocumentModel)model, (WhereClauseDefinition)whereClause, (Object[])params, (boolean)true);
        String json = qb.toString();
        this.assertEqualsEvenUnderWindows("{\n  \"bool\" : {\n    \"must\" : [ {\n      \"query_string\" : {\n        \"query\" : \"ecm\\\\:parentId: \\\"foo\\\"\"\n      }\n    }, {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"terms\" : {\n            \"dc:subjects\" : [ \"1\", \"2\", \"3\" ]\n          }\n        }\n      }\n    } ]\n  }\n}", qb.toString());
        List<String> list = Arrays.asList(arrayString);
        model.setPropertyValue("search:subjects", (Serializable)((Object)list));
        qb = PageProviderQueryBuilder.makeQuery((DocumentModel)model, (WhereClauseDefinition)whereClause, (Object[])params, (boolean)true);
        this.assertEqualsEvenUnderWindows(json, qb.toString());
        list = new ArrayList<String>();
        model.setPropertyValue("search:subjects", (Serializable)((Object)list));
        qb = PageProviderQueryBuilder.makeQuery((DocumentModel)model, (WhereClauseDefinition)whereClause, null, (boolean)true);
        this.assertEqualsEvenUnderWindows("{\n  \"match_all\" : { }\n}", qb.toString());
    }

    @Test
    public void testNativePredicateIsNull() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        WhereClauseDefinition whereClause = pps.getPageProviderDefinition("ADVANCED_SEARCH").getWhereClause();
        Object[] params = new String[]{"foo"};
        DocumentModelImpl model = new DocumentModelImpl("/", "doc", "AdvancedSearch");
        model.setPropertyValue("search:title", (Serializable)((Object)"bar"));
        QueryBuilder qb = PageProviderQueryBuilder.makeQuery((DocumentModel)model, (WhereClauseDefinition)whereClause, (Object[])params, (boolean)true);
        this.assertEqualsEvenUnderWindows("{\n  \"bool\" : {\n    \"must\" : [ {\n      \"query_string\" : {\n        \"query\" : \"ecm\\\\:parentId: \\\"foo\\\"\"\n      }\n    }, {\n      \"wildcard\" : {\n        \"dc:title\" : {\n          \"wildcard\" : \"bar\"\n        }\n      }\n    } ]\n  }\n}", qb.toString());
        model.setPropertyValue("search:isPresent", (Serializable)Boolean.TRUE);
        qb = PageProviderQueryBuilder.makeQuery((DocumentModel)model, (WhereClauseDefinition)whereClause, (Object[])params, (boolean)true);
        this.assertEqualsEvenUnderWindows("{\n  \"bool\" : {\n    \"must\" : [ {\n      \"query_string\" : {\n        \"query\" : \"ecm\\\\:parentId: \\\"foo\\\"\"\n      }\n    }, {\n      \"wildcard\" : {\n        \"dc:title\" : {\n          \"wildcard\" : \"bar\"\n        }\n      }\n    }, {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"missing\" : {\n            \"field\" : \"dc:modified\",\n            \"null_value\" : true\n          }\n        }\n      }\n    } ]\n  }\n}", qb.toString());
        model.setPropertyValue("search:isPresent", (Serializable)Boolean.FALSE);
        qb = PageProviderQueryBuilder.makeQuery((DocumentModel)model, (WhereClauseDefinition)whereClause, (Object[])params, (boolean)true);
        this.assertEqualsEvenUnderWindows("{\n  \"bool\" : {\n    \"must\" : [ {\n      \"query_string\" : {\n        \"query\" : \"ecm\\\\:parentId: \\\"foo\\\"\"\n      }\n    }, {\n      \"wildcard\" : {\n        \"dc:title\" : {\n          \"wildcard\" : \"bar\"\n        }\n      }\n    }, {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"missing\" : {\n            \"field\" : \"dc:modified\",\n            \"null_value\" : true\n          }\n        }\n      }\n    } ]\n  }\n}", qb.toString());
        qb = PageProviderQueryBuilder.makeQuery((String)"SELECT * FROM ? WHERE ? = '?'", (Object[])new Object[]{"Document", "dc:title", null}, (boolean)false, (boolean)true, (boolean)true);
        this.assertEqualsEvenUnderWindows("{\n  \"query_string\" : {\n    \"query\" : \"SELECT * FROM Document WHERE dc:title = ''\"\n  }\n}", qb.toString());
    }

    @Test
    public void testNativeFulltext() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        WhereClauseDefinition whereClause = pps.getPageProviderDefinition("ADVANCED_SEARCH").getWhereClause();
        Object[] params = new String[]{"foo"};
        DocumentModelImpl model = new DocumentModelImpl("/", "doc", "AdvancedSearch");
        model.setPropertyValue("search:fulltext_all", (Serializable)((Object)"you know for search"));
        QueryBuilder qb = PageProviderQueryBuilder.makeQuery((DocumentModel)model, (WhereClauseDefinition)whereClause, (Object[])params, (boolean)true);
        this.assertEqualsEvenUnderWindows("{\n  \"bool\" : {\n    \"must\" : [ {\n      \"query_string\" : {\n        \"query\" : \"ecm\\\\:parentId: \\\"foo\\\"\"\n      }\n    }, {\n      \"simple_query_string\" : {\n        \"query\" : \"you know for search\",\n        \"fields\" : [ \"_all\" ],\n        \"analyzer\" : \"fulltext\",\n        \"default_operator\" : \"and\"\n      }\n    } ]\n  }\n}", qb.toString());
    }

    @Test
    public void testNxqlPredicateWithHint() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("NXQL_WITH_HINT");
        Assert.assertNotNull((Object)ppdef);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        long pageSize = 5L;
        DocumentModelImpl model = new DocumentModelImpl("/", "doc", "AdvancedSearch");
        model.setProperty("advanced_search", "fulltext_all", (Object)"you know");
        model.setProperty("advanced_search", "description", (Object)"for search");
        ElasticSearchNxqlPageProvider pp = (ElasticSearchNxqlPageProvider)pps.getPageProvider("NXQL_WITH_HINT", ppdef, (DocumentModel)model, null, Long.valueOf(pageSize), Long.valueOf(0L), props, new Object[0]);
        Assert.assertNotNull((Object)pp);
        pp.getCurrentPage();
        String esquery = pp.getCurrentQueryAsEsBuilder().toString();
        this.assertEqualsEvenUnderWindows("{\n  \"bool\" : {\n    \"must\" : [ {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"term\" : {\n            \"dc:title.fulltext\" : \"you know\"\n          }\n        }\n      }\n    }, {\n      \"fuzzy\" : {\n        \"my_field\" : {\n          \"value\" : \"for search\"\n        }\n      }\n    }, {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"terms\" : {\n            \"my_subject\" : [ \"foo\", \"bar\" ]\n          }\n        }\n      }\n    } ]\n  }\n}", esquery);
    }

    @Test
    public void testNxqlPredicateWithHintInParameter() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("NXQL_WITH_HINT_IN_PARAMETER");
        Assert.assertNotNull((Object)ppdef);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        long pageSize = 5L;
        DocumentModelImpl model = new DocumentModelImpl("/", "doc", "AdvancedSearch");
        model.setProperty("advanced_search", "fulltext_all", (Object)"you know");
        model.setProperty("advanced_search", "description", (Object)"for search");
        ElasticSearchNxqlPageProvider pp = (ElasticSearchNxqlPageProvider)pps.getPageProvider("NXQL_WITH_HINT", ppdef, (DocumentModel)model, null, Long.valueOf(pageSize), Long.valueOf(0L), props, new Object[0]);
        Assert.assertNotNull((Object)pp);
        pp.getCurrentPage();
        String esquery = pp.getCurrentQueryAsEsBuilder().toString();
        this.assertEqualsEvenUnderWindows("{\n  \"bool\" : {\n    \"must\" : [ {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"term\" : {\n            \"dc:title.fulltext\" : \"you know\"\n          }\n        }\n      }\n    }, {\n      \"fuzzy\" : {\n        \"my_field\" : {\n          \"value\" : \"for search\"\n        }\n      }\n    }, {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"terms\" : {\n            \"my_subject\" : [ \"foo\", \"bar\" ]\n          }\n        }\n      }\n    } ]\n  }\n}", esquery);
    }

    protected void assertEqualsEvenUnderWindows(String expected, String actual) {
        if (SystemUtils.IS_OS_WINDOWS) {
            expected = expected.trim();
            expected = expected.replace("\n", "");
            expected = expected.replace("\r", "");
            actual = actual.trim();
            actual = actual.replace("\n", "");
            actual = actual.replace("\r", "");
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

