/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test;

import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.trash.TrashService;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.listener.ElasticSearchInlineListener;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@Deploy(value={"org.nuxeo.ecm.platform.tag"})
@LocalDeploy(value={"org.nuxeo.elasticsearch.core:elasticsearch-test-contrib.xml"})
public class TestReindex {
    @Inject
    protected CoreSession session;
    @Inject
    protected ElasticSearchService ess;
    @Inject
    protected ElasticSearchIndexing esi;
    @Inject
    protected TrashService trashService;
    @Inject
    ElasticSearchAdmin esa;
    @Inject
    protected TagService tagService;
    @Inject
    protected WorkManager workManager;
    private boolean syncMode = false;
    private int commandProcessed;

    public void assertNumberOfCommandProcessed(int processed) throws Exception {
        Assert.assertEquals((long)processed, (long)(this.esa.getTotalCommandProcessed() - this.commandProcessed));
    }

    public void waitForCompletion() throws Exception {
        this.workManager.awaitCompletion(20L, TimeUnit.SECONDS);
        this.esa.prepareWaitForIndexing().get(20L, TimeUnit.SECONDS);
        this.esa.refresh();
    }

    protected void startTransaction() {
        if (this.syncMode) {
            ElasticSearchInlineListener.useSyncIndexing.set(true);
        }
        if (!TransactionHelper.isTransactionActive()) {
            TransactionHelper.startTransaction();
        }
        Assert.assertEquals((long)0L, (long)this.esa.getPendingWorkerCount());
        this.commandProcessed = this.esa.getTotalCommandProcessed();
    }

    public void activateSynchronousMode() throws Exception {
        ElasticSearchInlineListener.useSyncIndexing.set(true);
        this.syncMode = true;
    }

    @Before
    public void setupIndex() throws Exception {
        this.esa.initIndexes(true);
    }

    @After
    public void disableSynchronousMode() {
        ElasticSearchInlineListener.useSyncIndexing.set(false);
        this.syncMode = false;
    }

    @Test
    public void shouldReindexDocument() throws Exception {
        this.buildDocs();
        this.startTransaction();
        String nxql = "SELECT * FROM Document, Relation order by ecm:uuid";
        ElasticSearchService ess = (ElasticSearchService)Framework.getLocalService(ElasticSearchService.class);
        DocumentModelList coreDocs = this.session.query(nxql);
        DocumentModelList docs = ess.query(new NxQueryBuilder(this.session).nxql(nxql).limit(100));
        Assert.assertEquals((long)coreDocs.totalSize(), (long)docs.totalSize());
        Assert.assertEquals((Object)this.getDigest(coreDocs), (Object)this.getDigest(docs));
        this.esa.initIndexes(true);
        this.esa.refresh();
        DocumentModelList docs2 = ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document"));
        Assert.assertEquals((long)0L, (long)docs2.totalSize());
        this.esi.runReindexingWorker(this.session.getRepositoryName(), "SELECT * FROM Document");
        this.esi.runReindexingWorker(this.session.getRepositoryName(), "SELECT * FROM Relation");
        this.waitForCompletion();
        docs2 = ess.query(new NxQueryBuilder(this.session).nxql(nxql).limit(100));
        Assert.assertEquals((Object)this.getDigest(coreDocs), (Object)this.getDigest(docs2));
    }

    private void buildDocs() throws Exception {
        DocumentModel doc;
        int i;
        this.startTransaction();
        DocumentModel folder = this.session.createDocumentModel("/", "section", "Folder");
        folder = this.session.createDocument(folder);
        this.session.saveDocument(folder);
        for (i = 0; i < 10; ++i) {
            doc = this.session.createDocumentModel("/", "testDoc" + i, "File");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("TestMe" + i)));
            BlobHolder holder = (BlobHolder)doc.getAdapter(BlobHolder.class);
            holder.setBlob((Blob)new StringBlob("You know for search" + i));
            doc = this.session.createDocument(doc);
            this.tagService.tag(this.session, doc.getId(), "mytag" + i, "Administrator");
        }
        this.session.save();
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.startTransaction();
        for (i = 0; i < 5; ++i) {
            doc = this.session.getDocument((DocumentRef)new PathRef("/testDoc" + i));
            doc.setPropertyValue("dc:description", (Serializable)((Object)("Description TestMe" + i)));
            doc = this.session.saveDocument(doc);
            DocumentModel proxy = this.session.publishDocument(doc, folder);
            if (i % 2 != 0) continue;
            this.trashService.trashDocuments(Arrays.asList(doc));
        }
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
    }

    protected String getDigest(DocumentModelList docs) {
        StringBuilder sb = new StringBuilder();
        for (DocumentModel doc : docs) {
            String nameOrTitle = doc.getName();
            if (nameOrTitle == null || nameOrTitle.isEmpty()) {
                nameOrTitle = doc.getTitle();
            }
            sb.append(doc.getType() + " " + doc.isProxy() + " " + doc.getId() + " ");
            sb.append(nameOrTitle);
            sb.append("\n");
        }
        return sb.toString();
    }
}

