/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.api.EsScrollResult;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@LocalDeploy(value={"org.nuxeo.elasticsearch.core:elasticsearch-test-contrib.xml"})
public class TestScrollSearch {
    @Inject
    protected CoreSession session;
    @Inject
    protected ElasticSearchService ess;
    @Inject
    protected ElasticSearchAdmin esa;
    @Inject
    protected WorkManager workManager;

    @Before
    public void setupIndex() throws Exception {
        this.esa.initIndexes(true);
    }

    @Test
    public void testScroll() throws Exception {
        this.buildAndIndexTree(100);
        String query = "select * from Document order by ecm:path";
        EsScrollResult res = this.ess.scroll(new NxQueryBuilder(this.session).nxql(query).limit(20), 10000L);
        Assert.assertNotNull((Object)res);
        Assert.assertNotNull((Object)res.getQueryBuilder());
        Assert.assertEquals((long)10000L, (long)res.getKeepAlive());
        Assert.assertNotNull((Object)res.getScrollId());
        int totalDocCount = 0;
        ArrayList docPaths = new ArrayList();
        DocumentModelList docs = res.getDocuments();
        while (!docs.isEmpty()) {
            int hitCount = docs.size();
            Assert.assertEquals((long)20L, (long)hitCount);
            totalDocCount += hitCount;
            docPaths.addAll(docs.stream().map(doc -> doc.getPathAsString()).collect(Collectors.toList()));
            res = this.ess.scroll(res);
            docs = res.getDocuments();
        }
        Assert.assertEquals((long)100L, (long)totalDocCount);
        Assert.assertEquals(this.session.query(query).stream().map(doc -> doc.getPathAsString()).collect(Collectors.toList()), docPaths);
    }

    @Test
    public void testScanAndScroll() throws Exception {
        this.buildAndIndexTree(100);
        String query = "select * from Document order by ecm:path";
        EsScrollResult res = this.ess.scanAndScroll(new NxQueryBuilder(this.session).nxql(query).limit(20), 10000L);
        Assert.assertNotNull((Object)res);
        Assert.assertNotNull((Object)res.getQueryBuilder());
        Assert.assertEquals((long)10000L, (long)res.getKeepAlive());
        Assert.assertNotNull((Object)res.getScrollId());
        int totalDocCount = 0;
        ArrayList docPaths = new ArrayList();
        res = this.ess.scroll(res);
        DocumentModelList docs = res.getDocuments();
        while (!docs.isEmpty()) {
            int hitCount = docs.size();
            Assert.assertEquals((long)20L, (long)hitCount);
            totalDocCount += hitCount;
            docPaths.addAll(docs.stream().map(doc -> doc.getPathAsString()).collect(Collectors.toList()));
            res = this.ess.scroll(res);
            docs = res.getDocuments();
        }
        Assert.assertEquals((long)100L, (long)totalDocCount);
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)this.session.query(query).stream().map(doc -> doc.getPathAsString()).collect(Collectors.toList()), docPaths));
    }

    protected void buildAndIndexTree(int docCount) throws Exception {
        this.startTransaction();
        this.buildTree(docCount);
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.startTransaction();
    }

    protected void buildTree(int docCount) {
        String root = "/";
        for (int i = 0; i < docCount; ++i) {
            String name = "folder" + i;
            DocumentModel doc = this.session.createDocumentModel(root, name, "Folder");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("Folder" + i)));
            this.session.createDocument(doc);
        }
    }

    protected void startTransaction() {
        if (!TransactionHelper.isTransactionActive()) {
            TransactionHelper.startTransaction();
        }
        Assert.assertEquals((long)0L, (long)this.esa.getPendingWorkerCount());
    }

    public void waitForCompletion() throws Exception {
        this.workManager.awaitCompletion(20L, TimeUnit.SECONDS);
        this.esa.prepareWaitForIndexing().get(20L, TimeUnit.SECONDS);
        this.esa.refresh();
    }
}

