/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.listener.ElasticSearchInlineListener;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@LocalDeploy(value={"org.nuxeo.elasticsearch.core:elasticsearch-test-contrib.xml", "org.nuxeo.elasticsearch.core:security-policy-contrib.xml"})
public class TestSecurityPolicy {
    private static final String IDX_NAME = "nxutest";
    private static final String TYPE_NAME = "doc";
    @Inject
    CoreSession session;
    @Inject
    ElasticSearchService ess;
    @Inject
    protected WorkManager workManager;
    @Inject
    ElasticSearchAdmin esa;
    private boolean syncMode = false;
    private int commandProcessed;

    public void assertNumberOfCommandProcessed(int processed) throws Exception {
        Assert.assertEquals((long)processed, (long)(this.esa.getTotalCommandProcessed() - this.commandProcessed));
    }

    public void waitForCompletion() throws Exception {
        this.workManager.awaitCompletion(20L, TimeUnit.SECONDS);
        this.esa.prepareWaitForIndexing().get(20L, TimeUnit.SECONDS);
        this.esa.refresh();
    }

    public void startTransaction() {
        if (this.syncMode) {
            ElasticSearchInlineListener.useSyncIndexing.set(true);
        }
        if (!TransactionHelper.isTransactionActive()) {
            TransactionHelper.startTransaction();
        }
        Assert.assertEquals((long)0L, (long)this.esa.getPendingWorkerCount());
        this.commandProcessed = this.esa.getTotalCommandProcessed();
    }

    public void activateSynchronousMode() throws Exception {
        ElasticSearchInlineListener.useSyncIndexing.set(true);
        this.syncMode = true;
    }

    @After
    public void disableSynchronousMode() {
        ElasticSearchInlineListener.useSyncIndexing.set(false);
        this.syncMode = false;
    }

    protected void buildDocs() {
        DocumentModel doc = this.session.createDocumentModel("/", "folder", "Folder");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"folder"));
        this.session.createDocument(doc);
        for (int i = 0; i < 5; ++i) {
            String name = "file" + i;
            doc = this.session.createDocumentModel("/folder", name, "File");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("File" + i)));
            this.session.createDocument(doc);
        }
    }

    protected void buildAndIndexDocs() throws Exception {
        this.startTransaction();
        this.buildDocs();
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(6);
        this.startTransaction();
    }

    protected CoreSession getRestrictedSession(String userName) {
        RepositoryManager rm = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        HashMap<String, UserPrincipal> ctx = new HashMap<String, UserPrincipal>();
        ctx.put("principal", new UserPrincipal(userName, null, false, false));
        return CoreInstance.openCoreSession((String)rm.getDefaultRepositoryName(), ctx);
    }

    @Test
    public void shouldWorkWithSecurityPolicy() throws Exception {
        this.buildAndIndexDocs();
        this.grantBrowsePermToUser("/folder", "toto");
        DocumentModelList docs = this.ess.query(new NxQueryBuilder(this.session).nxql("select * from Document"));
        Assert.assertEquals((long)6L, (long)docs.totalSize());
        CoreSession restrictedSession = this.getRestrictedSession("toto");
        docs = this.ess.query(new NxQueryBuilder(restrictedSession).nxql("select * from Document"));
        Assert.assertEquals((long)1L, (long)docs.size());
        Assert.assertEquals((long)1L, (long)docs.totalSize());
        restrictedSession.close();
    }

    protected void grantBrowsePermToUser(String path, String username) throws Exception {
        PathRef ref = new PathRef(path);
        ACPImpl acp = new ACPImpl();
        ACL acl = ACPImpl.newACL((String)"local");
        acl.add(new ACE(username, "Read", true));
        acp.addACL(acl);
        this.session.setACP((DocumentRef)ref, (ACP)acp, true);
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.startTransaction();
    }
}

