/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.client.Client;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@LocalDeploy(value={"org.nuxeo.elasticsearch.core:elasticsearch-test-contrib.xml"})
@Features(value={RepositoryElasticSearchFeature.class})
public class TestService {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Inject
    ElasticSearchAdmin esa;
    @Inject
    ElasticSearchService ess;
    @Inject
    ElasticSearchIndexing esi;

    @Test
    public void checkDeclaredServices() throws Exception {
        Assert.assertNotNull((Object)this.ess);
        Assert.assertNotNull((Object)this.esi);
        Assert.assertNotNull((Object)this.esa);
        Client client = this.esa.getClient();
        Assert.assertNotNull((Object)client);
        Assert.assertEquals((long)0L, (long)this.esa.getTotalCommandProcessed());
        Assert.assertEquals((long)0L, (long)this.esa.getPendingWorkerCount());
        Assert.assertEquals((long)0L, (long)this.esa.getRunningWorkerCount());
        Assert.assertFalse((boolean)this.esa.isIndexingInProgress());
        Assert.assertEquals((long)1L, (long)this.esa.getRepositoryNames().size());
        Assert.assertEquals((Object)"test", this.esa.getRepositoryNames().get(0));
    }

    @Test
    public void verifyNodeStartedWithConfig() throws Exception {
        ElasticSearchService ess = (ElasticSearchService)Framework.getLocalService(ElasticSearchService.class);
        Assert.assertNotNull((Object)ess);
        ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getLocalService(ElasticSearchAdmin.class);
        Assert.assertNotNull((Object)esa);
        NodesInfoResponse nodeInfoResponse = (NodesInfoResponse)esa.getClient().admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet();
        Assert.assertEquals((long)1L, (long)((NodeInfo[])nodeInfoResponse.getNodes()).length);
    }

    @Test
    public void verifyPrepareWaitForIndexing() throws Exception {
        ListenableFuture futureRet = this.esa.prepareWaitForIndexing();
        Assert.assertFalse((boolean)futureRet.isCancelled());
        Assert.assertTrue((boolean)((Boolean)futureRet.get()));
        Assert.assertTrue((boolean)futureRet.isDone());
        Assert.assertTrue((boolean)((Boolean)futureRet.get()));
    }

    @Test
    public void verifyPrepareWaitForIndexingTimeout() throws Exception {
        Assert.assertFalse((boolean)this.esa.isIndexingInProgress());
        this.esi.runReindexingWorker("test", "select * from Document");
        ListenableFuture futureRet = this.esa.prepareWaitForIndexing();
        try {
            futureRet.get(0L, TimeUnit.MILLISECONDS);
            Assert.assertTrue((boolean)futureRet.isDone());
        }
        catch (TimeoutException e) {
            Assert.assertTrue((boolean)((Boolean)futureRet.get()));
        }
        finally {
            Assert.assertFalse((boolean)this.esa.isIndexingInProgress());
        }
    }

    @Test
    public void verifyPrepareWaitForIndexingListener() throws Exception {
        ListenableFuture futureRet = this.esa.prepareWaitForIndexing();
        final Boolean[] callbackRet = new Boolean[]{false};
        Futures.addCallback((ListenableFuture)futureRet, (FutureCallback)new FutureCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                callbackRet[0] = true;
            }

            public void onFailure(Throwable t) {
                Assert.fail((String)"Fail");
            }
        });
        Assert.assertTrue((boolean)((Boolean)futureRet.get()));
        Thread.sleep(200L);
        Assert.assertTrue((boolean)callbackRet[0]);
    }
}

