/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test;

import java.io.Serializable;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.listener.ElasticSearchInlineListener;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@LocalDeploy(value={"org.nuxeo.elasticsearch.core:elasticsearch-test-contrib.xml"})
public class TestTreeIndexing {
    private static final String IDX_NAME = "nxutest";
    private static final String TYPE_NAME = "doc";
    @Inject
    CoreSession session;
    @Inject
    ElasticSearchService ess;
    @Inject
    protected WorkManager workManager;
    @Inject
    ElasticSearchAdmin esa;
    private boolean syncMode = false;
    private int commandProcessed;

    public void assertNumberOfCommandProcessed(int processed) throws Exception {
        Assert.assertEquals((long)processed, (long)(this.esa.getTotalCommandProcessed() - this.commandProcessed));
    }

    public void waitForCompletion() throws Exception {
        this.workManager.awaitCompletion(20L, TimeUnit.SECONDS);
        this.esa.prepareWaitForIndexing().get(20L, TimeUnit.SECONDS);
        this.esa.refresh();
    }

    public void startTransaction() {
        if (this.syncMode) {
            ElasticSearchInlineListener.useSyncIndexing.set(true);
        }
        if (!TransactionHelper.isTransactionActive()) {
            TransactionHelper.startTransaction();
        }
        Assert.assertEquals((long)0L, (long)this.esa.getPendingWorkerCount());
        this.commandProcessed = this.esa.getTotalCommandProcessed();
    }

    public void activateSynchronousMode() throws Exception {
        ElasticSearchInlineListener.useSyncIndexing.set(true);
        this.syncMode = true;
    }

    @After
    public void disableSynchronousMode() {
        ElasticSearchInlineListener.useSyncIndexing.set(false);
        this.syncMode = false;
    }

    @Before
    public void setUpMapping() throws Exception {
        this.esa.initIndexes(true);
    }

    protected void buildTree() {
        String root = "/";
        for (int i = 0; i < 10; ++i) {
            String name = "folder" + i;
            DocumentModel doc = this.session.createDocumentModel(root, name, "Folder");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("Folder" + i)));
            this.session.createDocument(doc);
            root = root + name + "/";
        }
    }

    protected void buildAndIndexTree() throws Exception {
        this.startTransaction();
        this.buildTree();
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(10);
        this.startTransaction();
        SearchResponse searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)10L, (long)searchResponse.getHits().getTotalHits());
    }

    @Test
    public void shouldIndexTree() throws Exception {
        this.buildAndIndexTree();
        SearchResponse searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery((QueryBuilder)QueryBuilders.prefixQuery((String)"ecm:path", (String)"/folder0/folder1/folder2")).execute().actionGet();
        Assert.assertEquals((long)8L, (long)searchResponse.getHits().getTotalHits());
    }

    @Test
    public void shouldUnIndexSubTree() throws Exception {
        this.buildAndIndexTree();
        PathRef ref = new PathRef("/folder0/folder1/folder2");
        Assert.assertTrue((boolean)this.session.exists((DocumentRef)ref));
        this.startTransaction();
        this.session.removeDocument((DocumentRef)ref);
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(1);
        this.startTransaction();
        SearchResponse searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)2L, (long)searchResponse.getHits().getTotalHits());
    }

    @Test
    public void shouldIndexMovedSubTree() throws Exception {
        this.buildAndIndexTree();
        this.startTransaction();
        PathRef ref = new PathRef("/folder0/folder1/folder2");
        Assert.assertTrue((boolean)this.session.exists((DocumentRef)ref));
        DocumentModel doc = this.session.getDocument((DocumentRef)ref);
        this.session.move((DocumentRef)ref, doc.getParentRef(), "folderA");
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        if (this.syncMode) {
            this.assertNumberOfCommandProcessed(9);
        } else {
            this.assertNumberOfCommandProcessed(8);
        }
        this.startTransaction();
        SearchResponse searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)10L, (long)searchResponse.getHits().getTotalHits());
        searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery((QueryBuilder)QueryBuilders.prefixQuery((String)"ecm:path", (String)"/folder0/folder1/folder2")).execute().actionGet();
        Assert.assertEquals((long)0L, (long)searchResponse.getHits().getTotalHits());
        searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery((QueryBuilder)QueryBuilders.prefixQuery((String)"ecm:path", (String)"/folder0/folder1/folderA")).execute().actionGet();
        Assert.assertEquals((long)8L, (long)searchResponse.getHits().getTotalHits());
        searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery((QueryBuilder)QueryBuilders.prefixQuery((String)"ecm:path", (String)"/folder0/folder1")).execute().actionGet();
        Assert.assertEquals((long)9L, (long)searchResponse.getHits().getTotalHits());
    }

    protected CoreSession getRestrictedSession(String userName) {
        RepositoryManager rm = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        HashMap<String, UserPrincipal> ctx = new HashMap<String, UserPrincipal>();
        ctx.put("principal", new UserPrincipal(userName, null, false, false));
        return CoreInstance.openCoreSession((String)rm.getDefaultRepositoryName(), ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFilterTreeOnSecurity() throws Exception {
        this.buildAndIndexTree();
        DocumentModelList docs = this.ess.query(new NxQueryBuilder(this.session).nxql("select * from Document"));
        Assert.assertEquals((long)10L, (long)docs.totalSize());
        this.startTransaction();
        try (CoreSession restrictedSession = this.getRestrictedSession("toto");){
            docs = this.ess.query(new NxQueryBuilder(restrictedSession).nxql("select * from Document"));
            Assert.assertEquals((long)0L, (long)docs.totalSize());
            PathRef ref = new PathRef("/folder0/folder1/folder2");
            ACPImpl acp = new ACPImpl();
            ACL acl = ACPImpl.newACL((String)"local");
            acl.add(new ACE("toto", "Read", true));
            acp.addACL(acl);
            this.session.setACP((DocumentRef)ref, (ACP)acp, true);
            TransactionHelper.commitOrRollbackTransaction();
            this.waitForCompletion();
            if (this.syncMode) {
                this.assertNumberOfCommandProcessed(9);
            } else {
                this.assertNumberOfCommandProcessed(8);
            }
            this.startTransaction();
            docs = this.ess.query(new NxQueryBuilder(restrictedSession).nxql("select * from Document"));
            Assert.assertEquals((long)8L, (long)docs.totalSize());
            ref = new PathRef("/folder0/folder1/folder2/folder3/folder4/folder5");
            acp = new ACPImpl();
            acl = ACPImpl.newACL((String)"local");
            acl.add(new ACE("Everyone", "Everything", false));
            acl.add(new ACE("Administrator", "Everything", true));
            acp.addACL(acl);
            this.session.setACP((DocumentRef)ref, (ACP)acp, true);
            this.session.save();
            TransactionHelper.commitOrRollbackTransaction();
            this.waitForCompletion();
            if (this.syncMode) {
                this.assertNumberOfCommandProcessed(6);
            } else {
                this.assertNumberOfCommandProcessed(5);
            }
            this.startTransaction();
            docs = this.ess.query(new NxQueryBuilder(restrictedSession).nxql("select * from Document"));
            Assert.assertEquals((long)3L, (long)docs.totalSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDenyAccessOnUnsupportedACL() throws Exception {
        Assume.assumeTrue((boolean)this.session.isNegativeAclAllowed());
        this.buildAndIndexTree();
        DocumentModelList docs = this.ess.query(new NxQueryBuilder(this.session).nxql("select * from Document"));
        Assert.assertEquals((long)10L, (long)docs.totalSize());
        try (CoreSession restrictedSession = this.getRestrictedSession("toto");){
            docs = this.ess.query(new NxQueryBuilder(restrictedSession).nxql("select * from Document"));
            Assert.assertEquals((long)0L, (long)docs.totalSize());
            PathRef ref = new PathRef("/folder0/folder1/folder2");
            ACPImpl acp = new ACPImpl();
            ACL acl = ACPImpl.newACL((String)"local");
            acl.add(new ACE("toto", "Read", true));
            acp.addACL(acl);
            this.session.setACP((DocumentRef)ref, (ACP)acp, true);
            TransactionHelper.commitOrRollbackTransaction();
            this.waitForCompletion();
            this.startTransaction();
            docs = this.ess.query(new NxQueryBuilder(restrictedSession).nxql("select * from Document order by dc:title"));
            Assert.assertEquals((long)8L, (long)docs.totalSize());
            ref = new PathRef("/folder0/folder1/folder2/folder3/folder4/folder5");
            acp = new ACPImpl();
            acl = ACPImpl.newACL((String)"local");
            acl.add(new ACE("bob", "Everything", false));
            acp.addACL(acl);
            this.session.setACP((DocumentRef)ref, (ACP)acp, true);
            this.session.save();
            TransactionHelper.commitOrRollbackTransaction();
            this.waitForCompletion();
            this.startTransaction();
            docs = this.ess.query(new NxQueryBuilder(restrictedSession).nxql("select * from Document order by dc:title"));
            Assert.assertEquals((long)3L, (long)docs.totalSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldStoreOnlyEffectiveACEs() throws Exception {
        this.buildAndIndexTree();
        DocumentModelList docs = this.ess.query(new NxQueryBuilder(this.session).nxql("select * from Document"));
        Assert.assertEquals((long)10L, (long)docs.totalSize());
        try (CoreSession restrictedSession = this.getRestrictedSession("toto");){
            docs = this.ess.query(new NxQueryBuilder(restrictedSession).nxql("select * from Document"));
            Assert.assertEquals((long)0L, (long)docs.totalSize());
            PathRef ref = new PathRef("/folder0");
            ACPImpl acp = new ACPImpl();
            ACL acl = ACPImpl.newACL((String)"local");
            acl.add(ACE.builder((String)"toto", (String)"Read").build());
            acp.addACL(acl);
            this.session.setACP((DocumentRef)ref, (ACP)acp, true);
            TransactionHelper.commitOrRollbackTransaction();
            this.waitForCompletion();
            this.startTransaction();
            docs = this.ess.query(new NxQueryBuilder(restrictedSession).nxql("select * from Document order by dc:title"));
            Assert.assertEquals((long)10L, (long)docs.totalSize());
            acp = new ACPImpl();
            acl = ACPImpl.newACL((String)"local");
            Date now = new Date();
            GregorianCalendar begin = new GregorianCalendar();
            begin.setTimeInMillis(now.toInstant().minus(10L, ChronoUnit.DAYS).toEpochMilli());
            GregorianCalendar end = new GregorianCalendar();
            end.setTimeInMillis(now.toInstant().minus(2L, ChronoUnit.DAYS).toEpochMilli());
            acl.add(ACE.builder((String)"toto", (String)"Read").begin((Calendar)begin).end((Calendar)end).build());
            acp.addACL(acl);
            this.session.setACP((DocumentRef)ref, (ACP)acp, true);
            TransactionHelper.commitOrRollbackTransaction();
            this.waitForCompletion();
            this.startTransaction();
            docs = this.ess.query(new NxQueryBuilder(restrictedSession).nxql("select * from Document order by dc:title"));
            Assert.assertEquals((long)0L, (long)docs.totalSize());
        }
    }

    @Test
    public void shouldReindexSubTreeInTrash() throws Exception {
        this.buildAndIndexTree();
        this.startTransaction();
        PathRef ref = new PathRef("/folder0/folder1/folder2");
        Assert.assertTrue((boolean)this.session.exists((DocumentRef)ref));
        this.session.followTransition((DocumentRef)ref, "delete");
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(8);
        this.startTransaction();
        DocumentModelList docs = this.ess.query(new NxQueryBuilder(this.session).nxql("select * from Document where ecm:currentLifeCycleState != 'deleted'"));
        Assert.assertEquals((long)2L, (long)docs.totalSize());
    }

    @Test
    public void shouldIndexOnCopy() throws Exception {
        this.buildAndIndexTree();
        PathRef src = new PathRef("/folder0/folder1/folder2");
        PathRef dst = new PathRef("/folder0");
        this.session.copy((DocumentRef)src, (DocumentRef)dst, "folder2-copy", new CoreSession.CopyOption[0]);
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.startTransaction();
        DocumentModelList docs = this.ess.query(new NxQueryBuilder(this.session).nxql("select * from Document"));
        Assert.assertEquals((long)18L, (long)docs.totalSize());
    }
}

