/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test.aggregates;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.lang.SystemUtils;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.query.api.Aggregate;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.api.PredicateFieldDefinition;
import org.nuxeo.ecm.platform.query.core.AggregateDescriptor;
import org.nuxeo.ecm.platform.query.core.AggregateRangeDateDescriptor;
import org.nuxeo.ecm.platform.query.core.AggregateRangeDescriptor;
import org.nuxeo.ecm.platform.query.core.BucketRangeDate;
import org.nuxeo.ecm.platform.query.core.FieldDescriptor;
import org.nuxeo.elasticsearch.aggregate.AggregateFactory;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@LocalDeploy(value={"org.nuxeo.elasticsearch.core:pageprovider-test-contrib.xml", "org.nuxeo.elasticsearch.core:schemas-test-contrib.xml", "org.nuxeo.elasticsearch.core:elasticsearch-test-contrib.xml"})
public class TestAggregates {
    private static final String IDX_NAME = "nxutest";
    private static final String TYPE_NAME = "doc";
    @Inject
    protected CoreSession session;
    @Inject
    protected ElasticSearchService ess;
    @Inject
    protected ElasticSearchAdmin esa;
    @Inject
    protected ElasticSearchIndexing esi;

    protected void buildDocs() throws Exception {
        DateTime yesterdayNoon = new DateTime(DateTimeZone.UTC).withTimeAtStartOfDay().minusDays(1).plusHours(12);
        for (int i = 0; i < 10; ++i) {
            String name = TYPE_NAME + i;
            DocumentModel doc = this.session.createDocumentModel("/", name, "File");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("File" + i)));
            doc.setPropertyValue("dc:source", (Serializable)((Object)("Source" + i)));
            doc.setPropertyValue("dc:nature", (Serializable)((Object)("Nature" + i % 2)));
            doc.setPropertyValue("dc:coverage", (Serializable)((Object)("Coverage" + i % 3)));
            doc.setPropertyValue("common:size", (Serializable)Integer.valueOf(1024 * i));
            doc.setPropertyValue("dc:created", (Serializable)new Date(yesterdayNoon.minusWeeks(i).getMillis()));
            doc = this.session.createDocument(doc);
        }
        TransactionHelper.commitOrRollbackTransaction();
        WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
        Assert.assertTrue((boolean)wm.awaitCompletion(20L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)this.esa.getPendingWorkerCount());
        this.esa.refresh();
        TransactionHelper.startTransaction();
    }

    @Test
    public void testAggregateTermsQuery() throws Exception {
        AggregateDescriptor aggDef = new AggregateDescriptor();
        aggDef.setType("terms");
        aggDef.setId("source");
        aggDef.setDocumentField("dc:source");
        aggDef.setSearchField((PredicateFieldDefinition)new FieldDescriptor("advanced_search", "source_agg"));
        aggDef.setProperty("minDocCount", "10");
        aggDef.setProperty("size", "10");
        aggDef.setProperty("exclude", "foo*");
        aggDef.setProperty("include", "bar*");
        aggDef.setProperty("order", "count asc");
        NxQueryBuilder qb = new NxQueryBuilder(this.session).nxql("SELECT * FROM Document").addAggregate(AggregateFactory.create((AggregateDefinition)aggDef, null));
        SearchRequestBuilder request = this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME});
        qb.updateRequest(request);
        this.assertEqualsEvenUnderWindows("{\n  \"from\" : 0,\n  \"size\" : 10,\n  \"query\" : {\n    \"match_all\" : { }\n  },\n  \"fields\" : \"_id\",\n  \"aggregations\" : {\n    \"source_filter\" : {\n      \"filter\" : {\n        \"match_all\" : { }\n      },\n      \"aggregations\" : {\n        \"source\" : {\n          \"terms\" : {\n            \"field\" : \"dc:source\",\n            \"size\" : 10,\n            \"min_doc_count\" : 10,\n            \"order\" : {\n              \"_count\" : \"asc\"\n            },\n            \"include\" : \"bar*\",\n            \"exclude\" : \"foo*\"\n          }\n        }\n      }\n    }\n  }\n}", request.toString());
    }

    @Test
    public void testAggregateTermsFulltextQuery() throws Exception {
        AggregateDescriptor aggDef = new AggregateDescriptor();
        aggDef.setType("terms");
        aggDef.setId("fulltext");
        aggDef.setDocumentField("ecm:fulltext");
        aggDef.setSearchField((PredicateFieldDefinition)new FieldDescriptor("advanced_search", "fulltext_agg"));
        NxQueryBuilder qb = new NxQueryBuilder(this.session).nxql("SELECT * FROM Document").addAggregate(AggregateFactory.create((AggregateDefinition)aggDef, null));
        SearchRequestBuilder request = this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME});
        qb.updateRequest(request);
        this.assertEqualsEvenUnderWindows("{\n  \"from\" : 0,\n  \"size\" : 10,\n  \"query\" : {\n    \"match_all\" : { }\n  },\n  \"fields\" : \"_id\",\n  \"aggregations\" : {\n    \"fulltext_filter\" : {\n      \"filter\" : {\n        \"match_all\" : { }\n      },\n      \"aggregations\" : {\n        \"fulltext\" : {\n          \"terms\" : {\n            \"field\" : \"_all\"\n          }\n        }\n      }\n    }\n  }\n}", request.toString());
    }

    @Test
    public void testAggregateSignificantTermsQuery() throws Exception {
        AggregateDescriptor aggDef = new AggregateDescriptor();
        aggDef.setType("significant_terms");
        aggDef.setId("source");
        aggDef.setDocumentField("dc:source");
        aggDef.setSearchField((PredicateFieldDefinition)new FieldDescriptor("advanced_search", "source_agg"));
        aggDef.setProperty("minDocCount", "10");
        NxQueryBuilder qb = new NxQueryBuilder(this.session).nxql("SELECT * FROM Document").addAggregate(AggregateFactory.create((AggregateDefinition)aggDef, null));
        SearchRequestBuilder request = this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME});
        qb.updateRequest(request);
        this.assertEqualsEvenUnderWindows("{\n  \"from\" : 0,\n  \"size\" : 10,\n  \"query\" : {\n    \"match_all\" : { }\n  },\n  \"fields\" : \"_id\",\n  \"aggregations\" : {\n    \"source_filter\" : {\n      \"filter\" : {\n        \"match_all\" : { }\n      },\n      \"aggregations\" : {\n        \"source\" : {\n          \"significant_terms\" : {\n            \"field\" : \"dc:source\",\n            \"min_doc_count\" : 10\n          }\n        }\n      }\n    }\n  }\n}", request.toString());
    }

    @Test
    public void testAggregateRangeQuery() throws Exception {
        AggregateDescriptor aggDef = new AggregateDescriptor();
        aggDef.setType("range");
        aggDef.setId("source");
        aggDef.setDocumentField("common:size");
        aggDef.setSearchField((PredicateFieldDefinition)new FieldDescriptor("advanced_search", "size_agg"));
        ArrayList<AggregateRangeDescriptor> ranges = new ArrayList<AggregateRangeDescriptor>();
        ranges.add(new AggregateRangeDescriptor("small", null, Double.valueOf(2048.0)));
        ranges.add(new AggregateRangeDescriptor("medium", Double.valueOf(2048.0), Double.valueOf(6144.0)));
        ranges.add(new AggregateRangeDescriptor("big", Double.valueOf(6144.0), null));
        aggDef.setRanges(ranges);
        NxQueryBuilder qb = new NxQueryBuilder(this.session).nxql("SELECT * FROM Document").addAggregate(AggregateFactory.create((AggregateDefinition)aggDef, null));
        SearchRequestBuilder request = this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME});
        qb.updateRequest(request);
        this.assertEqualsEvenUnderWindows("{\n  \"from\" : 0,\n  \"size\" : 10,\n  \"query\" : {\n    \"match_all\" : { }\n  },\n  \"fields\" : \"_id\",\n  \"aggregations\" : {\n    \"source_filter\" : {\n      \"filter\" : {\n        \"match_all\" : { }\n      },\n      \"aggregations\" : {\n        \"source\" : {\n          \"range\" : {\n            \"field\" : \"common:size\",\n            \"ranges\" : [ {\n              \"key\" : \"small\",\n              \"to\" : 2048.0\n            }, {\n              \"key\" : \"medium\",\n              \"from\" : 2048.0,\n              \"to\" : 6144.0\n            }, {\n              \"key\" : \"big\",\n              \"from\" : 6144.0\n            } ]\n          }\n        }\n      }\n    }\n  }\n}", request.toString());
    }

    @Test
    public void testAggregateRangeDateQuery() throws Exception {
        AggregateDescriptor aggDef = new AggregateDescriptor();
        aggDef.setType("date_range");
        aggDef.setId("created");
        aggDef.setDocumentField("dc:created");
        aggDef.setSearchField((PredicateFieldDefinition)new FieldDescriptor("advanced_search", "created_agg"));
        ArrayList<AggregateRangeDateDescriptor> ranges = new ArrayList<AggregateRangeDateDescriptor>();
        ranges.add(new AggregateRangeDateDescriptor("10monthAgo", null, "now-10M/M"));
        ranges.add(new AggregateRangeDateDescriptor("1monthAgo", "now-10M/M", "now-1M/M"));
        ranges.add(new AggregateRangeDateDescriptor("thisMonth", "now-1M/M", null));
        aggDef.setDateRanges(ranges);
        NxQueryBuilder qb = new NxQueryBuilder(this.session).nxql("SELECT * FROM Document").addAggregate(AggregateFactory.create((AggregateDefinition)aggDef, null));
        SearchRequestBuilder request = this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME});
        qb.updateRequest(request);
        this.assertEqualsEvenUnderWindows("{\n  \"from\" : 0,\n  \"size\" : 10,\n  \"query\" : {\n    \"match_all\" : { }\n  },\n  \"fields\" : \"_id\",\n  \"aggregations\" : {\n    \"created_filter\" : {\n      \"filter\" : {\n        \"match_all\" : { }\n      },\n      \"aggregations\" : {\n        \"created\" : {\n          \"date_range\" : {\n            \"field\" : \"dc:created\",\n            \"ranges\" : [ {\n              \"key\" : \"10monthAgo\",\n              \"to\" : \"now-10M/M\"\n            }, {\n              \"key\" : \"1monthAgo\",\n              \"from\" : \"now-10M/M\",\n              \"to\" : \"now-1M/M\"\n            }, {\n              \"key\" : \"thisMonth\",\n              \"from\" : \"now-1M/M\"\n            } ]\n          }\n        }\n      }\n    }\n  }\n}", request.toString());
    }

    @Test
    public void testAggregateHistogramQuery() throws Exception {
        AggregateDescriptor aggDef = new AggregateDescriptor();
        aggDef.setType("histogram");
        aggDef.setId("size");
        aggDef.setDocumentField("common:size");
        aggDef.setSearchField((PredicateFieldDefinition)new FieldDescriptor("advanced_search", "size_agg"));
        aggDef.setProperty("interval", "1024");
        aggDef.setProperty("extendedBoundsMin", "0");
        aggDef.setProperty("extendedBoundsMax", "10240");
        NxQueryBuilder qb = new NxQueryBuilder(this.session).nxql("SELECT * FROM Document").addAggregate(AggregateFactory.create((AggregateDefinition)aggDef, null));
        SearchRequestBuilder request = this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME});
        qb.updateRequest(request);
        this.assertEqualsEvenUnderWindows("{\n  \"from\" : 0,\n  \"size\" : 10,\n  \"query\" : {\n    \"match_all\" : { }\n  },\n  \"fields\" : \"_id\",\n  \"aggregations\" : {\n    \"size_filter\" : {\n      \"filter\" : {\n        \"match_all\" : { }\n      },\n      \"aggregations\" : {\n        \"size\" : {\n          \"histogram\" : {\n            \"field\" : \"common:size\",\n            \"interval\" : 1024,\n            \"extended_bounds\" : {\n              \"min\" : 0,\n              \"max\" : 10240\n            }\n          }\n        }\n      }\n    }\n  }\n}", request.toString());
    }

    @Test
    public void testAggregateDateHistogramQuery() throws Exception {
        AggregateDescriptor aggDef = new AggregateDescriptor();
        aggDef.setType("date_histogram");
        aggDef.setId("created");
        aggDef.setDocumentField("dc:created");
        aggDef.setSearchField((PredicateFieldDefinition)new FieldDescriptor("advanced_search", "created_agg"));
        aggDef.setProperty("interval", "month");
        aggDef.setProperty("order", "count desc");
        aggDef.setProperty("minDocCounts", "5");
        NxQueryBuilder qb = new NxQueryBuilder(this.session).nxql("SELECT * FROM Document").addAggregate(AggregateFactory.create((AggregateDefinition)aggDef, null));
        SearchRequestBuilder request = this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME});
        qb.updateRequest(request);
        this.assertEqualsEvenUnderWindows("{\n  \"from\" : 0,\n  \"size\" : 10,\n  \"query\" : {\n    \"match_all\" : { }\n  },\n  \"fields\" : \"_id\",\n  \"aggregations\" : {\n    \"created_filter\" : {\n      \"filter\" : {\n        \"match_all\" : { }\n      },\n      \"aggregations\" : {\n        \"created\" : {\n          \"date_histogram\" : {\n            \"field\" : \"dc:created\",\n            \"interval\" : \"month\",\n            \"order\" : {\n              \"_count\" : \"desc\"\n            }\n          }\n        }\n      }\n    }\n  }\n}", request.toString());
    }

    @Test
    public void testAggregateMultiAggregatesQuery() throws Exception {
        AggregateDescriptor aggDef1 = new AggregateDescriptor();
        aggDef1.setType("terms");
        aggDef1.setId("source");
        aggDef1.setDocumentField("dc:source");
        aggDef1.setSearchField((PredicateFieldDefinition)new FieldDescriptor("advanced_search", "source_agg"));
        AggregateDescriptor aggDef2 = new AggregateDescriptor();
        aggDef2.setType("terms");
        aggDef2.setId("nature");
        aggDef2.setDocumentField("dc:nature");
        aggDef2.setSearchField((PredicateFieldDefinition)new FieldDescriptor("advanced_search", "nature_agg"));
        aggDef2.setProperty("size", "10");
        DocumentModelImpl model = new DocumentModelImpl("/", TYPE_NAME, "AdvancedSearch");
        String[] sources = new String[]{"foo", "bar"};
        model.setProperty("advanced_search", "source_agg", (Object)sources);
        NxQueryBuilder qb = new NxQueryBuilder(this.session).nxql("SELECT * FROM Document").addAggregate(AggregateFactory.create((AggregateDefinition)aggDef1, (DocumentModel)model)).addAggregate(AggregateFactory.create((AggregateDefinition)aggDef2, (DocumentModel)model));
        SearchRequestBuilder request = this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME});
        qb.updateRequest(request);
        this.assertEqualsEvenUnderWindows("{\n  \"from\" : 0,\n  \"size\" : 10,\n  \"query\" : {\n    \"match_all\" : { }\n  },\n  \"post_filter\" : {\n    \"and\" : {\n      \"filters\" : [ {\n        \"terms\" : {\n          \"dc:source\" : [ \"foo\", \"bar\" ]\n        }\n      } ]\n    }\n  },\n  \"fields\" : \"_id\",\n  \"aggregations\" : {\n    \"source_filter\" : {\n      \"filter\" : {\n        \"match_all\" : { }\n      },\n      \"aggregations\" : {\n        \"source\" : {\n          \"terms\" : {\n            \"field\" : \"dc:source\"\n          }\n        }\n      }\n    },\n    \"nature_filter\" : {\n      \"filter\" : {\n        \"and\" : {\n          \"filters\" : [ {\n            \"terms\" : {\n              \"dc:source\" : [ \"foo\", \"bar\" ]\n            }\n          } ]\n        }\n      },\n      \"aggregations\" : {\n        \"nature\" : {\n          \"terms\" : {\n            \"field\" : \"dc:nature\",\n            \"size\" : 10\n          }\n        }\n      }\n    }\n  }\n}", request.toString());
    }

    @Test
    public void testAggregateOnComplexTypeQuery() throws Exception {
        AggregateDescriptor aggDef = new AggregateDescriptor();
        aggDef.setType("significant_terms");
        aggDef.setId("source");
        aggDef.setDocumentField("prefix:foo/bar");
        aggDef.setSearchField((PredicateFieldDefinition)new FieldDescriptor("advanced_search", "source_agg"));
        aggDef.setProperty("minDocCount", "10");
        NxQueryBuilder qb = new NxQueryBuilder(this.session).nxql("SELECT * FROM Document").addAggregate(AggregateFactory.create((AggregateDefinition)aggDef, null));
        SearchRequestBuilder request = this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME});
        qb.updateRequest(request);
        this.assertEqualsEvenUnderWindows("{\n  \"from\" : 0,\n  \"size\" : 10,\n  \"query\" : {\n    \"match_all\" : { }\n  },\n  \"fields\" : \"_id\",\n  \"aggregations\" : {\n    \"source_filter\" : {\n      \"filter\" : {\n        \"match_all\" : { }\n      },\n      \"aggregations\" : {\n        \"source\" : {\n          \"significant_terms\" : {\n            \"field\" : \"prefix:foo.bar\",\n            \"min_doc_count\" : 10\n          }\n        }\n      }\n    }\n  }\n}", request.toString());
    }

    @Test
    public void testPageProvider() throws Exception {
        this.buildDocs();
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("aggregates_1");
        Assert.assertNotNull((Object)ppdef);
        DocumentModelImpl model = new DocumentModelImpl("/", TYPE_NAME, "AdvancedSearch");
        String[] sources = new String[]{"Source1", "Source2"};
        model.setProperty("advanced_search", "source_agg", (Object)sources);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        PageProvider pp = pps.getPageProvider("aggregates_1", ppdef, (DocumentModel)model, null, null, Long.valueOf(0L), props, new Object[0]);
        Assert.assertEquals((long)7L, (long)pp.getAggregates().size());
        Assert.assertEquals((long)2L, (long)pp.getResultsCount());
        Assert.assertEquals((Object)"Aggregate(source, terms, dc:source, [Source1, Source2], [BucketTerm(Source0, 1), BucketTerm(Source1, 1), BucketTerm(Source2, 1), BucketTerm(Source3, 1), BucketTerm(Source4, 1)])", (Object)((Aggregate)pp.getAggregates().get("source")).toString());
        Assert.assertEquals((Object)"Aggregate(coverage, terms, dc:coverage, [], [BucketTerm(Coverage1, 1), BucketTerm(Coverage2, 1)])", (Object)((Aggregate)pp.getAggregates().get("coverage")).toString());
        Assert.assertEquals((Object)"Aggregate(nature, terms, dc:nature, [], [BucketTerm(Nature0, 1), BucketTerm(Nature1, 1)])", (Object)((Aggregate)pp.getAggregates().get("nature")).toString());
        Assert.assertEquals((Object)"Aggregate(size, range, common:size, [], [BucketRange(small, 1, -Infinity, 2048.00), BucketRange(medium, 1, 2048.00, 6144.00), BucketRange(big, 0, 6144.00, Infinity)])", (Object)((Aggregate)pp.getAggregates().get("size")).toString());
        Assert.assertEquals((Object)"Aggregate(size_histo, histogram, common:size, [], [BucketRange(1024, 1, 1024.00, 2048.00), BucketRange(2048, 1, 2048.00, 3072.00)])", (Object)((Aggregate)pp.getAggregates().get("size_histo")).toString());
        Assert.assertEquals((long)3L, (long)((Aggregate)pp.getAggregates().get("created")).getBuckets().size());
        Assert.assertEquals((long)2L, (long)((Aggregate)pp.getAggregates().get("created_histo")).getBuckets().size());
    }

    @Test
    public void testPageProviderWithRangeSelection() throws Exception {
        this.buildDocs();
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("aggregates_1");
        Assert.assertNotNull((Object)ppdef);
        DocumentModelImpl model = new DocumentModelImpl("/", TYPE_NAME, "AdvancedSearch");
        String[] sizes = new String[]{"big", "medium"};
        model.setProperty("advanced_search", "size_agg", (Object)sizes);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        PageProvider pp = pps.getPageProvider("aggregates_1", ppdef, (DocumentModel)model, null, null, Long.valueOf(0L), props, new Object[0]);
        Assert.assertEquals((long)7L, (long)pp.getAggregates().size());
        Assert.assertEquals((long)8L, (long)pp.getResultsCount());
        Assert.assertEquals((Object)"Aggregate(source, terms, dc:source, [], [BucketTerm(Source2, 1), BucketTerm(Source3, 1), BucketTerm(Source4, 1), BucketTerm(Source5, 1), BucketTerm(Source6, 1)])", (Object)((Aggregate)pp.getAggregates().get("source")).toString());
        Assert.assertEquals((Object)"Aggregate(coverage, terms, dc:coverage, [], [BucketTerm(Coverage0, 3), BucketTerm(Coverage2, 3), BucketTerm(Coverage1, 2)])", (Object)((Aggregate)pp.getAggregates().get("coverage")).toString());
        Assert.assertEquals((Object)"Aggregate(nature, terms, dc:nature, [], [BucketTerm(Nature0, 4), BucketTerm(Nature1, 4)])", (Object)((Aggregate)pp.getAggregates().get("nature")).toString());
        Assert.assertEquals((Object)"Aggregate(size, range, common:size, [big, medium], [BucketRange(small, 2, -Infinity, 2048.00), BucketRange(medium, 4, 2048.00, 6144.00), BucketRange(big, 4, 6144.00, Infinity)])", (Object)((Aggregate)pp.getAggregates().get("size")).toString());
    }

    @Test
    public void testPageProviderWithDateRangeSelection() throws Exception {
        this.buildDocs();
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("aggregates_1");
        Assert.assertNotNull((Object)ppdef);
        DocumentModelImpl model = new DocumentModelImpl("/", TYPE_NAME, "AdvancedSearch");
        String[] created = new String[]{"long_time_ago", "some_time_ago"};
        model.setProperty("advanced_search", "created_agg", (Object)created);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        PageProvider pp = pps.getPageProvider("aggregates_1", ppdef, (DocumentModel)model, null, null, Long.valueOf(0L), props, new Object[0]);
        Assert.assertEquals((long)7L, (long)pp.getAggregates().size());
        Assert.assertEquals((long)7L, (long)pp.getResultsCount());
        Assert.assertEquals((Object)"Aggregate(coverage, terms, dc:coverage, [], [BucketTerm(Coverage0, 3), BucketTerm(Coverage1, 2), BucketTerm(Coverage2, 2)])", (Object)((Aggregate)pp.getAggregates().get("coverage")).toString());
        Assert.assertEquals((Object)"Aggregate(nature, terms, dc:nature, [], [BucketTerm(Nature1, 4), BucketTerm(Nature0, 3)])", (Object)((Aggregate)pp.getAggregates().get("nature")).toString());
        List buckets = ((Aggregate)pp.getAggregates().get("created")).getBuckets();
        Assert.assertEquals((long)3L, (long)buckets.size());
        Assert.assertEquals((Object)"long_time_ago", (Object)((BucketRangeDate)buckets.get(0)).getKey());
        Assert.assertEquals((long)0L, (long)((BucketRangeDate)buckets.get(0)).getDocCount());
        Assert.assertEquals((long)7L, (long)((BucketRangeDate)buckets.get(1)).getDocCount());
        Assert.assertEquals((Object)"last_month", (Object)((BucketRangeDate)buckets.get(2)).getKey());
        Assert.assertEquals((long)3L, (long)((BucketRangeDate)buckets.get(2)).getDocCount());
    }

    @Test
    public void testPageProviderWithHistogramSelection() throws Exception {
        this.buildDocs();
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("aggregates_1");
        Assert.assertNotNull((Object)ppdef);
        DocumentModelImpl model = new DocumentModelImpl("/", TYPE_NAME, "AdvancedSearch");
        String[] sizes = new String[]{"1024", "4096"};
        model.setProperty("advanced_search", "size_histo_agg", (Object)sizes);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        PageProvider pp = pps.getPageProvider("aggregates_1", ppdef, (DocumentModel)model, null, null, Long.valueOf(0L), props, new Object[0]);
        Assert.assertEquals((long)7L, (long)pp.getAggregates().size());
        Assert.assertEquals((long)2L, (long)pp.getResultsCount());
        Assert.assertEquals((Object)"Aggregate(size_histo, histogram, common:size, [1024, 4096], [BucketRange(0, 1, 0.00, 1024.00), BucketRange(1024, 1, 1024.00, 2048.00), BucketRange(2048, 1, 2048.00, 3072.00), BucketRange(3072, 1, 3072.00, 4096.00), BucketRange(4096, 1, 4096.00, 5120.00), BucketRange(5120, 1, 5120.00, 6144.00), BucketRange(6144, 1, 6144.00, 7168.00), BucketRange(7168, 1, 7168.00, 8192.00), BucketRange(8192, 1, 8192.00, 9216.00), BucketRange(9216, 1, 9216.00, 10240.00)])", (Object)((Aggregate)pp.getAggregates().get("size_histo")).toString());
        Assert.assertEquals((Object)"Aggregate(source, terms, dc:source, [], [BucketTerm(Source1, 1), BucketTerm(Source4, 1)])", (Object)((Aggregate)pp.getAggregates().get("source")).toString());
    }

    @Test
    public void testPageProviderWithDateHistogramSelection() throws Exception {
        this.buildDocs();
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Assert.assertNotNull((Object)pps);
        PageProviderDefinition ppdef = pps.getPageProviderDefinition("aggregates_1");
        Assert.assertNotNull((Object)ppdef);
        DocumentModelImpl model = new DocumentModelImpl("/", TYPE_NAME, "AdvancedSearch");
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"dd-MM-yyy");
        DateTime yesterdayNoon = new DateTime(DateTimeZone.UTC).withTimeAtStartOfDay().minusDays(1).plusHours(12);
        String[] created = new String[]{fmt.print((ReadableInstant)new DateTime(yesterdayNoon.minusWeeks(3).getMillis())), fmt.print((ReadableInstant)new DateTime(yesterdayNoon.minusWeeks(6).getMillis()))};
        model.setProperty("advanced_search", "created_histo_agg", (Object)created);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        PageProvider pp = pps.getPageProvider("aggregates_1", ppdef, (DocumentModel)model, null, null, Long.valueOf(0L), props, new Object[0]);
        Assert.assertEquals((long)7L, (long)pp.getAggregates().size());
        Assert.assertEquals((long)2L, (long)pp.getResultsCount());
        Assert.assertEquals((Object)"Aggregate(size_histo, histogram, common:size, [], [BucketRange(3072, 1, 3072.00, 4096.00), BucketRange(6144, 1, 6144.00, 7168.00)])", (Object)((Aggregate)pp.getAggregates().get("size_histo")).toString());
        Assert.assertEquals((Object)"Aggregate(source, terms, dc:source, [], [BucketTerm(Source3, 1), BucketTerm(Source6, 1)])", (Object)((Aggregate)pp.getAggregates().get("source")).toString());
    }

    protected void assertEqualsEvenUnderWindows(String expected, String actual) {
        if (SystemUtils.IS_OS_WINDOWS) {
            expected = expected.trim();
            expected = expected.replace("\n", "");
            expected = expected.replace("\r", "");
            actual = actual.trim();
            actual = actual.replace("\n", "");
            actual = actual.replace("\r", "");
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

