/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test.commands;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.elasticsearch.commands.IndexingCommand;

public class TestIndexingCommand {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testConstructorOk() throws Exception {
        MockDocumentModel doc = new MockDocumentModel("foo");
        IndexingCommand cmd = new IndexingCommand((DocumentModel)doc, IndexingCommand.Type.INSERT, false, false);
        cmd = new IndexingCommand((DocumentModel)doc, IndexingCommand.Type.INSERT, true, false);
        Assert.assertTrue((boolean)cmd.isSync());
        Assert.assertFalse((boolean)cmd.isRecurse());
        cmd = new IndexingCommand((DocumentModel)doc, IndexingCommand.Type.INSERT, false, true);
        cmd = new IndexingCommand((DocumentModel)doc, IndexingCommand.Type.DELETE, true, true);
        Assert.assertTrue((boolean)cmd.isSync());
        Assert.assertTrue((boolean)cmd.isRecurse());
    }

    @Test
    public void testConstructorWithRecurseSync() throws Exception {
        MockDocumentModel doc = new MockDocumentModel("foo");
        this.exception.expect(IllegalArgumentException.class);
        IndexingCommand cmd = new IndexingCommand((DocumentModel)doc, IndexingCommand.Type.INSERT, true, true);
    }

    @Test
    public void testConstructorWithNullDoc() throws Exception {
        this.exception.expect(IllegalArgumentException.class);
        IndexingCommand cmd = new IndexingCommand(null, IndexingCommand.Type.INSERT, true, false);
    }

    @Test
    public void testConstructorWithNullDocId() throws Exception {
        MockDocumentModel doc = new MockDocumentModel(null);
        this.exception.expect(IllegalArgumentException.class);
        IndexingCommand cmd = new IndexingCommand((DocumentModel)doc, IndexingCommand.Type.INSERT, true, false);
    }

    @Test
    public void testAddSchemas() throws Exception {
        MockDocumentModel doc = new MockDocumentModel("foo");
        IndexingCommand cmd = new IndexingCommand((DocumentModel)doc, IndexingCommand.Type.INSERT, true, false);
        Assert.assertNull((Object)cmd.getSchemas());
        cmd.addSchemas("mySchema");
        Assert.assertEquals((long)1L, (long)cmd.getSchemas().length);
    }

    @Test
    public void testMakeSync() throws Exception {
        MockDocumentModel doc = new MockDocumentModel("foo");
        IndexingCommand cmd = new IndexingCommand((DocumentModel)doc, IndexingCommand.Type.INSERT, false, false);
        cmd.makeSync();
        Assert.assertTrue((boolean)cmd.isSync());
        cmd = new IndexingCommand((DocumentModel)doc, IndexingCommand.Type.INSERT, false, true);
        cmd.makeSync();
        Assert.assertFalse((boolean)cmd.isSync());
        cmd = new IndexingCommand((DocumentModel)doc, IndexingCommand.Type.DELETE, false, true);
        cmd.makeSync();
        Assert.assertTrue((boolean)cmd.isSync());
    }

    @Test
    public void testJson() throws Exception {
        MockDocumentModel doc = new MockDocumentModel("foo");
        IndexingCommand cmd = new IndexingCommand((DocumentModel)doc, IndexingCommand.Type.INSERT, false, true);
        String json = cmd.toJSON();
        IndexingCommand cmd2 = IndexingCommand.fromJSON((String)json);
        String json2 = cmd2.toJSON();
        Assert.assertEquals((Object)json, (Object)json2);
        Assert.assertTrue((boolean)cmd2.isRecurse());
    }

    @Test
    public void testInvalidJson() throws Exception {
        MockDocumentModel doc = new MockDocumentModel("foo");
        IndexingCommand cmd = new IndexingCommand((DocumentModel)doc, IndexingCommand.Type.INSERT, false, true);
        this.exception.expect(IllegalArgumentException.class);
        String json = "{" + cmd.toJSON();
        IndexingCommand.fromJSON((String)json);
    }

    @Test
    public void testInvalidJsonDocIdNull() throws Exception {
        String json = "{\"id\": \"124\", \"type\": \"INSERT\"}";
        this.exception.expect(IllegalArgumentException.class);
        IndexingCommand cmd = IndexingCommand.fromJSON((String)json);
    }

    public final class MockDocumentModel
    extends DocumentModelImpl {
        private static final long serialVersionUID = 1L;
        protected String uid;

        public MockDocumentModel(String uid) {
            this.uid = uid;
        }

        public String getId() {
            return this.uid;
        }

        public String toString() {
            return String.format("MockDoc(uid=%s)", this.uid);
        }
    }
}

