/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.commands.IndexingCommands;
import org.nuxeo.elasticsearch.commands.IndexingCommandsStacker;

public class TestIndexingCommandsStacker
extends IndexingCommandsStacker {
    protected Map<String, IndexingCommands> commands = new HashMap<String, IndexingCommands>();
    protected List<IndexingCommand> flushedSyncCommands;
    protected List<IndexingCommand> flushedAsyncCommands;

    protected Map<String, IndexingCommands> getAllCommands() {
        return this.commands;
    }

    protected boolean isSyncIndexingByDefault() {
        return false;
    }

    @Before
    public void reset() {
        this.flushedSyncCommands = new ArrayList<IndexingCommand>();
        this.flushedAsyncCommands = new ArrayList<IndexingCommand>();
    }

    protected void fireSyncIndexing(List<IndexingCommand> syncCommands) {
        this.flushedSyncCommands.addAll(syncCommands);
    }

    protected void fireAsyncIndexing(List<IndexingCommand> asyncCommands) {
        this.flushedAsyncCommands.addAll(asyncCommands);
    }

    protected void flushCommands() {
        Map<String, IndexingCommands> allCmds = this.getAllCommands();
        ArrayList<IndexingCommand> syncCommands = new ArrayList<IndexingCommand>();
        ArrayList<IndexingCommand> asyncCommands = new ArrayList<IndexingCommand>();
        for (IndexingCommands cmds : allCmds.values()) {
            for (IndexingCommand cmd : cmds.getCommands()) {
                if (cmd.isSync()) {
                    syncCommands.add(cmd);
                    continue;
                }
                asyncCommands.add(cmd);
            }
        }
        this.getAllCommands().clear();
        if (syncCommands.size() > 0) {
            this.fireSyncIndexing(syncCommands);
        }
        if (asyncCommands.size() > 0) {
            this.fireAsyncIndexing(asyncCommands);
        }
    }

    @Test
    public void shouldRemoveDuplicatedEvents() throws Exception {
        MockDocumentModel doc1 = new MockDocumentModel("1");
        MockDocumentModel doc2 = new MockDocumentModel("2");
        MockDocumentModel doc3 = new MockDocumentModel("3");
        this.stackCommand((DocumentModel)doc1, "documentCreated", false);
        this.stackCommand((DocumentModel)doc1, "beforeDocumentModification", false);
        this.stackCommand((DocumentModel)doc2, "beforeDocumentModification", false);
        this.stackCommand((DocumentModel)doc2, "beforeDocumentModification", false);
        this.stackCommand((DocumentModel)doc2, "beforeDocumentModification", false);
        this.stackCommand((DocumentModel)doc3, "documentCreated", false);
        this.stackCommand((DocumentModel)doc3, "beforeDocumentModification", false);
        this.stackCommand((DocumentModel)doc3, "documentRemoved", false);
        Assert.assertEquals((long)3L, (long)this.commands.size());
        IndexingCommands ic1 = this.getCommands((DocumentModel)doc1);
        Assert.assertEquals((long)1L, (long)ic1.getCommands().size());
        Assert.assertTrue((boolean)ic1.contains(IndexingCommand.Type.INSERT));
        Assert.assertEquals((Object)IndexingCommand.Type.INSERT, (Object)((IndexingCommand)ic1.getCommands().get(0)).getType());
        IndexingCommands ic2 = this.getCommands((DocumentModel)doc2);
        Assert.assertEquals((long)1L, (long)ic2.getCommands().size());
        Assert.assertTrue((boolean)ic2.contains(IndexingCommand.Type.UPDATE));
        Assert.assertEquals((Object)IndexingCommand.Type.UPDATE, (Object)((IndexingCommand)ic2.getCommands().get(0)).getType());
        IndexingCommands ic3 = this.getCommands((DocumentModel)doc3);
        Assert.assertEquals((long)0L, (long)ic3.getCommands().size());
        this.flushCommands();
        Assert.assertEquals((long)0L, (long)this.flushedSyncCommands.size());
        Assert.assertEquals((long)2L, (long)this.flushedAsyncCommands.size());
    }

    @Test
    public void shouldMergeDuplicatedEventsAndSwitchToSync() throws Exception {
        MockDocumentModel doc1 = new MockDocumentModel("1");
        MockDocumentModel doc2 = new MockDocumentModel("2");
        this.stackCommand((DocumentModel)doc1, "beforeDocumentModification", false);
        this.stackCommand((DocumentModel)doc1, "beforeDocumentModification", true);
        this.stackCommand((DocumentModel)doc2, "documentCreated", false);
        this.stackCommand((DocumentModel)doc2, "beforeDocumentModification", false);
        this.stackCommand((DocumentModel)doc2, "beforeDocumentModification", true);
        Assert.assertEquals((long)2L, (long)this.commands.size());
        IndexingCommands ic1 = this.getCommands((DocumentModel)doc1);
        Assert.assertEquals((long)1L, (long)ic1.getCommands().size());
        Assert.assertTrue((boolean)ic1.contains(IndexingCommand.Type.UPDATE));
        Assert.assertEquals((Object)IndexingCommand.Type.UPDATE, (Object)((IndexingCommand)ic1.getCommands().get(0)).getType());
        Assert.assertTrue((boolean)((IndexingCommand)ic1.getCommands().get(0)).isSync());
        IndexingCommands ic2 = this.getCommands((DocumentModel)doc2);
        Assert.assertEquals((long)1L, (long)ic2.getCommands().size());
        Assert.assertTrue((boolean)ic2.contains(IndexingCommand.Type.INSERT));
        Assert.assertEquals((Object)IndexingCommand.Type.INSERT, (Object)((IndexingCommand)ic2.getCommands().get(0)).getType());
        Assert.assertTrue((boolean)((IndexingCommand)ic2.getCommands().get(0)).isSync());
        this.flushCommands();
        Assert.assertEquals((long)2L, (long)this.flushedSyncCommands.size());
        Assert.assertEquals((long)0L, (long)this.flushedAsyncCommands.size());
    }

    @Test
    public void shouldRecurseReindex() throws Exception {
        MockDocumentModel doc1 = new MockDocumentModel("1", true);
        MockDocumentModel doc2 = new MockDocumentModel("2", true);
        this.stackCommand((DocumentModel)doc1, "documentMoved", false);
        this.stackCommand((DocumentModel)doc2, "documentSecurityUpdated", false);
        IndexingCommands ic1 = this.getCommands((DocumentModel)doc1);
        Assert.assertEquals((long)1L, (long)ic1.getCommands().size());
        Assert.assertTrue((boolean)ic1.contains(IndexingCommand.Type.UPDATE));
        Assert.assertEquals((Object)IndexingCommand.Type.UPDATE, (Object)((IndexingCommand)ic1.getCommands().get(0)).getType());
        Assert.assertTrue((boolean)((IndexingCommand)ic1.getCommands().get(0)).isRecurse());
        IndexingCommands ic2 = this.getCommands((DocumentModel)doc2);
        Assert.assertEquals((long)1L, (long)ic2.getCommands().size());
        Assert.assertTrue((boolean)ic2.contains(IndexingCommand.Type.UPDATE_SECURITY));
        Assert.assertEquals((Object)IndexingCommand.Type.UPDATE_SECURITY, (Object)((IndexingCommand)ic2.getCommands().get(0)).getType());
        Assert.assertTrue((boolean)((IndexingCommand)ic2.getCommands().get(0)).isRecurse());
        this.flushCommands();
        Assert.assertEquals((long)0L, (long)this.flushedSyncCommands.size());
        Assert.assertEquals((long)2L, (long)this.flushedAsyncCommands.size());
    }

    @Test
    public void shouldRecurseReindexInSync() throws Exception {
        MockDocumentModel doc1 = new MockDocumentModel("1", true);
        MockDocumentModel doc2 = new MockDocumentModel("2", true);
        this.stackCommand((DocumentModel)doc1, "documentMoved", true);
        IndexingCommands ic1 = this.getCommands((DocumentModel)doc1);
        Assert.assertEquals((long)2L, (long)ic1.getCommands().size());
        Assert.assertTrue((boolean)ic1.contains(IndexingCommand.Type.UPDATE));
        Assert.assertEquals((Object)IndexingCommand.Type.UPDATE, (Object)((IndexingCommand)ic1.getCommands().get(0)).getType());
        Assert.assertFalse((boolean)((IndexingCommand)ic1.getCommands().get(0)).isRecurse());
        Assert.assertTrue((boolean)((IndexingCommand)ic1.getCommands().get(1)).isRecurse());
        this.flushCommands();
        Assert.assertEquals((long)1L, (long)this.flushedSyncCommands.size());
        Assert.assertEquals((long)1L, (long)this.flushedAsyncCommands.size());
    }

    public final class MockDocumentModel
    extends DocumentModelImpl {
        private static final long serialVersionUID = 1L;
        protected String uid;
        protected boolean folder = false;

        public MockDocumentModel(String uid) {
            this(uid, false);
        }

        public MockDocumentModel(String uid, boolean folder) {
            this.uid = uid;
            this.folder = folder;
        }

        public String getId() {
            return this.uid;
        }

        public boolean isFolder() {
            return this.folder;
        }
    }
}

