/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test.io;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.jaxrs.io.documents.JsonESDocumentWriter;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.io.DocumentModelReaders;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@LocalDeploy(value={"org.nuxeo.elasticsearch.core:elasticsearch-test-contrib.xml"})
public class TestDocumentModelReader {
    @Inject
    protected CoreSession session;
    @Inject
    ElasticSearchAdmin esa;

    @Before
    public void setupIndex() throws Exception {
        this.esa.initIndexes(true);
    }

    @Test
    public void ICanReadADocModelFromJson() throws Exception {
        String json = "{\"ecm:versionLabel\":\"0.0\",\"common:icon-expanded\":null,\"common:size\":null,\"ecm:currentLifeCycleState\":\"project\",\"ecm:changeToken\":null,\"ecm:uuid\":\"56ca3935-c6c9-4cd4-ac23-d9df5ebf340a\",\"dc:nature\":\"Nature0\",\"dc:created\":null,\"relatedtext:relatedtextresources\":[],\"dc:description\":null,\"dc:rights\":\"Rights0\",\"file:content\":null,\"uid:uid\":null,\"files:files\":[],\"ecm:acl\":[\"administrators\",\"Administrator\",\"members\"],\"dc:subjects\":[],\"file:filename\":null,\"dc:format\":null,\"dc:valid\":null,\"ecm:path\":\"/root/my/path/file0\",\"ecm:mixinType\":[\"Downloadable\",\"Commentable\",\"Versionable\",\"Publishable\",\"HasRelatedText\"],\"ecm:isProxy\":false,\"ecm:isCheckedIn\":false,\"dc:title\":\"File Title\",\"dc:lastContributor\":null,\"ecm:repository\":\"test\",\"common:icon\":null,\"dc:creator\":null,\"ecm:primaryType\":\"File\",\"dc:contributors\":[],\"dc:source\":null,\"ecm:name\":\"file0\",\"dc:publisher\":null,\"uid:major_version\":\"0\",\"ecm:parentId\":\"35cef677-f721-47b8-ab6b-050dbe257d0d\",\"ecm:isVersion\":false,\"uid:minor_version\":\"0\",\"dc:issued\":null,\"ecm:title\":\"File Title\",\"dc:modified\":null,\"dc:expired\":null,\"dc:coverage\":null,\"dc:language\":null}";
        DocumentModel doc = DocumentModelReaders.fromJson((String)json).getDocumentModel();
        Assert.assertNotNull((Object)doc);
        Assert.assertEquals((Object)"56ca3935-c6c9-4cd4-ac23-d9df5ebf340a", (Object)doc.getId());
        Assert.assertEquals((Object)"project", (Object)doc.getCurrentLifeCycleState());
        Assert.assertEquals((Object)"file0", (Object)doc.getName());
        Assert.assertEquals((Object)"/root/my/path/file0", (Object)doc.getPathAsString());
        Assert.assertEquals((Object)"test", (Object)doc.getRepositoryName());
        Assert.assertNull((Object)doc.getSessionId());
        Assert.assertFalse((boolean)doc.isProxy());
        Assert.assertFalse((boolean)doc.isFolder());
        Assert.assertFalse((boolean)doc.isVersion());
        Assert.assertFalse((boolean)doc.isLocked());
        Assert.assertEquals((Object)"File Title", (Object)doc.getTitle());
        Assert.assertNotNull((Object)doc.getParentRef());
        Assert.assertTrue((boolean)doc.isImmutable());
        Assert.assertEquals((Object)"File", (Object)doc.getType());
    }

    @Test
    public void ICanReadADocModelFromSource() throws Exception {
        HashMap<String, String> source = new HashMap<String, String>();
        source.put("ecm:uuid", "001");
        source.put("ecm:primaryType", "File");
        DocumentModel doc = DocumentModelReaders.fromSource(source).getDocumentModel();
        Assert.assertNotNull((Object)doc);
        Assert.assertEquals((Object)doc.getId(), (Object)"001");
        Assert.assertEquals((Object)"File", (Object)doc.getType());
        Assert.assertFalse((boolean)doc.isFolder());
    }

    @Test
    public void IGetTheSameDocAsVcs() throws Exception {
        DocumentModel doc = this.session.createDocumentModel("/", "somefile", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"Some file"));
        this.session.createDocument(doc);
        this.session.save();
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
        Assert.assertTrue((boolean)wm.awaitCompletion(20L, TimeUnit.SECONDS));
        this.esa.refresh();
        ElasticSearchService ess = (ElasticSearchService)Framework.getLocalService(ElasticSearchService.class);
        DocumentModelList docs = ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM File").fetchFromElasticsearch());
        Assert.assertEquals((long)1L, (long)docs.totalSize());
        DocumentModel esDoc = (DocumentModel)docs.get(0);
        Assert.assertNotNull((Object)esDoc);
        docs = ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM File").fetchFromDatabase());
        DocumentModel vcsDoc = (DocumentModel)docs.get(0);
        Assert.assertNotNull((Object)esDoc);
        Assert.assertEquals((Object)vcsDoc, (Object)esDoc);
        JsonFactory factory = new JsonFactory();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonGenerator jsonGen = factory.createJsonGenerator((OutputStream)out);
        new JsonESDocumentWriter().writeESDocument(jsonGen, esDoc, null, null);
        String esJson = ((Object)out).toString();
        out = new ByteArrayOutputStream();
        jsonGen = factory.createJsonGenerator((OutputStream)out);
        new JsonESDocumentWriter().writeESDocument(jsonGen, vcsDoc, null, null);
        String vcsJson = ((Object)out).toString();
        Assert.assertEquals((Object)vcsJson, (Object)esJson);
    }
}

