/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test.nxql;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@LocalDeploy(value={"org.nuxeo.elasticsearch.core:elasticsearch-test-contrib.xml"})
@RepositoryConfig(cleanup=Granularity.METHOD)
public class TestCompareCoreWithES {
    @Inject
    protected CoreSession session;
    @Inject
    protected ElasticSearchService ess;
    @Inject
    protected ElasticSearchAdmin esa;
    @Inject
    protected ElasticSearchIndexing esi;
    private String proxyPath;

    @Before
    public void initWorkingDocuments() throws Exception {
        DocumentModel doc;
        String name;
        int i;
        if (!TransactionHelper.isTransactionActive()) {
            TransactionHelper.startTransaction();
        }
        for (i = 0; i < 5; ++i) {
            name = "file" + i;
            doc = this.session.createDocumentModel("/", name, "File");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("File" + i)));
            doc.setPropertyValue("dc:nature", (Serializable)((Object)("Nature" + i)));
            doc.setPropertyValue("dc:rights", (Serializable)((Object)("Rights" + i % 2)));
            doc = this.session.createDocument(doc);
        }
        for (i = 5; i < 10; ++i) {
            name = "note" + i;
            doc = this.session.createDocumentModel("/", name, "Note");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("Note" + i)));
            doc.setPropertyValue("note:note", (Serializable)((Object)("Content" + i)));
            doc.setPropertyValue("dc:nature", (Serializable)((Object)("Nature" + i)));
            doc.setPropertyValue("dc:rights", (Serializable)((Object)("Rights" + i % 2)));
            doc = this.session.createDocument(doc);
        }
        DocumentModel doc2 = this.session.createDocumentModel("/", "hidden", "HiddenFolder");
        doc2.setPropertyValue("dc:title", (Serializable)((Object)"HiddenFolder"));
        doc2 = this.session.createDocument(doc2);
        DocumentModel folder = this.session.createDocumentModel("/", "folder", "Folder");
        folder.setPropertyValue("dc:title", (Serializable)((Object)"Folder"));
        folder = this.session.createDocument(folder);
        DocumentModel file = this.session.getDocument((DocumentRef)new PathRef("/file3"));
        DocumentModel proxy = this.session.publishDocument(file, folder);
        this.proxyPath = proxy.getPathAsString();
        this.session.followTransition((DocumentRef)new PathRef("/file1"), "delete");
        this.session.followTransition((DocumentRef)new PathRef("/note5"), "delete");
        this.session.checkIn((DocumentRef)new PathRef("/file2"), VersioningOption.MINOR, "for testing");
        TransactionHelper.commitOrRollbackTransaction();
        ((WorkManager)Framework.getLocalService(WorkManager.class)).awaitCompletion(20L, TimeUnit.SECONDS);
        this.esa.prepareWaitForIndexing().get(20L, TimeUnit.SECONDS);
        this.esa.refresh();
        Assert.assertEquals((long)0L, (long)this.esa.getPendingWorkerCount());
        TransactionHelper.startTransaction();
    }

    @Before
    public void setupIndex() throws Exception {
        this.esa.initIndexes(true);
    }

    @After
    public void cleanWorkingDocuments() throws Exception {
        this.session.removeDocument((DocumentRef)new PathRef(this.proxyPath));
    }

    protected String getDigest(DocumentModelList docs) {
        StringBuilder sb = new StringBuilder();
        for (DocumentModel doc : docs) {
            String nameOrTitle = doc.getName();
            if (nameOrTitle == null || nameOrTitle.isEmpty()) {
                nameOrTitle = doc.getTitle();
            }
            sb.append(nameOrTitle);
            sb.append(",");
        }
        return sb.toString();
    }

    protected void assertSameDocumentLists(DocumentModelList expected, DocumentModelList actual) throws Exception {
        Assert.assertEquals((Object)this.getDigest(expected), (Object)this.getDigest(actual));
    }

    protected void dump(DocumentModelList docs) {
        for (DocumentModel doc : docs) {
            System.out.println(doc);
        }
    }

    protected void compareESAndCore(String nxql) throws Exception {
        DocumentModelList coreResult = this.session.query(nxql);
        DocumentModelList esResult = this.ess.query(new NxQueryBuilder(this.session).nxql(nxql).limit(20));
        try {
            this.assertSameDocumentLists(coreResult, esResult);
        }
        catch (AssertionError e) {
            System.out.println("Error while executing " + nxql);
            System.out.println("Core result : ");
            this.dump(coreResult);
            System.out.println("elasticsearch result : ");
            this.dump(esResult);
            throw e;
        }
    }

    protected void testQueries(String[] testQueries) throws Exception {
        for (String nxql : testQueries) {
            this.compareESAndCore(nxql);
        }
    }

    @Test
    public void testSimpleSearchWithSort() throws Exception {
        this.testQueries(new String[]{"select * from Document order by dc:title, dc:created", "select * from Document where ecm:currentLifeCycleState != 'deleted' order by dc:title", "select * from File order by dc:title"});
    }

    @Test
    public void testSearchOnProxies() throws Exception {
        this.testQueries(new String[]{"select * from Document where ecm:isProxy=0 order by dc:title", "select * from Document where ecm:isProxy=1 order by dc:title"});
    }

    @Test
    public void testSearchOnVersions() throws Exception {
        this.testQueries(new String[]{"select * from Document where ecm:isVersion = 0 order by dc:title", "select * from Document where ecm:isVersion = 1 order by dc:title", "select * from Document where ecm:isCheckedInVersion = 0 order by dc:title", "select * from Document where ecm:isCheckedInVersion = 1 order by dc:title"});
    }

    @Test
    public void testSearchOnTypes() throws Exception {
        this.testQueries(new String[]{"select * from File order by dc:title", "select * from Folder order by dc:title", "select * from Note order by dc:title", "select * from Note where ecm:primaryType IN ('Note', 'Folder') order by dc:title", "select * from Document where ecm:mixinType = 'Folderish' order by dc:title", "select * from Document where ecm:mixinType != 'Folderish' order by dc:title"});
    }

    @Test
    public void testSearchWithLike() throws Exception {
        this.testQueries(new String[]{"SELECT * FROM Document WHERE dc:title LIKE 'nomatch%'", "SELECT * from Document WHERE dc:title LIKE 'File%' ORDER BY dc:title", "SELECT * from Document WHERE dc:title LIKE '%ile%' ORDER BY dc:title", "SELECT * from Document WHERE dc:title NOT LIKE '%ile%' ORDER BY dc:title", "SELECT * from Document WHERE dc:title NOT LIKE '%i%e%' ORDER BY dc:title"});
    }

    @Test
    public void testSearchWithStartsWith() throws Exception {
        this.testQueries(new String[]{"SELECT * from Document WHERE ecm:path STARTSWITH '/nomatch' ORDER BY dc:title", "SELECT * from Document WHERE ecm:path STARTSWITH '/folder' AND ecm:path != '/folder' ORDER BY dc:title", "SELECT * FROM Document WHERE ecm:path STARTSWITH '/' AND ecm:isVersion = 0 ORDER BY dc:title"});
    }

    @Test
    public void testSearchWithAncestorId() throws Exception {
        DocumentModel folder = this.session.getDocument((DocumentRef)new PathRef("/folder"));
        Assert.assertNotNull((Object)folder);
        String fid = folder.getId();
        this.testQueries(new String[]{"SELECT * from Document WHERE ecm:ancestorId = 'non-esisting-id' ORDER BY dc:title", "SELECT * from Document WHERE ecm:ancestorId != 'non-existing-id' ORDER BY dc:title", "SELECT * FROM Document WHERE ecm:ancestorId = '" + fid + "' ORDER BY dc:title"});
    }
}

