/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test.nxql;

import com.google.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.api.EsResult;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@LocalDeploy(value={"org.nuxeo.elasticsearch.core:elasticsearch-test-contrib.xml"})
@RepositoryConfig(cleanup=Granularity.METHOD)
public class TestCompareQueryAndFetch {
    @Inject
    protected CoreFeature coreFeature;
    @Inject
    protected CoreSession session;
    @Inject
    protected ElasticSearchService ess;
    @Inject
    protected ElasticSearchAdmin esa;
    @Inject
    protected ElasticSearchIndexing esi;
    private String proxyPath;

    @Before
    public void initWorkingDocuments() throws Exception {
        DocumentModel doc;
        String name;
        int i;
        if (!TransactionHelper.isTransactionActive()) {
            TransactionHelper.startTransaction();
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.set(2000, 0, 2, 3, 4, 5);
        cal.set(14, 6);
        for (i = 0; i < 5; ++i) {
            name = "file" + i;
            doc = this.session.createDocumentModel("/", name, "File");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("File" + i)));
            doc.setPropertyValue("dc:nature", (Serializable)((Object)("Nature" + i)));
            doc.setPropertyValue("dc:rights", (Serializable)((Object)("Rights" + i % 2)));
            doc.setPropertyValue("dc:issued", (Serializable)cal);
            doc = this.session.createDocument(doc);
        }
        for (i = 5; i < 10; ++i) {
            name = "note" + i;
            doc = this.session.createDocumentModel("/", name, "Note");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("Note" + i)));
            doc.setPropertyValue("note:note", (Serializable)((Object)("Content" + i)));
            doc.setPropertyValue("dc:nature", (Serializable)((Object)("Nature" + i)));
            doc.setPropertyValue("dc:rights", (Serializable)((Object)("Rights" + i % 2)));
            doc = this.session.createDocument(doc);
        }
        DocumentModel doc2 = this.session.createDocumentModel("/", "hidden", "HiddenFolder");
        doc2.setPropertyValue("dc:title", (Serializable)((Object)"HiddenFolder"));
        doc2 = this.session.createDocument(doc2);
        DocumentModel folder = this.session.createDocumentModel("/", "folder", "Folder");
        folder.setPropertyValue("dc:title", (Serializable)((Object)"Folder"));
        folder = this.session.createDocument(folder);
        DocumentModel file = this.session.getDocument((DocumentRef)new PathRef("/file3"));
        DocumentModel proxy = this.session.publishDocument(file, folder);
        this.proxyPath = proxy.getPathAsString();
        this.session.followTransition((DocumentRef)new PathRef("/file1"), "delete");
        this.session.followTransition((DocumentRef)new PathRef("/note5"), "delete");
        this.session.checkIn((DocumentRef)new PathRef("/file2"), VersioningOption.MINOR, "for testing");
        TransactionHelper.commitOrRollbackTransaction();
        WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
        Assert.assertTrue((boolean)wm.awaitCompletion(20L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)this.esa.getPendingWorkerCount());
        this.esa.refresh();
        TransactionHelper.startTransaction();
    }

    @After
    public void cleanWorkingDocuments() throws Exception {
        this.session.removeDocument((DocumentRef)new PathRef(this.proxyPath));
    }

    protected String getDigest(IterableQueryResult docs) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (Map doc : docs) {
            ArrayList keys = new ArrayList(doc.keySet());
            Collections.sort(keys);
            LinkedHashMap<String, Serializable> sortedMap = new LinkedHashMap<String, Serializable>();
            for (String key : keys) {
                Object value = (Serializable)doc.get(key);
                if (value instanceof Calendar) {
                    value = String.format("%tFT%<tT.%<tL%<tz", (Calendar)value);
                }
                if (this.coreFeature.getStorageConfiguration().isDBSMongoDB() && (key.equals("ecm:name") || key.equals("ecm:parentId") || value == null)) continue;
                sortedMap.put(key, (Serializable)value);
            }
            sb.append(sortedMap.entrySet().toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    protected void assertSameDocumentLists(IterableQueryResult expected, IterableQueryResult actual) throws Exception {
        Assert.assertEquals((Object)this.getDigest(expected), (Object)this.getDigest(actual));
    }

    protected void compareESAndCore(String nxql) throws Exception {
        IterableQueryResult coreResult = this.session.queryAndFetch(nxql, "NXQL", new Object[0]);
        EsResult esRes = this.ess.queryAndAggregate(new NxQueryBuilder(this.session).nxql(nxql).limit(20));
        IterableQueryResult esResult = esRes.getRows();
        this.assertSameDocumentLists(coreResult, esResult);
        coreResult.close();
        esResult.close();
    }

    @Test
    public void testSimpleSearchWithSort() throws Exception {
        this.compareESAndCore("select ecm:uuid, dc:title, dc:nature from Document order by ecm:uuid");
        this.compareESAndCore("select ecm:uuid, dc:title from Document where ecm:currentLifeCycleState != 'deleted' order by ecm:uuid");
        this.compareESAndCore("select ecm:uuid, dc:nature from File order by dc:nature, ecm:uuid");
    }
}

