/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test.rest;

import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.JsonNode;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.jaxrs.io.documents.PaginableDocumentModelListImpl;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.restapi.test.BaseTest;
import org.nuxeo.ecm.restapi.test.RestServerFeature;
import org.nuxeo.ecm.restapi.test.RestServerInit;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.provider.ElasticSearchNxqlPageProvider;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.Jetty;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={RestServerFeature.class, RepositoryElasticSearchFeature.class})
@Jetty(port=18090)
@Deploy(value={"org.nuxeo.ecm.platform.contentview.jsf"})
@LocalDeploy(value={"org.nuxeo.ecm.platform.restapi.test:pageprovider-test-contrib.xml", "org.nuxeo.ecm.platform.restapi.test:elasticsearch-test-contrib.xml", "org.nuxeo.elasticsearch.core:contentviews-test-contrib.xml", "org.nuxeo.elasticsearch.core:contentviews-coretype-test-contrib.xml", "org.nuxeo.elasticsearch.core:pageprovider-search-test-contrib.xml"})
@RepositoryConfig(cleanup=Granularity.METHOD, init=RestServerInit.class)
public class RestESDocumentsTest
extends BaseTest {
    public static final String QUERY = "select * from Document where ecm:currentLifeCycleState <> 'deleted'";
    @Inject
    PageProviderService pageProviderService;
    @Inject
    AutomationService automationService;

    @Test
    public void iCanBrowseTheRepoByItsId() throws Exception {
        DocumentModel doc = RestServerInit.getNote((int)0, (CoreSession)this.session);
        ClientResponse response = this.getResponse(BaseTest.RequestType.GETES, "id/" + doc.getId());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        JsonNode node = this.mapper.readTree(response.getEntityInputStream());
        Assert.assertEquals((Object)"Note 0", (Object)node.get("note:note").getTextValue());
    }

    @Test
    public void iCanPerformESQLPageProviderOnRepository() throws IOException, InterruptedException {
        ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getLocalService(ElasticSearchAdmin.class);
        WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
        Assert.assertTrue((boolean)wm.awaitCompletion(20L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)esa.getPendingWorkerCount());
        esa.refresh();
        Assert.assertTrue((boolean)wm.awaitCompletion(20L, TimeUnit.SECONDS));
        ClientResponse response = this.getResponse(BaseTest.RequestType.GET, "query/aggregates_2");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        JsonNode node = this.mapper.readTree(response.getEntityInputStream());
        Assert.assertEquals((long)15L, (long)this.getLogEntries(node).size());
        Assert.assertEquals((Object)"terms", (Object)node.get("aggregations").get("coverage").get("type").getTextValue());
    }

    @Test
    public void isQueryEndpointCanSwitchToES() {
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        PageProviderDefinition ppdefinition = this.pageProviderService.getPageProviderDefinition("REST_API_SEARCH_ADAPTER");
        ppdefinition.setPattern(QUERY);
        ppdefinition.getProperties().put("maxResults", "1");
        PaginableDocumentModelListImpl res = new PaginableDocumentModelListImpl(this.pageProviderService.getPageProvider("REST_API_SEARCH_ADAPTER", ppdefinition, null, null, null, null, props, null), null);
        if (!(res.getProvider() instanceof ElasticSearchNxqlPageProvider)) {
            Assert.fail((String)"Should be an elastic search page provider");
        }
    }

    @Test
    public void iCanPerformESQLPageProviderOperationOnRepository() throws Exception {
        OperationContext ctx = new OperationContext(this.session);
        HashMap<String, String> params = new HashMap<String, String>();
        String providerName = "default_search";
        params.put("providerName", providerName);
        HashMap<String, String> namedParameters = new HashMap<String, String>();
        namedParameters.put("defaults:dc_nature_agg", "[\"article\"]");
        Properties namedProperties = new Properties(namedParameters);
        params.put("namedParameters", (String)namedProperties);
        PaginableDocumentModelListImpl result = (PaginableDocumentModelListImpl)this.automationService.run(ctx, "Repository.PageProvider", params);
        Assert.assertEquals((long)20L, (long)result.getPageSize());
        Assert.assertEquals((long)11L, (long)result.size());
    }
}

