/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobDispatcher;
import org.nuxeo.ecm.core.model.Document;

public class DummyBlobDispatcher
implements BlobDispatcher {
    private static final String PROVIDERS = "providers";
    private String defaultProvider;
    private String secondProvider;

    public void initialize(Map<String, String> properties) {
        String list = properties.get(PROVIDERS);
        if (StringUtils.isBlank((String)list)) {
            throw new NuxeoException("empty providers");
        }
        String[] providers = list.split(" ");
        if (providers.length != 2) {
            throw new NuxeoException("needs exactly 2 providers");
        }
        this.defaultProvider = providers[0];
        this.secondProvider = providers[1];
    }

    public Collection<String> getBlobProviderIds() {
        return Arrays.asList(this.defaultProvider, this.secondProvider);
    }

    public String getBlobProvider(String repositoryName) {
        throw new NuxeoException("All blob keys should be prefixed in repository: " + repositoryName);
    }

    public BlobDispatcher.BlobDispatch getBlobProvider(Document doc, Blob blob) {
        String provider = blob.getMimeType().startsWith("video/") ? this.secondProvider : this.defaultProvider;
        return new BlobDispatcher.BlobDispatch(provider, true);
    }

    public void notifyChanges(Document doc, Set<String> xpaths) {
    }
}

