/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.blob.AbstractBlobProvider;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.SimpleManagedBlob;
import org.nuxeo.ecm.core.model.Document;

public class DummyBlobProvider
extends AbstractBlobProvider {
    protected Map<String, byte[]> blobs;
    protected AtomicLong counter;

    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        super.initialize(blobProviderId, properties);
        this.blobs = new HashMap<String, byte[]>();
        this.counter = new AtomicLong();
    }

    public void close() {
        this.blobs.clear();
    }

    public Blob readBlob(BlobManager.BlobInfo blobInfo) {
        return new SimpleManagedBlob(blobInfo){
            private static final long serialVersionUID = 1L;

            public InputStream getStream() throws IOException {
                int colon = this.key.indexOf(58);
                String k = colon < 0 ? this.key : this.key.substring(colon + 1);
                byte[] bytes = DummyBlobProvider.this.blobs.get(k);
                return new ByteArrayInputStream(bytes);
            }
        };
    }

    public String writeBlob(Blob blob, Document doc) throws IOException {
        byte[] bytes;
        try (InputStream in = blob.getStream();){
            bytes = IOUtils.toByteArray((InputStream)in);
        }
        String k = String.valueOf(this.counter.incrementAndGet());
        this.blobs.put(k, bytes);
        return k;
    }
}

