/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.InputStream;
import java.util.Collections;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobManagerFeature;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.runtime.mockito.MockitoFeature;
import org.nuxeo.runtime.mockito.RuntimeService;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={BlobManagerFeature.class, MockitoFeature.class})
@LocalDeploy(value={"org.nuxeo.ecm.core:OSGI-INF/dummy-blob-provider.xml"})
public class TestBlobManager {
    private static final String DUMMY = "dummy";
    protected Mockery mockery = new JUnit4Mockery();
    @Inject
    protected BlobManager blobManager;
    @Mock
    @RuntimeService
    RepositoryManager repositoryManager;

    @Before
    public void mockRepositoryManager() throws Exception {
        Mockito.when((Object)this.repositoryManager.getRepositoryNames()).thenReturn(Collections.emptyList());
    }

    @Test
    public void testDummyRegistration() throws Exception {
        BlobProvider dummyBlobProvider = this.blobManager.getBlobProvider(DUMMY);
        Assert.assertNotNull((Object)dummyBlobProvider);
    }

    @Test
    public void testGetSetMetadata() throws Exception {
        BlobManager.BlobInfo blobInfo = new BlobManager.BlobInfo();
        blobInfo.key = "1234";
        blobInfo.mimeType = "test/type";
        blobInfo.encoding = "UTF-8";
        blobInfo.filename = "doc.ext";
        blobInfo.length = 123L;
        blobInfo.digest = "55667788";
        ManagedBlob blob = (ManagedBlob)this.blobManager.readBlob(blobInfo, DUMMY);
        Assert.assertNotNull((Object)blob);
        Assert.assertEquals((Object)"1234", (Object)blob.getKey());
        Assert.assertEquals((Object)"test/type", (Object)blob.getMimeType());
        Assert.assertEquals((Object)"UTF-8", (Object)blob.getEncoding());
        Assert.assertEquals((Object)"doc.ext", (Object)blob.getFilename());
        Assert.assertEquals((long)123L, (long)blob.getLength());
        Assert.assertEquals((Object)"55667788", (Object)blob.getDigest());
        blobInfo.key = "dummy:1234";
        blob = (ManagedBlob)this.blobManager.readBlob(blobInfo, null);
        Assert.assertNotNull((Object)blob);
        Assert.assertEquals((Object)"dummy:1234", (Object)blob.getKey());
        Assert.assertEquals((Object)"test/type", (Object)blob.getMimeType());
        Assert.assertEquals((Object)"UTF-8", (Object)blob.getEncoding());
        Assert.assertEquals((Object)"doc.ext", (Object)blob.getFilename());
        Assert.assertEquals((long)123L, (long)blob.getLength());
        Assert.assertEquals((Object)"55667788", (Object)blob.getDigest());
        final Document doc = (Document)this.mockery.mock(Document.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((Document)this.allowing(doc)).getRepositoryName();
                this.will(1.returnValue((Object)TestBlobManager.DUMMY));
            }
        });
        String key = this.blobManager.writeBlob((Blob)blob, doc);
        Assert.assertEquals((Object)"dummy:1234", (Object)key);
    }

    @Test
    @LocalDeploy(value={"org.nuxeo.ecm.core:OSGI-INF/test-blob-dispatch.xml"})
    public void testDispatch() throws Exception {
        Blob blob = Blobs.createBlob((String)"foo", (String)"text/plain");
        Document doc = (Document)this.mockery.mock(Document.class, "doc1");
        String key = this.blobManager.writeBlob(blob, doc);
        Assert.assertEquals((Object)"dummy:1", (Object)key);
        blob = Blobs.createBlob((String)"bar", (String)"video/mp4");
        key = this.blobManager.writeBlob(blob, doc);
        Assert.assertEquals((Object)"dummy2:1", (Object)key);
        BlobManager.BlobInfo blobInfo = new BlobManager.BlobInfo();
        blobInfo.key = "dummy:1";
        blob = this.blobManager.readBlob(blobInfo, null);
        Assert.assertEquals((Object)"foo", (Object)IOUtils.toString((InputStream)blob.getStream()));
        blobInfo.key = "dummy2:1";
        blob = this.blobManager.readBlob(blobInfo, null);
        Assert.assertEquals((Object)"bar", (Object)IOUtils.toString((InputStream)blob.getStream()));
    }
}

