/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobManagerComponent;
import org.nuxeo.ecm.core.blob.BlobManagerFeature;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.BlobProviderDescriptor;
import org.nuxeo.ecm.core.blob.FilesystemBlobProvider;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.mockito.MockitoFeature;
import org.nuxeo.runtime.mockito.RuntimeService;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.test.runner.RuntimeHarness;

@RunWith(value=FeaturesRunner.class)
@Features(value={BlobManagerFeature.class, MockitoFeature.class})
@LocalDeploy(value={"org.nuxeo.ecm.core:OSGI-INF/test-fs-blobprovider.xml"})
public class TestFilesystemBlobProvider {
    private static final String CONTENT = "hello";
    private static final String CONTENT_MD5 = "5d41402abc4b2a76b9719d911017c592";
    private static final String PROVIDER_ID = "testfs";
    protected Mockery mockery = new JUnit4Mockery();
    @Mock
    @RuntimeService
    RepositoryManager repositoryManager;
    @Inject
    protected RuntimeHarness harness;
    @Inject
    protected BlobManager blobManager;
    protected Path tmpFile;
    protected String tmpFilePath;

    @Before
    public void mockRepositoryManager() throws Exception {
        Mockito.when((Object)this.repositoryManager.getRepositoryNames()).thenReturn(Collections.emptyList());
    }

    @Before
    public void setUp() throws Exception {
        this.tmpFile = Framework.createTempFilePath((String)"tmp", (String)".txt", (FileAttribute[])new FileAttribute[0]);
        try (OutputStream out = Files.newOutputStream(this.tmpFile, new OpenOption[0]);){
            ByteArrayInputStream in = new ByteArrayInputStream(CONTENT.getBytes());
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        this.tmpFilePath = this.tmpFile.toString();
    }

    @After
    public void tearDown() throws Exception {
        if (this.tmpFile != null && Files.exists(this.tmpFile, new LinkOption[0])) {
            Files.delete(this.tmpFile);
        }
    }

    @Test
    public void testSupportsUserUpdate() throws Exception {
        BlobProvider blobProvider = this.blobManager.getBlobProvider(PROVIDER_ID);
        Assert.assertFalse((boolean)blobProvider.supportsUserUpdate());
        this.harness.deployContrib("org.nuxeo.ecm.core.tests", "OSGI-INF/test-fs-blobprovider-override.xml");
        try {
            blobProvider = this.blobManager.getBlobProvider(PROVIDER_ID);
            Assert.assertTrue((boolean)blobProvider.supportsUserUpdate());
        }
        finally {
            this.harness.undeployContrib("org.nuxeo.ecm.core.tests", "OSGI-INF/test-fs-blobprovider-override.xml");
        }
    }

    @Test
    public void testRead() throws Exception {
        String key = "testfs:" + this.tmpFilePath;
        BlobManager.BlobInfo blobInfo = new BlobManager.BlobInfo();
        blobInfo.key = key;
        ManagedBlob blob = (ManagedBlob)this.blobManager.readBlob(blobInfo, null);
        Assert.assertNotNull((Object)blob);
        Assert.assertEquals((Object)key, (Object)blob.getKey());
        try (InputStream in = blob.getStream();){
            Assert.assertEquals((Object)CONTENT, (Object)IOUtils.toString((InputStream)in));
        }
        blobInfo.key = this.tmpFilePath;
        blobInfo.mimeType = "text/plain";
        blob = ((FilesystemBlobProvider)this.blobManager.getBlobProvider(PROVIDER_ID)).createBlob(blobInfo);
        Assert.assertEquals((Object)key, (Object)blob.getKey());
        Assert.assertEquals((Object)this.tmpFile.getFileName().toString(), (Object)blob.getFilename());
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertEquals((long)CONTENT.length(), (long)blob.getLength());
        Assert.assertEquals((Object)CONTENT_MD5, (Object)blob.getDigest());
        in = blob.getStream();
        var5_5 = null;
        try {
            Assert.assertEquals((Object)CONTENT, (Object)IOUtils.toString((InputStream)in));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        String writtenKey = this.blobManager.writeBlob((Blob)blob, null);
        Assert.assertEquals((Object)key, (Object)writtenKey);
    }

    @Test
    public void testReadNotFound() throws Exception {
        String path = "/NO_SUCH_FILE_EXISTS";
        Assert.assertFalse((boolean)Files.exists(Paths.get(path, new String[0]), new LinkOption[0]));
        String key = "testfs:" + path;
        BlobManager.BlobInfo blobInfo = new BlobManager.BlobInfo();
        blobInfo.key = key;
        ManagedBlob blob = (ManagedBlob)this.blobManager.readBlob(blobInfo, null);
        try {
            blob.getStream();
            Assert.fail((String)"Should not be able to read non-existent file");
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRoot() throws Exception {
        String PROVIDER_ID2 = "testfs2";
        BlobProviderDescriptor descr = new BlobProviderDescriptor();
        descr.klass = FilesystemBlobProvider.class;
        descr.name = PROVIDER_ID2;
        descr.properties = Collections.singletonMap("root", this.tmpFile.getParent().toString());
        ((BlobManagerComponent)this.blobManager).registerBlobProvider(descr);
        try {
            String key = PROVIDER_ID2 + ":" + this.tmpFile.getFileName().toString();
            BlobManager.BlobInfo blobInfo = new BlobManager.BlobInfo();
            blobInfo.key = key;
            ManagedBlob blob = (ManagedBlob)this.blobManager.readBlob(blobInfo, null);
            Assert.assertNotNull((Object)blob);
            Assert.assertEquals((Object)key, (Object)blob.getKey());
            try (InputStream in = blob.getStream();){
                Assert.assertEquals((Object)CONTENT, (Object)IOUtils.toString((InputStream)in));
            }
        }
        finally {
            ((BlobManagerComponent)this.blobManager).unregisterBlobProvider(descr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIllegalPath() throws Exception {
        String illegalPath = "../foo";
        String PROVIDER_ID2 = "testfs2";
        BlobProviderDescriptor descr = new BlobProviderDescriptor();
        descr.klass = FilesystemBlobProvider.class;
        descr.name = PROVIDER_ID2;
        descr.properties = Collections.singletonMap("root", this.tmpFile.getParent().toString());
        ((BlobManagerComponent)this.blobManager).registerBlobProvider(descr);
        try {
            String key = PROVIDER_ID2 + ":" + illegalPath;
            BlobManager.BlobInfo blobInfo = new BlobManager.BlobInfo();
            blobInfo.key = key;
            ManagedBlob blob = (ManagedBlob)this.blobManager.readBlob(blobInfo, null);
            Assert.assertNotNull((Object)blob);
            Assert.assertEquals((Object)key, (Object)blob.getKey());
            try {
                blob.getStream();
                Assert.fail((String)"Should not be able to read file with illegal path");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        finally {
            ((BlobManagerComponent)this.blobManager).unregisterBlobProvider(descr);
        }
    }
}

