/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob.binary;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Collections;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.binary.AESBinaryManager;
import org.nuxeo.ecm.core.blob.binary.Binary;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.NXRuntimeTestCase;

public class TestAESBinaryManager
extends NXRuntimeTestCase {
    private static final String KEY_STORE_TYPE = "JCEKS";
    private static final String KEY_STORE_PASSWORD = "keystoresecret";
    private static final String KEY_ALIAS = "myaeskey";
    private static final String KEY_PASSWORD = "keysecret";
    private static final String CONTENT = "this is a file au caf\u00e9";
    private static final String CONTENT_MD5 = "d25ea4f4642073b7f218024d397dbaef";
    private static final String UTF8 = "UTF-8";

    @Test
    public void testEncryptDecryptWithPassword() throws Exception {
        AESBinaryManager binaryManager = new AESBinaryManager();
        binaryManager.digestAlgorithm = binaryManager.getDefaultDigestAlgorithm();
        String options = String.format("%s=%s", "password", "mypassword");
        binaryManager.initializeOptions(options);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String digest = binaryManager.storeAndDigest((InputStream)new ByteArrayInputStream(CONTENT.getBytes(UTF8)), (OutputStream)out);
        Assert.assertEquals((Object)CONTENT_MD5, (Object)digest);
        byte[] encrypted = out.toByteArray();
        out = new ByteArrayOutputStream();
        binaryManager.decrypt((InputStream)new ByteArrayInputStream(encrypted), (OutputStream)out);
        Assert.assertEquals((Object)CONTENT, (Object)new String(out.toByteArray(), UTF8));
        options = String.format("%s=%s", "password", "badpassword");
        binaryManager.initializeOptions(options);
        out = new ByteArrayOutputStream();
        try {
            binaryManager.decrypt((InputStream)new ByteArrayInputStream(encrypted), (OutputStream)out);
            Assert.assertFalse((boolean)CONTENT.equals(new String(out.toByteArray(), UTF8)));
        }
        catch (NuxeoException e) {
            String message = e.getMessage();
            Assert.assertTrue((String)message, (boolean)message.contains("Given final block not properly padded"));
        }
        binaryManager.close();
    }

    @Test
    public void testEncryptDecryptWithKeyStore() throws Exception {
        File keyStoreFile = Framework.createTempFile((String)"nuxeoKeyStore_", (String)"");
        keyStoreFile.delete();
        this.createKeyStore(keyStoreFile);
        String options = String.format("%s=%s,%s=%s,%s=%s,%s=%s,%s=%s", "keyStoreType", KEY_STORE_TYPE, "keyStoreFile", keyStoreFile.getPath(), "keyStorePassword", KEY_STORE_PASSWORD, "keyAlias", KEY_ALIAS, "keyPassword", KEY_PASSWORD);
        AESBinaryManager binaryManager = new AESBinaryManager();
        binaryManager.digestAlgorithm = binaryManager.getDefaultDigestAlgorithm();
        binaryManager.initializeOptions(options);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String digest = binaryManager.storeAndDigest((InputStream)new ByteArrayInputStream(CONTENT.getBytes(UTF8)), (OutputStream)out);
        Assert.assertEquals((Object)CONTENT_MD5, (Object)digest);
        byte[] encrypted = out.toByteArray();
        out = new ByteArrayOutputStream();
        binaryManager.decrypt((InputStream)new ByteArrayInputStream(encrypted), (OutputStream)out);
        Assert.assertEquals((Object)CONTENT, (Object)new String(out.toByteArray(), UTF8));
        binaryManager.close();
    }

    protected void createKeyStore(File file) throws GeneralSecurityException, IOException {
        AESBinaryManager.setUnlimitedJCEPolicy();
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(256);
        SecretKey skey = kgen.generateKey();
        KeyStore keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
        keyStore.load(null, null);
        keyStore.setKeyEntry(KEY_ALIAS, skey, KEY_PASSWORD.toCharArray(), null);
        FileOutputStream out = new FileOutputStream(file);
        keyStore.store(out, KEY_STORE_PASSWORD.toCharArray());
        ((OutputStream)out).close();
    }

    @Test
    public void testAESBinaryManager() throws Exception {
        AESBinaryManager binaryManager = new AESBinaryManager();
        String options = String.format("%s=%s", "password", "mypassword");
        binaryManager.initialize("repo", Collections.singletonMap("key", options));
        Binary binary = binaryManager.getBinary(CONTENT_MD5);
        Assert.assertNull((Object)binary);
        byte[] bytes = CONTENT.getBytes(UTF8);
        binary = binaryManager.getBinary((InputStream)new ByteArrayInputStream(bytes));
        Assert.assertNotNull((Object)binary);
        Assert.assertEquals((Object)CONTENT_MD5, (Object)binary.getDigest());
        binary = binaryManager.getBinary(CONTENT_MD5);
        Assert.assertNotNull((Object)binary);
        try (InputStream stream = binary.getStream();){
            Assert.assertEquals((Object)CONTENT, (Object)IOUtils.toString((InputStream)stream, (String)UTF8));
        }
        binaryManager.close();
    }
}

