/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob.binary;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.blob.binary.Binary;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.BinaryManagerStatus;
import org.nuxeo.ecm.core.blob.binary.DefaultBinaryManager;
import org.nuxeo.runtime.test.NXRuntimeTestCase;

public class TestDefaultBinaryManager
extends NXRuntimeTestCase {
    private static final String CONTENT = "this is a file au caf\u00e9";
    private static final String CONTENT_MD5 = "d25ea4f4642073b7f218024d397dbaef";
    private static final String CONTENT_SHA1 = "3f3bdf817537faa28483eabc69a4bb3912cf0c6c";

    @Test
    public void testDefaultBinaryManager() throws Exception {
        this.deployBundle("org.nuxeo.ecm.core");
        this.deployContrib("org.nuxeo.ecm.core.tests", "OSGI-INF/test-default-blob-provider.xml");
        DefaultBinaryManager binaryManager = new DefaultBinaryManager();
        binaryManager.initialize("repo", Collections.emptyMap());
        Assert.assertEquals((long)0L, (long)TestDefaultBinaryManager.countFiles(binaryManager.getStorageDir()));
        Binary binary = binaryManager.getBinary(CONTENT_MD5);
        Assert.assertNull((Object)binary);
        Assert.assertEquals((Object)"MD5", (Object)binaryManager.getDigestAlgorithm());
        byte[] bytes = CONTENT.getBytes("UTF-8");
        binary = binaryManager.getBinary(Blobs.createBlob((String)CONTENT));
        Assert.assertNotNull((Object)binary);
        Assert.assertEquals((long)1L, (long)TestDefaultBinaryManager.countFiles(binaryManager.getStorageDir()));
        binary = binaryManager.getBinary(CONTENT_MD5);
        Assert.assertNotNull((Object)binary);
        Assert.assertEquals((Object)CONTENT, (Object)IOUtils.toString((InputStream)binary.getStream(), (String)"UTF-8"));
        Assert.assertEquals((Object)"MD5", (Object)binary.getDigestAlgorithm());
        Assert.assertEquals((Object)CONTENT_MD5, (Object)binary.getDigest());
        Binary sha1Binary = new Binary(CONTENT_SHA1, "repo");
        Assert.assertEquals((Object)"SHA-1", (Object)sha1Binary.getDigestAlgorithm());
        Assert.assertEquals((Object)CONTENT_SHA1, (Object)sha1Binary.getDigest());
        binaryManager.getBinary(Blobs.createBlob((String)"abc"));
        Assert.assertEquals((long)2L, (long)TestDefaultBinaryManager.countFiles(binaryManager.getStorageDir()));
        Thread.sleep(3000L);
        binaryManager.getBinary(Blobs.createBlob((String)"defg"));
        Assert.assertEquals((long)3L, (long)TestDefaultBinaryManager.countFiles(binaryManager.getStorageDir()));
        BinaryGarbageCollector gc = binaryManager.getGarbageCollector();
        Assert.assertFalse((boolean)gc.isInProgress());
        gc.start();
        Assert.assertTrue((boolean)gc.isInProgress());
        gc.mark(CONTENT_MD5);
        Assert.assertTrue((boolean)gc.isInProgress());
        gc.stop(false);
        Assert.assertFalse((boolean)gc.isInProgress());
        BinaryManagerStatus status = gc.getStatus();
        Assert.assertEquals((long)2L, (long)status.numBinaries);
        Assert.assertEquals((long)(bytes.length + 4), (long)status.sizeBinaries);
        Assert.assertEquals((long)1L, (long)status.numBinariesGC);
        Assert.assertEquals((long)3L, (long)status.sizeBinariesGC);
        Assert.assertEquals((long)3L, (long)TestDefaultBinaryManager.countFiles(binaryManager.getStorageDir()));
        gc = binaryManager.getGarbageCollector();
        Assert.assertFalse((boolean)gc.isInProgress());
        gc.start();
        Assert.assertTrue((boolean)gc.isInProgress());
        gc.mark(CONTENT_MD5);
        Assert.assertTrue((boolean)gc.isInProgress());
        gc.stop(true);
        Assert.assertFalse((boolean)gc.isInProgress());
        status = gc.getStatus();
        Assert.assertEquals((long)2L, (long)status.numBinaries);
        Assert.assertEquals((long)(bytes.length + 4), (long)status.sizeBinaries);
        Assert.assertEquals((long)1L, (long)status.numBinariesGC);
        Assert.assertEquals((long)3L, (long)status.sizeBinariesGC);
        Assert.assertEquals((long)2L, (long)TestDefaultBinaryManager.countFiles(binaryManager.getStorageDir()));
        binaryManager.close();
    }

    @Test
    public void testTemporaryCopies() throws IOException {
        DefaultBinaryManager binaryManager = new DefaultBinaryManager();
        binaryManager.initialize("repo", Collections.emptyMap());
        Assert.assertEquals((long)0L, (long)TestDefaultBinaryManager.countFiles(binaryManager.getStorageDir()));
        FileBlob source = new FileBlob((InputStream)new ByteArrayInputStream(CONTENT.getBytes("UTF-8")));
        File originalFile = source.getFile();
        binaryManager.storeAndDigest(source);
        Assert.assertFalse((boolean)originalFile.exists());
        Assert.assertTrue((boolean)source.getFile().exists());
        binaryManager.close();
    }

    protected static int countFiles(File dir) {
        int n = 0;
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                n += TestDefaultBinaryManager.countFiles(f);
                continue;
            }
            ++n;
        }
        return n;
    }
}

