/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event;

import java.util.HashMap;
import java.util.Map;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.event.impl.CoreEventImpl;
import org.nuxeo.ecm.core.model.Document;

@RunWith(value=JMock.class)
public class TestCoreEvent {
    private static final String COMMENT = "comment";
    private static final String CATEGORY = "category";
    protected Mockery jmcontext = new JUnit4Mockery();

    @Test
    public void testCoreEventVarious() {
        String eventId = "someEvent";
        String source = "someDummySource";
        CoreEventImpl coreEvent = new CoreEventImpl(null, null, null, null, null, null);
        Assert.assertNotNull((Object)coreEvent);
        Assert.assertNull((Object)coreEvent.getEventId());
        Assert.assertNull((Object)coreEvent.getSource());
        Assert.assertNotNull((Object)coreEvent.getInfo());
        Assert.assertNull((Object)coreEvent.getComment());
        Assert.assertNull((Object)coreEvent.getCategory());
        CoreEventImpl coreEvent1 = new CoreEventImpl(eventId, null, null, null, null, null);
        Assert.assertNotNull((Object)coreEvent1);
        Assert.assertEquals((Object)eventId, (Object)coreEvent1.getEventId());
        Assert.assertNull((Object)coreEvent1.getSource());
        Assert.assertNotNull((Object)coreEvent1.getInfo());
        Assert.assertNull((Object)coreEvent1.getComment());
        Assert.assertNull((Object)coreEvent1.getCategory());
        CoreEventImpl coreEvent2 = new CoreEventImpl(eventId, (Object)source, null, null, null, null);
        Assert.assertNotNull((Object)coreEvent2);
        Assert.assertEquals((Object)eventId, (Object)coreEvent2.getEventId());
        Assert.assertEquals((Object)source, (Object)coreEvent2.getSource());
        Assert.assertNotNull((Object)coreEvent2.getInfo());
        Assert.assertNull((Object)coreEvent2.getComment());
        Assert.assertNull((Object)coreEvent2.getCategory());
        Map info = null;
        CoreEventImpl coreEvent3 = new CoreEventImpl(eventId, (Object)source, info, null, null, null);
        Assert.assertNotNull((Object)coreEvent3);
        Assert.assertEquals((Object)eventId, (Object)coreEvent3.getEventId());
        Assert.assertEquals((Object)source, (Object)coreEvent3.getSource());
        Assert.assertNotNull((Object)coreEvent3.getInfo());
        Assert.assertNull((Object)coreEvent3.getComment());
        Assert.assertNull((Object)coreEvent3.getCategory());
    }

    @Test
    public void testCoreEventWithMockDocument() {
        String eventId = "someEvent";
        Map info = null;
        CoreEventImpl coreEvent = new CoreEventImpl(eventId, null, info, null, null, null);
        Assert.assertEquals((Object)eventId, (Object)coreEvent.getEventId());
        Assert.assertNotNull((Object)coreEvent.getInfo());
        Assert.assertNull((Object)coreEvent.getComment());
        Assert.assertNull((Object)coreEvent.getCategory());
        Assert.assertNull((Object)coreEvent.getSource());
    }

    @Test
    public void testCoreEventWithInfoMap() {
        String eventId = "someEvent";
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("destination", "xxx");
        CoreEventImpl coreEvent = new CoreEventImpl(eventId, null, info, null, null, null);
        Assert.assertEquals((Object)eventId, (Object)coreEvent.getEventId());
        Map infoBack = coreEvent.getInfo();
        info.put(COMMENT, null);
        info.put(CATEGORY, null);
        Assert.assertEquals(info, (Object)infoBack);
        Assert.assertEquals((Object)"xxx", infoBack.get("destination"));
        Assert.assertNull((Object)coreEvent.getSource());
    }

    @Test
    public void testDateInitialisationNoData() {
        CoreEventImpl coreEvent = new CoreEventImpl(null, null, null, null, null, null);
        Assert.assertNotNull((Object)coreEvent.getDate());
    }

    @Test
    public void testCoreEventWithInfo() {
        String eventId = "someEvent";
        Document source = (Document)this.jmcontext.mock(Document.class);
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("destination", "xxx");
        CoreEventImpl coreEvent = new CoreEventImpl(eventId, (Object)source, info, null, null, null);
        Assert.assertNotNull((Object)coreEvent.getDate());
    }
}

