/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.lifecycle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.lifecycle.LifeCycle;
import org.nuxeo.ecm.core.lifecycle.LifeCycleService;
import org.nuxeo.ecm.core.lifecycle.LifeCycleState;
import org.nuxeo.ecm.core.lifecycle.LifeCycleTransition;
import org.nuxeo.runtime.test.NXRuntimeTestCase;

public class TestLifeCycleService
extends NXRuntimeTestCase {
    private LifeCycleService lifeCycleService;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.deployContrib("org.nuxeo.ecm.core", "OSGI-INF/LifeCycleService.xml");
        this.deployContrib("org.nuxeo.ecm.core.tests", "LifeCycleManagerTestExtensions.xml");
        this.lifeCycleService = NXCore.getLifeCycleService();
        Assert.assertNotNull((Object)this.lifeCycleService);
    }

    @Test
    public void testLifeCycleRegistration() throws Exception {
        Collection lcs = this.lifeCycleService.getLifeCycles();
        Assert.assertEquals((long)1L, (long)lcs.size());
        LifeCycle lcd = this.lifeCycleService.getLifeCycleByName("default");
        Assert.assertNotNull((Object)lcd);
        Assert.assertEquals((Object)"default", (Object)lcd.getName());
        Collection states = lcd.getStates();
        Assert.assertEquals((long)4L, (long)states.size());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("work");
        expected.add("approved");
        expected.add("cancelled");
        expected.add("obsolete");
        Collections.sort(expected);
        ArrayList<String> stateNames = new ArrayList<String>();
        for (LifeCycleState state : states) {
            stateNames.add(state.getName());
        }
        Collections.sort(stateNames);
        Assert.assertEquals(expected, stateNames);
        Assert.assertEquals((Object)"work", (Object)lcd.getDefaultInitialStateName());
        ArrayList<String> expectedInitialStates = new ArrayList<String>();
        expectedInitialStates.add("work");
        expectedInitialStates.add("approved");
        Collections.sort(expectedInitialStates);
        ArrayList initialStates = new ArrayList(lcd.getInitialStateNames());
        Collections.sort(initialStates);
        Assert.assertEquals(expectedInitialStates, initialStates);
        Collection transitions = lcd.getAllowedStateTransitionsFrom("work");
        Assert.assertEquals((long)3L, (long)transitions.size());
        Assert.assertTrue((boolean)transitions.contains("approve"));
        Assert.assertTrue((boolean)transitions.contains("cancel"));
        Assert.assertTrue((boolean)transitions.contains("obsolete"));
        try {
            transitions.remove("approve");
            Assert.fail((String)"Mutation should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        transitions = lcd.getAllowedStateTransitionsFrom("work");
        Assert.assertEquals((long)3L, (long)transitions.size());
        transitions = lcd.getAllowedStateTransitionsFrom("approved");
        Assert.assertEquals((long)1L, (long)transitions.size());
        Assert.assertTrue((boolean)transitions.contains("obsolete"));
        transitions = lcd.getAllowedStateTransitionsFrom("cancelled");
        Assert.assertEquals((long)1L, (long)transitions.size());
        Assert.assertTrue((boolean)transitions.contains("backToWork"));
        transitions = lcd.getAllowedStateTransitionsFrom("obsolete");
        Assert.assertEquals((long)0L, (long)transitions.size());
        Collection lifeCycleDefinitions = lcd.getTransitions();
        Assert.assertEquals((long)4L, (long)lifeCycleDefinitions.size());
    }

    @Test
    public void testLifeCycle() {
        LifeCycle lifeCycle = this.lifeCycleService.getLifeCycleByName("default");
        LifeCycleState workState = lifeCycle.getStateByName("work");
        Assert.assertEquals((Object)"work", (Object)workState.getName());
        Collection transitions = workState.getAllowedStateTransitions();
        Assert.assertEquals((long)3L, (long)transitions.size());
        Assert.assertTrue((boolean)transitions.contains("approve"));
        Assert.assertTrue((boolean)transitions.contains("cancel"));
        Assert.assertTrue((boolean)transitions.contains("obsolete"));
        workState = lifeCycle.getStateByName("approved");
        transitions = workState.getAllowedStateTransitions();
        Assert.assertEquals((long)1L, (long)transitions.size());
        Assert.assertTrue((boolean)transitions.contains("obsolete"));
        workState = lifeCycle.getStateByName("cancelled");
        Assert.assertEquals((Object)"cancelled", (Object)workState.getName());
        transitions = workState.getAllowedStateTransitions();
        Assert.assertEquals((long)1L, (long)transitions.size());
        Assert.assertTrue((boolean)transitions.contains("backToWork"));
        workState = lifeCycle.getStateByName("obsolete");
        Assert.assertEquals((Object)"obsolete", (Object)workState.getName());
        transitions = workState.getAllowedStateTransitions();
        Assert.assertEquals((long)0L, (long)transitions.size());
        LifeCycleTransition transition = lifeCycle.getTransitionByName("approve");
        Assert.assertNotNull((Object)transition);
        String destinationName = lifeCycle.getTransitionByName("approve").getDestinationStateName();
        Assert.assertEquals((Object)"approved", (Object)destinationName);
    }

    @Test
    public void testLifeCycleTypesMappingRegistration() {
        Map mapping = this.lifeCycleService.getTypesMapping();
        Assert.assertTrue((boolean)mapping.keySet().contains("File"));
        Assert.assertTrue((boolean)mapping.keySet().contains("Folder"));
        Assert.assertEquals((Object)"default", mapping.get("File"));
        Assert.assertEquals((Object)"default", mapping.get("Folder"));
    }

    @Test
    public void testLifeCycleTypesMappingAPI() {
        Collection types = this.lifeCycleService.getTypesFor("default");
        Assert.assertTrue((boolean)types.contains("File"));
        Assert.assertTrue((boolean)types.contains("Folder"));
    }

    @Test
    public void testTypeLifeCycleMapping() {
        String lifeCycleName = this.lifeCycleService.getLifeCycleNameFor("File");
        Assert.assertEquals((Object)"default", (Object)lifeCycleName);
        List noRecursion = this.lifeCycleService.getNonRecursiveTransitionForDocType("File");
        Assert.assertEquals((long)3L, (long)noRecursion.size());
        Assert.assertTrue((boolean)noRecursion.contains("toBar"));
        noRecursion = this.lifeCycleService.getNonRecursiveTransitionForDocType("Folder");
        Assert.assertTrue((boolean)noRecursion.isEmpty());
    }

    @Test
    public void testLifeCycleReverse() throws Exception {
        this.deployContrib("org.nuxeo.ecm.core.tests", "LifeCycleManagerReverseTestExtensions.xml");
        LifeCycle lifeCycle = this.lifeCycleService.getLifeCycleByName("defaultReverse");
        LifeCycleState workState = lifeCycle.getStateByName("work");
        Assert.assertEquals((Object)"work", (Object)workState.getName());
        Collection transitions = workState.getAllowedStateTransitions();
        Assert.assertEquals((long)3L, (long)transitions.size());
        Assert.assertTrue((boolean)transitions.contains("approve"));
        Assert.assertTrue((boolean)transitions.contains("cancel"));
        Assert.assertTrue((boolean)transitions.contains("obsolete"));
        workState = lifeCycle.getStateByName("approved");
        transitions = workState.getAllowedStateTransitions();
        Assert.assertEquals((long)1L, (long)transitions.size());
        Assert.assertTrue((boolean)transitions.contains("obsolete"));
        workState = lifeCycle.getStateByName("cancelled");
        Assert.assertEquals((Object)"cancelled", (Object)workState.getName());
        transitions = workState.getAllowedStateTransitions();
        Assert.assertEquals((long)1L, (long)transitions.size());
        Assert.assertTrue((boolean)transitions.contains("backToWork"));
        workState = lifeCycle.getStateByName("obsolete");
        Assert.assertEquals((Object)"obsolete", (Object)workState.getName());
        transitions = workState.getAllowedStateTransitions();
        Assert.assertEquals((long)0L, (long)transitions.size());
        LifeCycleTransition transition = lifeCycle.getTransitionByName("approve");
        Assert.assertNotNull((Object)transition);
        String destinationName = transition.getDestinationStateName();
        Assert.assertEquals((Object)"approved", (Object)destinationName);
    }
}

