/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.model;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.PathComparator;

public class TestPathComparator {
    private static final PathComparator PATH_COMPARATOR = new PathComparator();

    @Test
    public void testBasics() throws Exception {
        Document doc1 = (Document)Mockito.mock(Document.class, (String)"doc1");
        Mockito.when((Object)doc1.getPath()).thenReturn((Object)"/doc1");
        Document doc2 = (Document)Mockito.mock(Document.class, (String)"doc2");
        Mockito.when((Object)doc2.getPath()).thenReturn((Object)"/doc2");
        Document[] array = new Document[]{doc2, doc1};
        Arrays.sort(array, PATH_COMPARATOR);
        Assert.assertEquals((Object)"/doc1", (Object)array[0].getPath());
        Assert.assertEquals((Object)"/doc2", (Object)array[1].getPath());
    }

    @Test
    public void testNullFirst() throws Exception {
        Document doc1 = (Document)Mockito.mock(Document.class, (String)"doc1");
        Mockito.when((Object)doc1.getPath()).thenReturn((Object)"/doc1");
        Document doc2 = (Document)Mockito.mock(Document.class, (String)"doc2");
        Mockito.when((Object)doc2.getPath()).thenReturn(null);
        Document[] array = new Document[]{doc2, doc1};
        Arrays.sort(array, PATH_COMPARATOR);
        Assert.assertNull((Object)array[0].getPath());
        Assert.assertEquals((Object)"/doc1", (Object)array[1].getPath());
    }

    @Test
    public void testBothNull() throws Exception {
        Document doc1 = (Document)Mockito.mock(Document.class, (String)"doc1");
        Mockito.when((Object)doc1.getPath()).thenReturn(null);
        Mockito.when((Object)doc1.getUUID()).thenReturn((Object)"id1");
        Document doc2 = (Document)Mockito.mock(Document.class, (String)"doc2");
        Mockito.when((Object)doc2.getPath()).thenReturn(null);
        Mockito.when((Object)doc2.getUUID()).thenReturn((Object)"id2");
        Document[] array = new Document[]{doc2, doc1};
        Arrays.sort(array, PATH_COMPARATOR);
        Assert.assertEquals((Object)"id1", (Object)array[0].getUUID());
        Assert.assertEquals((Object)"id2", (Object)array[1].getUUID());
    }
}

