/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.model;

import java.lang.reflect.Field;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.utils.SIDGenerator;
import org.nuxeo.runtime.test.runner.ConditionalIgnoreRule;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={ConditionalIgnoreRule.Feature.class})
public class TestSidGenerator {
    @Test
    public void testGenerator() {
        HashSet<Long> ids = new HashSet<Long>();
        for (int i = 0; i < 1000; ++i) {
            long id = SIDGenerator.next();
            if (ids.add(id)) continue;
            Assert.fail((String)("ID already generated: " + id));
        }
    }

    @Test
    @ConditionalIgnoreRule.Ignore(condition=ConditionalIgnoreRule.IgnoreWindows.class, cause="windows doesn't have enough time granularity for such a high-speed test")
    public void testGeneratorReset() throws Exception {
        HashSet<Long> ids = new HashSet<Long>();
        for (int i = 0; i < 1000; ++i) {
            long id = SIDGenerator.next();
            if (ids.add(id)) continue;
            Assert.fail((String)("ID already generated: " + id));
        }
        Field field = SIDGenerator.class.getDeclaredField("count");
        field.setAccessible(true);
        field.set(null, 2147482647);
        Thread.sleep(1L);
        for (int i = 0; i < 3000; ++i) {
            long id = SIDGenerator.next();
            if (ids.add(id)) continue;
            Assert.fail((String)("ID already generated: " + id));
        }
        Integer counter = (Integer)field.get(null);
        Assert.assertEquals((long)2000L, (long)counter.intValue());
    }
}

