/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.repository;

import java.lang.reflect.Field;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.repository.RepositoryInitializationHandler;

public class TestRepositoryInitializationHandler {
    @After
    public void tearDown() throws Exception {
        Field field = RepositoryInitializationHandler.class.getDeclaredField("instance");
        field.setAccessible(true);
        field.set(null, null);
    }

    protected RepositoryInitializationHandler getTail() {
        return RepositoryInitializationHandler.getInstance();
    }

    @Test
    public void testUninstallSameOrder() throws Exception {
        TestHandler a = new TestHandler();
        TestHandler b = new TestHandler();
        Assert.assertNull((Object)this.getTail());
        a.install();
        Assert.assertEquals((Object)((Object)a), (Object)this.getTail());
        b.install();
        Assert.assertEquals((Object)((Object)b), (Object)this.getTail());
        Assert.assertNull((Object)a.previous);
        Assert.assertEquals((Object)((Object)b), (Object)a.next);
        Assert.assertEquals((Object)((Object)a), (Object)b.previous);
        Assert.assertNull((Object)b.next);
        a.uninstall();
        Assert.assertEquals((Object)((Object)b), (Object)this.getTail());
        Assert.assertNull((Object)b.previous);
        Assert.assertNull((Object)b.next);
        b.uninstall();
        Assert.assertNull((Object)this.getTail());
    }

    @Test
    public void testUninstallInverseOrder() throws Exception {
        TestHandler a = new TestHandler();
        TestHandler b = new TestHandler();
        Assert.assertNull((Object)this.getTail());
        a.install();
        Assert.assertEquals((Object)((Object)a), (Object)this.getTail());
        b.install();
        Assert.assertEquals((Object)((Object)b), (Object)this.getTail());
        Assert.assertNull((Object)a.previous);
        Assert.assertEquals((Object)((Object)b), (Object)a.next);
        Assert.assertEquals((Object)((Object)a), (Object)b.previous);
        Assert.assertNull((Object)b.next);
        b.uninstall();
        Assert.assertEquals((Object)((Object)a), (Object)this.getTail());
        Assert.assertNull((Object)a.previous);
        Assert.assertNull((Object)a.next);
        a.uninstall();
        Assert.assertNull((Object)this.getTail());
    }

    protected static class TestHandler
    extends RepositoryInitializationHandler {
        protected TestHandler() {
        }

        public void doInitializeRepository(CoreSession session) {
        }
    }
}

