/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.security.SecurityPolicyService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.NXRuntimeTestCase;

public class TestSecurityPolicyService
extends NXRuntimeTestCase {
    static final String creator = "Bodie";
    static final String user = "Bubbles";
    static final Principal creatorPrincipal = new UserPrincipal("Bodie", new ArrayList(), false, false);
    static final Principal userPrincipal = new UserPrincipal("Bubbles", new ArrayList(), false, false);
    private SecurityPolicyService service;
    protected Mockery mockery = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.deployContrib("org.nuxeo.ecm.core", "OSGI-INF/SecurityService.xml");
        this.deployContrib("org.nuxeo.ecm.core", "OSGI-INF/permissions-contrib.xml");
        this.deployContrib("org.nuxeo.ecm.core", "OSGI-INF/security-policy-contrib.xml");
        this.service = (SecurityPolicyService)Framework.getService(SecurityPolicyService.class);
        Assert.assertNotNull((Object)this.service);
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.service = null;
    }

    @Test
    public void testPolicies() throws Exception {
        String permission = "Write";
        String[] permissions = new String[]{"Write"};
        final Document doc = (Document)this.mockery.mock(Document.class, "document1");
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((Document)this.allowing(doc)).getLock();
                this.will(1.returnValue(null));
            }
        });
        Assert.assertSame((Object)Access.UNKNOWN, (Object)this.service.checkPermission(doc, null, creatorPrincipal, permission, permissions, null));
        Assert.assertSame((Object)Access.UNKNOWN, (Object)this.service.checkPermission(doc, null, userPrincipal, permission, permissions, null));
        final Lock lock = new Lock(user, (Calendar)new GregorianCalendar());
        final Document doc2 = (Document)this.mockery.mock(Document.class, "document2");
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((Document)this.allowing(doc2)).getLock();
                this.will(2.returnValue((Object)lock));
                ((Document)this.allowing(doc2)).getPropertyValue("dc:creator");
                this.will(2.returnValue((Object)TestSecurityPolicyService.creator));
            }
        });
        Assert.assertSame((Object)Access.DENY, (Object)this.service.checkPermission(doc2, null, creatorPrincipal, permission, permissions, null));
        Assert.assertSame((Object)Access.UNKNOWN, (Object)this.service.checkPermission(doc2, null, userPrincipal, permission, permissions, null));
        this.deployContrib("org.nuxeo.ecm.core.tests", "test-security-policy-contrib.xml");
        Assert.assertSame((Object)Access.GRANT, (Object)this.service.checkPermission(doc2, null, creatorPrincipal, permission, permissions, null));
        Assert.assertSame((Object)Access.UNKNOWN, (Object)this.service.checkPermission(doc2, null, userPrincipal, permission, permissions, null));
    }

    @Test
    public void testCheckOutPolicy() throws Exception {
        String permission = "Write";
        String[] permissions = new String[]{"Write", "WriteProperties"};
        final Document doc = (Document)this.mockery.mock(Document.class, "document3");
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((Document)this.allowing(doc)).getLock();
                this.will(3.returnValue(null));
                ((Document)this.allowing(doc)).isVersion();
                this.will(3.returnValue((Object)Boolean.FALSE));
                ((Document)this.allowing(doc)).isProxy();
                this.will(3.returnValue((Object)Boolean.FALSE));
                ((Document)this.allowing(doc)).isCheckedOut();
                this.will(3.returnValue((Object)Boolean.TRUE));
            }
        });
        Assert.assertSame((Object)Access.UNKNOWN, (Object)this.service.checkPermission(doc, null, creatorPrincipal, permission, permissions, null));
        final Document doc2 = (Document)this.mockery.mock(Document.class, "document4");
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((Document)this.allowing(doc2)).getLock();
                this.will(4.returnValue(null));
                ((Document)this.allowing(doc2)).isVersion();
                this.will(4.returnValue((Object)Boolean.FALSE));
                ((Document)this.allowing(doc2)).isProxy();
                this.will(4.returnValue((Object)Boolean.FALSE));
                ((Document)this.allowing(doc2)).isCheckedOut();
                this.will(4.returnValue((Object)Boolean.FALSE));
            }
        });
        Assert.assertSame((Object)Access.UNKNOWN, (Object)this.service.checkPermission(doc2, null, creatorPrincipal, permission, permissions, null));
        this.deployContrib("org.nuxeo.ecm.core.tests", "test-security-policy2-contrib.xml");
        Assert.assertSame((Object)Access.DENY, (Object)this.service.checkPermission(doc2, null, creatorPrincipal, permission, permissions, null));
    }
}

