/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.core.api.security.UserVisiblePermission;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.runtime.test.NXRuntimeTestCase;

public class TestSecurityService
extends NXRuntimeTestCase {
    private SecurityService service;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.deployContrib("org.nuxeo.ecm.core", "OSGI-INF/SecurityService.xml");
        this.deployContrib("org.nuxeo.ecm.core", "OSGI-INF/permissions-contrib.xml");
        this.service = NXCore.getSecurityService();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.service = null;
    }

    @Test
    public void testGetPermissionsToCheck() {
        List<String> perms = Arrays.asList(this.service.getPermissionsToCheck("Read"));
        Assert.assertEquals((long)4L, (long)perms.size());
        Assert.assertTrue((boolean)perms.contains("Read"));
        Assert.assertTrue((boolean)perms.contains("Everything"));
    }

    @Test
    public void testDefaultPermissions() {
        PermissionProvider pp = this.service.getPermissionProvider();
        String[] groups = pp.getPermissionGroups("Read");
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals(Arrays.asList("ReadRemove", "ReadWrite"), Arrays.asList(groups));
        groups = pp.getPermissionGroups("ReadProperties");
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals(Arrays.asList("Read", "ReadRemove", "ReadWrite"), Arrays.asList(groups));
        groups = pp.getPermissionGroups("ReadChildren");
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals(Arrays.asList("Read", "ReadRemove", "ReadWrite"), Arrays.asList(groups));
        groups = pp.getPermissionGroups("Browse");
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals(Arrays.asList("Read", "ReadProperties", "ReadRemove", "ReadWrite"), Arrays.asList(groups));
    }

    protected List<String> permStrings(List<UserVisiblePermission> perms) {
        ArrayList<String> list = new ArrayList<String>(perms.size());
        for (UserVisiblePermission perm : perms) {
            list.add(perm.getPermission());
        }
        return list;
    }

    @Test
    public void testDefaultVisiblePermission() throws Exception {
        PermissionProvider pp = this.service.getPermissionProvider();
        List orderedVisiblePermissions = pp.getUserVisiblePermissionDescriptors();
        Assert.assertNotNull((Object)orderedVisiblePermissions);
        Assert.assertEquals(Arrays.asList("Read", "ReadWrite", "Everything"), this.permStrings(orderedVisiblePermissions));
        orderedVisiblePermissions = pp.getUserVisiblePermissionDescriptors("Section");
        Assert.assertNotNull((Object)orderedVisiblePermissions);
        Assert.assertEquals(Arrays.asList("Read", "ReadWrite", "Everything"), this.permStrings(orderedVisiblePermissions));
        orderedVisiblePermissions = pp.getUserVisiblePermissionDescriptors("Workspace");
        Assert.assertNotNull((Object)orderedVisiblePermissions);
        Assert.assertEquals(Arrays.asList("Read", "ReadWrite", "Everything"), this.permStrings(orderedVisiblePermissions));
    }

    @Test
    public void testOverridedPermissions1() throws Exception {
        this.deployContrib("org.nuxeo.ecm.core.tests", "permissions-override1-contrib.xml");
        PermissionProvider pp = this.service.getPermissionProvider();
        String[] groups = pp.getPermissionGroups("Read");
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals(Arrays.asList("CustomCompoundPerm", "ReadRemove", "ReadWrite"), Arrays.asList(groups));
        groups = pp.getPermissionGroups("ReadProperties");
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals(Arrays.asList("CustomCompoundPerm", "Read", "ReadRemove", "ReadWrite"), Arrays.asList(groups));
        groups = pp.getPermissionGroups("ReadChildren");
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals(Arrays.asList("CustomCompoundPerm", "Read", "ReadRemove", "ReadWrite"), Arrays.asList(groups));
        groups = pp.getPermissionGroups("Browse");
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals(Arrays.asList("CustomCompoundPerm", "Read", "ReadProperties", "ReadRemove", "ReadWrite"), Arrays.asList(groups));
        groups = pp.getPermissionGroups("CustomCompoundPerm");
        Assert.assertNull((Object)groups);
        groups = pp.getPermissionGroups("CustomAtomicPerm");
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals(Arrays.asList("CustomCompoundPerm"), Arrays.asList(groups));
    }

    @Test
    public void testOverridedVisiblePermission1() throws Exception {
        this.deployContrib("org.nuxeo.ecm.core.tests", "permissions-override1-contrib.xml");
        PermissionProvider pp = this.service.getPermissionProvider();
        List orderedVisiblePermissions = pp.getUserVisiblePermissionDescriptors();
        Assert.assertNotNull((Object)orderedVisiblePermissions);
        Assert.assertEquals(Arrays.asList("Read", "CustomCompoundPerm", "ReadWrite", "Everything"), this.permStrings(orderedVisiblePermissions));
        orderedVisiblePermissions = pp.getUserVisiblePermissionDescriptors("Section");
        Assert.assertNotNull((Object)orderedVisiblePermissions);
        Assert.assertEquals(Arrays.asList("Read", "CustomCompoundPerm", "ReadWrite", "Everything"), this.permStrings(orderedVisiblePermissions));
        orderedVisiblePermissions = pp.getUserVisiblePermissionDescriptors("Workspace");
        Assert.assertNotNull((Object)orderedVisiblePermissions);
        Assert.assertEquals(Arrays.asList("Read", "CustomCompoundPerm", "ReadWrite", "Everything"), this.permStrings(orderedVisiblePermissions));
    }

    @Test
    public void testOverriddenPermissions2() throws Exception {
        this.deployContrib("org.nuxeo.ecm.core.tests", "permissions-override2-contrib.xml");
        PermissionProvider pp = this.service.getPermissionProvider();
        this.testDefaultPermissions();
        String[] groups = pp.getPermissionGroups("CustomCompoundPerm");
        Assert.assertNull((Object)groups);
        groups = pp.getPermissionGroups("CustomAtomicPerm");
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals(Arrays.asList("ReadWrite", "Write"), Arrays.asList(groups));
    }

    @Test
    public void testOverridedVisiblePermission2() throws Exception {
        this.deployContrib("org.nuxeo.ecm.core.tests", "permissions-override2-contrib.xml");
        PermissionProvider pp = this.service.getPermissionProvider();
        List orderedVisiblePermissions = pp.getUserVisiblePermissionDescriptors();
        Assert.assertNotNull((Object)orderedVisiblePermissions);
        Assert.assertEquals(Arrays.asList("Write", "Read", "Everything"), this.permStrings(orderedVisiblePermissions));
        orderedVisiblePermissions = pp.getUserVisiblePermissionDescriptors("Section");
        Assert.assertNotNull((Object)orderedVisiblePermissions);
        Assert.assertEquals(Arrays.asList("Write", "Read", "Everything"), this.permStrings(orderedVisiblePermissions));
        orderedVisiblePermissions = pp.getUserVisiblePermissionDescriptors("Workspace");
        Assert.assertNotNull((Object)orderedVisiblePermissions);
        Assert.assertEquals(Arrays.asList("Write", "Read", "Everything"), this.permStrings(orderedVisiblePermissions));
    }

    @Test
    public void testOverridedVisiblePermission3() throws Exception {
        this.deployContrib("org.nuxeo.ecm.core.tests", "permissions-override3-contrib.xml");
        PermissionProvider pp = this.service.getPermissionProvider();
        List orderedVisiblePermissions = pp.getUserVisiblePermissionDescriptors();
        Assert.assertNotNull((Object)orderedVisiblePermissions);
        Assert.assertEquals(Arrays.asList("Write", "Read", "Everything"), this.permStrings(orderedVisiblePermissions));
        orderedVisiblePermissions = pp.getUserVisiblePermissionDescriptors("Section");
        Assert.assertNotNull((Object)orderedVisiblePermissions);
        Assert.assertEquals(Arrays.asList("Write", "Everything", "Read"), this.permStrings(orderedVisiblePermissions));
        orderedVisiblePermissions = pp.getUserVisiblePermissionDescriptors("Workspace");
        Assert.assertNotNull((Object)orderedVisiblePermissions);
        Assert.assertEquals(Arrays.asList("Write", "Read", "Everything"), this.permStrings(orderedVisiblePermissions));
    }

    @Test
    public void testPermissionsVsDeny() throws Exception {
        PermissionProvider pp = this.service.getPermissionProvider();
        List vp = pp.getUserVisiblePermissionDescriptors();
        Assert.assertNotNull((Object)vp);
        UserVisiblePermission writeVP = null;
        for (UserVisiblePermission uvp : vp) {
            if (!uvp.getId().equals("ReadWrite")) continue;
            writeVP = uvp;
            break;
        }
        Assert.assertNotNull(writeVP);
        Assert.assertEquals((Object)"Write", (Object)writeVP.getDenyPermission());
        Assert.assertEquals((Object)"ReadWrite", (Object)writeVP.getPermission());
    }

    @Test
    public void testGetPrincipalsToCheck() {
        UserPrincipal principal = new UserPrincipal("bob", Arrays.asList("vps", "males"), false, false);
        String[] principals = SecurityService.getPrincipalsToCheck((Principal)principal);
        Assert.assertEquals((long)4L, (long)principals.length);
        Assert.assertTrue((boolean)Arrays.asList(principals).contains("bob"));
        Assert.assertTrue((boolean)Arrays.asList(principals).contains("vps"));
        Assert.assertTrue((boolean)Arrays.asList(principals).contains("males"));
        Assert.assertTrue((boolean)Arrays.asList(principals).contains("Everyone"));
    }
}

