/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.nuxeo.launcher.config.ConfigurationGenerator;

public abstract class AbstractConfigurationTest {
    static final Log log = LogFactory.getLog(AbstractConfigurationTest.class);
    protected ConfigurationGenerator configGenerator;
    protected File nuxeoHome;

    public File getResourceFile(String resource) {
        URL url = this.getClass().getClassLoader().getResource(resource);
        try {
            return new File(URLDecoder.decode(url.getPath(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
            return null;
        }
    }

    @Before
    public void setUp() throws Exception {
        this.nuxeoHome = new File("target/launcher");
        this.nuxeoHome.delete();
        this.nuxeoHome.mkdirs();
        File nuxeoConf = this.getResourceFile("configurator/nuxeo.conf");
        FileUtils.copyFileToDirectory((File)nuxeoConf, (File)this.nuxeoHome);
        System.setProperty("nuxeo.conf", new File(this.nuxeoHome, nuxeoConf.getName()).getPath());
        System.setProperty("nuxeo.home", this.nuxeoHome.getPath());
        System.setProperty("nuxeo.data.dir", new File(this.nuxeoHome, "data").getPath());
        System.setProperty("nuxeo.log.dir", new File(this.nuxeoHome, "log").getPath());
    }

    @After
    public void tearDown() {
        FileUtils.deleteQuietly((File)this.nuxeoHome);
        System.clearProperty("nuxeo.conf");
        System.clearProperty("nuxeo.home");
        System.clearProperty("nuxeo.data.dir");
        System.clearProperty("nuxeo.log.dir");
    }
}

