/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.helper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

public class RootSectionsManager {
    public static final String SCHEMA_PUBLISHING = "publishing";
    public static final String SECTIONS_PROPERTY_NAME = "publish:sections";
    protected static final String SECTION_ROOT_DOCUMENT_TYPE = "SectionRoot";
    protected CoreSession coreSession;

    public RootSectionsManager(CoreSession coreSession) {
        this.coreSession = coreSession;
    }

    public boolean canAddSection(DocumentModel section, DocumentModel currentDocument) {
        if (SECTION_ROOT_DOCUMENT_TYPE.equals(section.getType())) {
            return false;
        }
        String sectionId = section.getId();
        if (currentDocument.hasSchema(SCHEMA_PUBLISHING)) {
            String[] sectionIdsArray = (String[])currentDocument.getPropertyValue(SECTIONS_PROPERTY_NAME);
            List<Object> sectionIdsList = new ArrayList();
            if (sectionIdsArray != null && sectionIdsArray.length > 0) {
                sectionIdsList = Arrays.asList(sectionIdsArray);
            }
            if (sectionIdsList.contains(sectionId)) {
                return false;
            }
        }
        return true;
    }

    public String addSection(String sectionId, DocumentModel currentDocument) {
        if (sectionId != null && currentDocument.hasSchema(SCHEMA_PUBLISHING)) {
            String[] sectionIdsArray = (String[])currentDocument.getPropertyValue(SECTIONS_PROPERTY_NAME);
            List<Object> sectionIdsList = new ArrayList<String>();
            if (sectionIdsArray != null && sectionIdsArray.length > 0) {
                sectionIdsList = Arrays.asList(sectionIdsArray);
                sectionIdsList = new ArrayList(sectionIdsList);
            }
            sectionIdsList.add(sectionId);
            String[] sectionIdsListIn = new String[sectionIdsList.size()];
            sectionIdsList.toArray(sectionIdsListIn);
            currentDocument.setPropertyValue(SECTIONS_PROPERTY_NAME, (Serializable)sectionIdsListIn);
            this.coreSession.saveDocument(currentDocument);
            this.coreSession.save();
        }
        return null;
    }

    public String removeSection(String sectionId, DocumentModel currentDocument) {
        if (sectionId != null && currentDocument.hasSchema(SCHEMA_PUBLISHING)) {
            String[] sectionIdsArray = (String[])currentDocument.getPropertyValue(SECTIONS_PROPERTY_NAME);
            List<Object> sectionIdsList = new ArrayList();
            if (sectionIdsArray != null && sectionIdsArray.length > 0) {
                sectionIdsList = Arrays.asList(sectionIdsArray);
                sectionIdsList = new ArrayList<Object>(sectionIdsList);
            }
            if (!sectionIdsList.isEmpty()) {
                sectionIdsList.remove(sectionId);
                String[] sectionIdsListIn = new String[sectionIdsList.size()];
                sectionIdsList.toArray(sectionIdsListIn);
                currentDocument.setPropertyValue(SECTIONS_PROPERTY_NAME, (Serializable)sectionIdsListIn);
                this.coreSession.saveDocument(currentDocument);
                this.coreSession.save();
            }
        }
        return null;
    }
}

