/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import org.assertj.core.presentation.CollectionToString;
import org.assertj.core.presentation.NumberGrouping;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Strings;

public class HexadecimalRepresentation
implements Representation {
    public static final String PREFIX = "0x";
    public static final int NIBBLE_SIZE = 4;

    @Override
    public String toStringOf(Object object) {
        if (object instanceof Number) {
            return HexadecimalRepresentation.toStringOf((Number)object);
        }
        if (object instanceof String) {
            return HexadecimalRepresentation.toStringOf(this, (String)object);
        }
        if (object instanceof Character) {
            return HexadecimalRepresentation.toStringOf((Character)object);
        }
        return object == null ? null : CollectionToString.toStringOf(this, object);
    }

    private static String toStringOf(Number number) {
        if (number instanceof Byte) {
            return HexadecimalRepresentation.toStringOf((Byte)number);
        }
        if (number instanceof Short) {
            return HexadecimalRepresentation.toStringOf((Short)number);
        }
        if (number instanceof Integer) {
            return HexadecimalRepresentation.toStringOf((Integer)number);
        }
        if (number instanceof Long) {
            return HexadecimalRepresentation.toStringOf((Long)number);
        }
        if (number instanceof Float) {
            return HexadecimalRepresentation.toStringOf((Float)number);
        }
        if (number instanceof Double) {
            return HexadecimalRepresentation.toStringOf((Double)number);
        }
        return number == null ? null : number.toString();
    }

    private static String toStringOf(Byte b) {
        return HexadecimalRepresentation.toGroupedHex(b, 8);
    }

    private static String toStringOf(Short s) {
        return HexadecimalRepresentation.toGroupedHex(s, 16);
    }

    private static String toStringOf(Integer i) {
        return HexadecimalRepresentation.toGroupedHex(i, 32);
    }

    private static String toStringOf(Long l) {
        return HexadecimalRepresentation.toGroupedHex(l, 64);
    }

    private static String toStringOf(Float f) {
        return HexadecimalRepresentation.toGroupedHex(Float.floatToIntBits(f.floatValue()), 32);
    }

    private static String toStringOf(Double d) {
        return HexadecimalRepresentation.toGroupedHex(Double.doubleToRawLongBits(d), 64);
    }

    private static String toStringOf(Character character) {
        return Strings.concat("'", HexadecimalRepresentation.toStringOf((short)character.charValue()), "'");
    }

    private static String toStringOf(Representation representation, String s) {
        return Strings.concat("\"", representation.toStringOf(s.toCharArray()), "\"");
    }

    private static String toGroupedHex(Number value, int size) {
        return PREFIX + NumberGrouping.toHexLiteral(HexadecimalRepresentation.toHex(value, size));
    }

    private static String toHex(Number value, int sizeInBits) {
        return String.format("%0" + sizeInBits / 4 + "X", value);
    }
}

