/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag.io;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class TagsJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "tags";

    public TagsJsonEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        TagService tagService = (TagService)Framework.getService(TagService.class);
        jg.writeArrayFieldStart(NAME);
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(document);){
            for (Tag tag : tagService.getDocumentTags(wrapper.getSession(), document.getId(), wrapper.getSession().getPrincipal().getName())) {
                jg.writeStartObject();
                jg.writeStringField("label", tag.getLabel());
                jg.writeNumberField("weight", tag.getWeight());
                jg.writeEndObject();
            }
        }
        jg.writeEndArray();
    }
}

