/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import org.junit.runners.model.FrameworkMethod;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.RedisFeature;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedGuessConnectionError;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedPool;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.SimpleFeature;

@Features(value={RedisFeature.class})
@RedisFeature.Config(mode=RedisFeature.Mode.embedded, guessError=RedisEmbeddedGuessConnectionError.OnRandomCall.class)
public class RedisFailoverFeature
extends SimpleFeature {
    RedisEmbeddedPool pool;

    public void start(FeaturesRunner runner) throws Exception {
        this.pool = (RedisEmbeddedPool)((RedisExecutor)Framework.getLocalService(RedisExecutor.class)).getPool();
    }

    public void beforeMethodRun(FeaturesRunner runner, FrameworkMethod method, Object test) throws Exception {
        RedisFeature.Config config = (RedisFeature.Config)runner.getConfig(method, RedisFeature.Config.class);
        if (this.pool instanceof RedisEmbeddedPool) {
            this.pool.setError(config.guessError().newInstance());
        }
    }

    public void afterTeardown(FeaturesRunner runner) throws Exception {
        this.pool.setError(new RedisEmbeddedGuessConnectionError.NoError());
    }
}

