/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.cache.CacheFeature;
import org.nuxeo.ecm.core.redis.RedisAdmin;
import org.nuxeo.ecm.core.redis.RedisComponent;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.RedisFailoverExecutor;
import org.nuxeo.ecm.core.redis.RedisHostDescriptor;
import org.nuxeo.ecm.core.redis.RedisPoolDescriptor;
import org.nuxeo.ecm.core.redis.RedisPoolExecutor;
import org.nuxeo.ecm.core.redis.RedisSentinelDescriptor;
import org.nuxeo.ecm.core.redis.RedisServerDescriptor;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedGuessConnectionError;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedPool;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedSynchronizedExecutor;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedTraceExecutor;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.DefaultRepositoryInit;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Defaults;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.nuxeo.runtime.test.runner.SimpleFeature;
import redis.clients.util.Pool;

@Features(value={CoreFeature.class, CacheFeature.class})
@RepositoryConfig(init=DefaultRepositoryInit.class)
public class RedisFeature
extends SimpleFeature {
    public static final String PROP_MODE = "nuxeo.test.redis.mode";
    public static final String PROP_HOST = "nuxeo.test.redis.host";
    public static final String PROP_PORT = "nuxeo.test.redis.port";
    public static final Mode DEFAULT_MODE = Mode.embedded;
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 6379;
    protected Config config = (Config)Defaults.of(Config.class);

    protected Mode getMode() {
        Mode mode = this.config.mode();
        if (mode == Mode.undefined) {
            String modeProp = System.getProperty(PROP_MODE);
            mode = StringUtils.isBlank((String)modeProp) ? DEFAULT_MODE : Mode.valueOf(modeProp);
        }
        return mode;
    }

    protected String getHost() {
        String host = this.config.host();
        if (StringUtils.isEmpty((String)host)) {
            String hostProp = System.getProperty(PROP_HOST);
            host = StringUtils.isBlank((String)hostProp) ? DEFAULT_HOST : hostProp;
        }
        return host;
    }

    protected int getPort() {
        int port = this.config.port();
        if (port == 0) {
            String portProp = System.getProperty(PROP_PORT);
            port = StringUtils.isBlank((String)portProp) ? 6379 : Integer.parseInt(portProp);
        }
        return port;
    }

    protected RedisServerDescriptor newRedisServerDescriptor() {
        RedisServerDescriptor desc = new RedisServerDescriptor();
        desc.host = this.getHost();
        desc.port = this.getPort();
        return desc;
    }

    protected RedisSentinelDescriptor newRedisSentinelDescriptor() {
        RedisSentinelDescriptor desc = new RedisSentinelDescriptor();
        desc.master = "mymaster";
        desc.hosts = new RedisHostDescriptor[]{new RedisHostDescriptor(this.getHost(), this.getPort())};
        return desc;
    }

    public static void clear() throws IOException {
        RedisAdmin admin = (RedisAdmin)Framework.getService(RedisAdmin.class);
        admin.clear("*");
    }

    public static boolean setup(RuntimeHarness harness) throws Exception {
        return new RedisFeature().setupMe(harness);
    }

    protected boolean setupMe(RuntimeHarness harness) throws Exception {
        Mode mode = this.getMode();
        if (Mode.disabled.equals((Object)mode)) {
            return false;
        }
        if (harness.getOSGiAdapter().getBundle("org.nuxeo.ecm.core.event") == null) {
            harness.deployBundle("org.nuxeo.ecm.core.event");
        }
        if (harness.getOSGiAdapter().getBundle("org.nuxeo.ecm.core.storage") == null) {
            harness.deployBundle("org.nuxeo.ecm.core.storage");
        }
        if (harness.getOSGiAdapter().getBundle("org.nuxeo.ecm.core.cache") == null) {
            harness.deployBundle("org.nuxeo.ecm.core.cache");
        }
        harness.deployBundle("org.nuxeo.ecm.core.redis");
        harness.deployTestContrib("org.nuxeo.ecm.core.redis", RedisFeature.class.getResource("/redis-contribs.xml"));
        RedisComponent component = (RedisComponent)Framework.getRuntime().getComponent(RedisComponent.class.getPackage().getName());
        if (Mode.embedded.equals((Object)mode)) {
            Object executor = new RedisPoolExecutor((Pool)new RedisEmbeddedPool());
            executor = new RedisEmbeddedTraceExecutor((RedisExecutor)executor);
            executor = new RedisEmbeddedSynchronizedExecutor((RedisExecutor)executor);
            executor = new RedisFailoverExecutor(10, (RedisExecutor)executor);
            component.handleNewExecutor((RedisExecutor)executor);
        } else {
            component.registerRedisPoolDescriptor(this.getDescriptor(mode));
            component.handleNewExecutor(component.getConfig().newExecutor());
        }
        RedisFeature.clear();
        return true;
    }

    protected RedisPoolDescriptor getDescriptor(Mode mode) {
        switch (mode) {
            case sentinel: {
                return this.newRedisSentinelDescriptor();
            }
            case server: {
                return this.newRedisServerDescriptor();
            }
        }
        return null;
    }

    public void initialize(FeaturesRunner runner) throws Exception {
        this.config = (Config)runner.getConfig(Config.class);
        ((CacheFeature)runner.getFeature(CacheFeature.class)).enable();
    }

    public void start(FeaturesRunner runner) throws Exception {
        this.setupMe(((RuntimeFeature)runner.getFeature(RuntimeFeature.class)).getHarness());
    }

    public static enum Mode {
        undefined,
        disabled,
        embedded,
        server,
        sentinel;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface Config {
        public Mode mode() default Mode.undefined;

        public String host() default "";

        public int port() default 0;

        public Class<? extends RedisEmbeddedGuessConnectionError> guessError() default RedisEmbeddedGuessConnectionError.NoError.class;
    }
}

