/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.RedisFeature;
import org.nuxeo.ecm.core.redis.contribs.RedisClusterInvalidator;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepositoryService;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class, RedisFeature.class})
public class TestRedisClusterInvalidator {
    @Test
    public void testInitializeAndClose() throws Exception {
        RedisClusterInvalidator rci = this.createRedisClusterInvalidator("node1");
        rci.close();
    }

    private RedisClusterInvalidator createRedisClusterInvalidator(String node) {
        this.assumeTrueRedisServer();
        RepositoryImpl repository = this.getDefaultRepository();
        RedisClusterInvalidator rci = new RedisClusterInvalidator();
        rci.initialize(node, repository);
        return rci;
    }

    private RepositoryImpl getDefaultRepository() {
        SQLRepositoryService repositoryService = (SQLRepositoryService)Framework.getService(SQLRepositoryService.class);
        return repositoryService.getRepositoryImpl((String)repositoryService.getRepositoryNames().get(0));
    }

    private void assumeTrueRedisServer() {
        Assume.assumeTrue((String)"Require a true Redis server with pubsub support", (boolean)"server".equals(Framework.getProperty((String)"nuxeo.test.redis.mode")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendReceiveInvalidations() throws Exception {
        RedisExecutor redisExecutor = (RedisExecutor)Framework.getLocalService(RedisExecutor.class);
        redisExecutor.startMonitor();
        int delayMs = 10000;
        RedisClusterInvalidator rci2 = this.createRedisClusterInvalidator("node2");
        RedisClusterInvalidator rci1 = this.createRedisClusterInvalidator("node1");
        try {
            Invalidations invals = new Invalidations();
            invals.addModified(new RowId("dublincore", (Serializable)((Object)"docid1")));
            invals.addModified(new RowId("dublincore", (Serializable)((Object)"docid2")));
            rci1.sendInvalidations(invals);
            Invalidations invalsReceived = this.waitForInvalidation(rci2, delayMs);
            Assert.assertNotNull((String)("No invalidation received after " + delayMs + " ms"), (Object)invalsReceived.isEmpty());
            Assert.assertEquals((Object)invals.toString(), (Object)invalsReceived.toString());
        }
        finally {
            rci1.close();
            rci2.close();
            redisExecutor.stopMonitor();
        }
    }

    private Invalidations waitForInvalidation(RedisClusterInvalidator rci2, int countdown_ms) throws InterruptedException {
        Invalidations ret;
        do {
            Thread.sleep(10L);
        } while ((ret = rci2.receiveInvalidations()).isEmpty() && (countdown_ms -= 10) > 0);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendReceiveMultiInvalidations() throws Exception {
        int delayMs = 10000;
        RedisExecutor redisExecutor = (RedisExecutor)Framework.getLocalService(RedisExecutor.class);
        redisExecutor.startMonitor();
        RedisClusterInvalidator rci2 = this.createRedisClusterInvalidator("node2");
        RedisClusterInvalidator rci1 = this.createRedisClusterInvalidator("node1");
        try {
            Invalidations invals = new Invalidations();
            invals.addModified(new RowId("dublincore", (Serializable)((Object)"docid1")));
            rci1.sendInvalidations(invals);
            invals = new Invalidations();
            invals.addModified(new RowId("dublincore", (Serializable)((Object)"docid2")));
            rci1.sendInvalidations(invals);
            Invalidations invalsReceived = this.waitForInvalidation(rci2, delayMs);
            Assert.assertNotNull((Object)invals.modified);
            Assert.assertNotNull((String)("No invalidation received after " + delayMs + " ms"), (Object)invalsReceived.modified);
            Assert.assertEquals((long)2L, (long)invalsReceived.modified.size());
        }
        finally {
            rci1.close();
            rci2.close();
            redisExecutor.stopMonitor();
        }
    }
}

