/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import java.net.URL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.ecm.core.redis.RedisHostDescriptor;
import org.nuxeo.ecm.core.redis.RedisSentinelDescriptor;
import org.nuxeo.ecm.core.redis.RedisServerDescriptor;

public class TestRedisDescriptors {
    protected XMap xmap;

    protected static URL getResource(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource);
    }

    @Before
    public void setUp() throws Exception {
        this.xmap = new XMap();
        this.xmap.register(RedisServerDescriptor.class);
        this.xmap.register(RedisSentinelDescriptor.class);
        this.xmap.register(RedisHostDescriptor.class);
    }

    @Test
    public void testServer() throws Exception {
        RedisServerDescriptor desc = (RedisServerDescriptor)this.xmap.load(TestRedisDescriptors.getResource("test-redis-server-descriptor.xml"));
        Assert.assertEquals((Object)"localhost2", (Object)desc.host);
        Assert.assertEquals((long)6380L, (long)desc.port);
        Assert.assertEquals((Object)"secret", (Object)desc.password);
        Assert.assertEquals((long)1L, (long)desc.database);
        Assert.assertEquals((long)2500L, (long)desc.timeout);
    }

    @Test
    public void testSentinel() throws Exception {
        RedisSentinelDescriptor desc = (RedisSentinelDescriptor)this.xmap.load(TestRedisDescriptors.getResource("test-redis-sentinel-descriptor.xml"));
        Assert.assertEquals((long)2L, (long)desc.hosts.length);
        Assert.assertEquals((Object)"localhost", (Object)desc.hosts[0].name);
        Assert.assertEquals((long)26379L, (long)desc.hosts[0].port);
        Assert.assertEquals((Object)"localhost2", (Object)desc.hosts[1].name);
        Assert.assertEquals((long)26380L, (long)desc.hosts[1].port);
        Assert.assertEquals((Object)"secret", (Object)desc.password);
        Assert.assertEquals((long)2L, (long)desc.database);
        Assert.assertEquals((long)3000L, (long)desc.timeout);
    }
}

