/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import java.util.Calendar;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.cache.CacheFeature;
import org.nuxeo.ecm.core.model.LockManager;
import org.nuxeo.ecm.core.redis.RedisFeature;
import org.nuxeo.ecm.core.storage.lock.LockManagerService;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class, CacheFeature.class, RedisFeature.class})
public class TestRedisLockManager {
    protected static void assertTimeEquals(Calendar expected, Lock lock) {
        Assert.assertEquals((long)expected.getTimeInMillis(), (long)lock.getCreated().getTimeInMillis());
    }

    @Test
    public void testRedisLockManager() throws Exception {
        LockManager lockManager = ((LockManagerService)Framework.getLocalService(LockManagerService.class)).getLockManager("default");
        String id = "1234";
        Assert.assertNull((Object)lockManager.getLock(id));
        Calendar created = Calendar.getInstance();
        Lock lock = new Lock("bob", created);
        Assert.assertNull((Object)lockManager.setLock(id, lock));
        Lock lock1 = lockManager.getLock(id);
        Assert.assertNotNull((Object)lock1);
        Assert.assertFalse((boolean)lock1.getFailed());
        Assert.assertEquals((Object)"bob", (Object)lock1.getOwner());
        TestRedisLockManager.assertTimeEquals(created, lock1);
        Lock lock2 = new Lock("pete", created);
        Lock lock3 = lockManager.setLock(id, lock2);
        Assert.assertNotNull((Object)lock3);
        Assert.assertEquals((Object)"bob", (Object)lock3.getOwner());
        TestRedisLockManager.assertTimeEquals(created, lock3);
        Lock lock4 = lockManager.removeLock(id, "pete");
        Assert.assertNotNull((Object)lock4);
        Assert.assertTrue((boolean)lock4.getFailed());
        Assert.assertEquals((Object)"bob", (Object)lock4.getOwner());
        TestRedisLockManager.assertTimeEquals(created, lock4);
        Lock lock5 = lockManager.removeLock(id, "bob");
        Assert.assertNotNull((Object)lock5);
        Assert.assertFalse((boolean)lock5.getFailed());
        Assert.assertEquals((Object)"bob", (Object)lock5.getOwner());
        TestRedisLockManager.assertTimeEquals(created, lock5);
        Assert.assertNull((Object)lockManager.getLock(id));
        Assert.assertNull((Object)lockManager.setLock(id, lock));
        Lock lock6 = lockManager.removeLock(id, null);
        Assert.assertNotNull((Object)lock6);
        Assert.assertFalse((boolean)lock6.getFailed());
        Assert.assertEquals((Object)"bob", (Object)lock6.getOwner());
        TestRedisLockManager.assertTimeEquals(created, lock6);
        Assert.assertNull((Object)lockManager.getLock(id));
        Lock lock7 = lockManager.removeLock(id, null);
        Assert.assertNull((Object)lock7);
    }
}

