/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.redis.RedisFeature;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={RedisFeature.class})
public class TestRedisWorkSchedule {
    @Inject
    CoreSession session;
    @Inject
    CoreFeature core;
    static TestRedisWorkSchedule self;
    final CountDownLatch observed = new CountDownLatch(1);

    @Before
    public void injectSelf() {
        self = this;
    }

    @After
    public void outjectSelf() {
        self = null;
    }

    @Test
    @LocalDeploy(value={"org.nuxeo.ecm.core.event:test-redis-pfouh-listener.xml"})
    public void canSerializeEventBundles() throws InterruptedException {
        Assert.assertTrue((boolean)TransactionHelper.isTransactionActive());
        DocumentModel doc = this.session.createDocumentModel("/", "pfouh", "Document");
        doc = this.session.createDocument(doc);
        DocumentEventContext context = new DocumentEventContext(this.session, this.session.getPrincipal(), doc);
        context.newEvent("pfouh");
        context.getProperties().put("pfouh", new DocWrapper(doc));
        ((EventProducer)Framework.getService(EventProducer.class)).fireEvent(context.newEvent("pfouh"));
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        Assert.assertTrue((boolean)this.observed.await(10L, TimeUnit.SECONDS));
    }

    static class DocWrapper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final DocumentModel doc;

        public DocWrapper(DocumentModel source) {
            this.doc = source;
        }
    }

    public static class PfouhListener
    implements PostCommitEventListener {
        public void handleEvent(EventBundle events) {
            TestRedisWorkSchedule.self.observed.countDown();
        }
    }
}

