/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.redis.RedisAdmin;
import org.nuxeo.ecm.core.redis.RedisCallable;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.RedisFeature;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.core.work.api.WorkQueueMetrics;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import redis.clients.jedis.Jedis;

@Features(value={RedisFeature.class, CoreFeature.class})
@RunWith(value=FeaturesRunner.class)
public class TestRedisWorkShutdown {
    static Log log = LogFactory.getLog(TestRedisWorkShutdown.class);
    static CountDownLatch canShutdown = new CountDownLatch(2);
    static CountDownLatch canProceed = new CountDownLatch(1);
    @Inject
    WorkManager works;

    void assertMetrics(long scheduled, long running, long completed, long cancelled) {
        Assert.assertEquals((Object)new WorkQueueMetrics("default", (Number)scheduled, (Number)running, (Number)completed, (Number)cancelled), (Object)this.works.getMetrics("default"));
    }

    @Test
    public void worksArePersisted() throws InterruptedException {
        this.assertMetrics(0L, 0L, 0L, 0L);
        try {
            this.works.schedule((Work)new MyWork("first"));
            this.works.schedule((Work)new MyWork("second"));
            canShutdown.await(10L, TimeUnit.SECONDS);
            this.assertMetrics(0L, 2L, 0L, 0L);
            this.works.shutdown(0L, TimeUnit.SECONDS);
        }
        finally {
            canProceed.countDown();
        }
        List<Work> scheduled = new ScheduledRetriever().listScheduled();
        Assert.assertThat((Object)scheduled.size(), (Matcher)Matchers.is((Object)2));
        canProceed = new CountDownLatch(1);
        this.works.init();
        Assert.assertTrue((boolean)this.works.awaitCompletion(10L, TimeUnit.SECONDS));
        this.assertMetrics(0L, 0L, 2L, 2L);
    }

    class ScheduledRetriever {
        String namespace = ((RedisAdmin)Framework.getService(RedisAdmin.class)).namespace(new String[]{"work"});

        ScheduledRetriever() {
        }

        byte[] keyBytes(String value) {
            try {
                return this.namespace.concat(value).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException cause) {
                throw new UnsupportedOperationException("Cannot encode " + value, cause);
            }
        }

        byte[] queueBytes() {
            return this.keyBytes("sched:default");
        }

        byte[] dataKey() {
            return this.keyBytes("data");
        }

        List<Work> listScheduled() {
            return (List)((RedisExecutor)Framework.getService(RedisExecutor.class)).execute((RedisCallable)new RedisCallable<List<Work>>(){

                public List<Work> call(Jedis jedis) {
                    Set keys = jedis.smembers(ScheduledRetriever.this.queueBytes());
                    ArrayList<Work> list = new ArrayList<Work>(keys.size());
                    for (byte[] workIdBytes : keys) {
                        byte[] workBytes = jedis.hget(ScheduledRetriever.this.dataKey(), workIdBytes);
                        Work work = ScheduledRetriever.this.deserializeWork(workBytes);
                        list.add(work);
                    }
                    return list;
                }
            });
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Work deserializeWork(byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            ByteArrayInputStream bain = new ByteArrayInputStream(bytes);
            try (ObjectInputStream in = new ObjectInputStream(bain);){
                Work work = (Work)in.readObject();
                return work;
            }
            catch (RuntimeException cause) {
                throw cause;
            }
            catch (IOException | ClassNotFoundException cause) {
                throw new RuntimeException("Cannot deserialize work", cause);
            }
        }
    }

    public static class MyWork
    extends AbstractWork {
        private static final long serialVersionUID = 1L;

        MyWork(String id) {
            super(id);
            this.setProgress(new Work.Progress(0L, 2L));
        }

        public String getTitle() {
            return "waiting work";
        }

        Work.Progress nextProgress() {
            Work.Progress progress = this.getProgress();
            progress = new Work.Progress(progress.getCurrent() + 1L, progress.getTotal());
            this.setProgress(progress);
            return progress;
        }

        public void work() {
            Work.Progress progress = this.nextProgress();
            if (progress.getCurrent() < progress.getTotal()) {
                try {
                    log.debug((Object)(this.id + " waiting for shutdown"));
                    canShutdown.countDown();
                    canProceed.await(1L, TimeUnit.MINUTES);
                    Assert.assertTrue((boolean)this.isSuspending());
                    this.suspended();
                }
                catch (InterruptedException cause) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public String toString() {
            return this.id;
        }
    }
}

