/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.embedded;

import com.lordofthejars.nosqlunit.redis.embedded.NoArgsJedis;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.joor.Reflect;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedConnection;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedGuessConnectionError;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedLuaEngine;
import redis.clients.jedis.Jedis;

public class RedisEmbeddedFactory
implements PooledObjectFactory<Jedis> {
    final RedisEmbeddedConnection connection = this.wrapConnection(new RedisEmbeddedConnection());
    RedisEmbeddedGuessConnectionError error = new RedisEmbeddedGuessConnectionError.NoError();
    protected final RedisEmbeddedLuaEngine lua = new RedisEmbeddedLuaEngine(this.connection);

    RedisEmbeddedConnection wrapConnection(RedisEmbeddedConnection connection) {
        connection = this.synchronizedConnection(connection);
        connection = this.logConnection(connection);
        return connection;
    }

    RedisEmbeddedConnection logConnection(final RedisEmbeddedConnection connection) {
        final Log log = LogFactory.getLog(RedisEmbeddedConnection.class);
        if (!log.isTraceEnabled()) {
            return connection;
        }
        class Logger
        implements MethodInterceptor {
            Logger() {
            }

            public Object intercept(Object object, Method method, Object[] arguments, MethodProxy proxy) throws Throwable {
                try {
                    Object result = Reflect.on((Object)((Object)connection)).call(method.getName(), arguments).get();
                    log.trace((Object)String.format("%s(%s) <- %s", method.getName(), Arrays.deepToString(arguments), result));
                    return result;
                }
                catch (Throwable error) {
                    log.trace((Object)String.format("%s(%s) <- %s", method.getName(), Arrays.deepToString(arguments), error));
                    throw error;
                }
            }

            RedisEmbeddedConnection createProxy() {
                return (RedisEmbeddedConnection)((Object)RedisEmbeddedConnection.class.cast(Enhancer.create(RedisEmbeddedConnection.class, (Callback)this)));
            }
        }
        return new Logger().createProxy();
    }

    RedisEmbeddedConnection synchronizedConnection(final RedisEmbeddedConnection connection) {
        class Synchronizer
        implements MethodInterceptor {
            Synchronizer() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object intercept(Object object, Method method, Object[] arguments, MethodProxy proxy) throws Throwable {
                RedisEmbeddedConnection redisEmbeddedConnection = connection;
                synchronized (redisEmbeddedConnection) {
                    return Reflect.on((Object)((Object)connection)).call(method.getName(), arguments).get();
                }
            }

            RedisEmbeddedConnection createProxy() {
                return (RedisEmbeddedConnection)((Object)RedisEmbeddedConnection.class.cast(Enhancer.create(RedisEmbeddedConnection.class, (Callback)this)));
            }
        }
        return new Synchronizer().createProxy();
    }

    public PooledObject<Jedis> makeObject() throws Exception {
        class TryFailoverMethod
        implements MethodInterceptor {
            TryFailoverMethod() {
            }

            public Object intercept(Object object, Method method, Object[] arguments, MethodProxy proxy) throws Throwable {
                if (!method.getDeclaringClass().equals(Object.class)) {
                    RedisEmbeddedFactory.this.error.guessError();
                }
                return Reflect.on((Object)((Object)RedisEmbeddedFactory.this.connection)).call(method.getName(), arguments).get();
            }

            Jedis createProxy() {
                return (Jedis)Jedis.class.cast(Enhancer.create(NoArgsJedis.class, (Callback)this));
            }
        }
        Jedis jedis = new TryFailoverMethod().createProxy();
        DefaultPooledObject pooled = new DefaultPooledObject((Object)jedis);
        LogFactory.getLog(RedisEmbeddedFactory.class).trace((Object)("created " + pooled));
        return pooled;
    }

    public void destroyObject(PooledObject<Jedis> p) throws Exception {
    }

    public boolean validateObject(PooledObject<Jedis> p) {
        return true;
    }

    public void activateObject(PooledObject<Jedis> p) throws Exception {
    }

    public void passivateObject(PooledObject<Jedis> p) throws Exception {
    }
}

