/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.embedded;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import org.apache.commons.codec.binary.Hex;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.jse.CoerceLuaToJava;
import org.luaj.vm2.script.LuaScriptEngine;
import org.luaj.vm2.script.LuaScriptEngineFactory;
import org.luaj.vm2.script.LuajContext;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedConnection;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedLuaLibrary;

public class RedisEmbeddedLuaEngine {
    protected final Map<String, CompiledScript> binaries = new HashMap<String, CompiledScript>();
    protected final LuaScriptEngine engine;

    public RedisEmbeddedLuaEngine(RedisEmbeddedConnection connection) {
        this.engine = this.initEngine(connection);
    }

    public String load(String content) throws ScriptException {
        String md5 = this.md5(content);
        CompiledScript chunk = null;
        chunk = this.engine.compile(content);
        this.binaries.put(md5, chunk);
        return md5;
    }

    protected LuaScriptEngine initEngine(RedisEmbeddedConnection connection) {
        LuaScriptEngine engine = (LuaScriptEngine)new LuaScriptEngineFactory().getScriptEngine();
        LuajContext context = (LuajContext)engine.getContext();
        LuaValue redis = context.globals.load((LuaValue)new RedisEmbeddedLuaLibrary(connection));
        context.globals.set("redis", redis);
        return engine;
    }

    protected String md5(String content) {
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException cause) {
            throw new NuxeoException("Cannot load sha digester", (Throwable)cause);
        }
        byte[] key = sha.digest(content.getBytes());
        return Hex.encodeHexString((byte[])key);
    }

    public boolean exists(String key) {
        return this.binaries.containsKey(key);
    }

    public void flush() {
        this.binaries.clear();
    }

    public Object evalsha(String sha, List<String> keys, List<String> args) throws ScriptException {
        CompiledScript script = this.binaries.get(sha);
        Bindings bindings = this.engine.createBindings();
        bindings.put("KEYS", (Object)keys.toArray(new String[keys.size()]));
        bindings.put("ARGV", (Object)args.toArray(new String[args.size()]));
        Object result = script.eval(bindings);
        return this.coerce(result);
    }

    public Object evalsha(byte[] sha, List<byte[]> keys, List<byte[]> args) throws ScriptException {
        String shaStr = new String(sha, StandardCharsets.US_ASCII);
        CompiledScript script = this.binaries.get(shaStr);
        Bindings bindings = this.engine.createBindings();
        bindings.put("KEYS", (Object)keys.toArray());
        bindings.put("ARGV", (Object)args.toArray());
        Object result = script.eval(bindings);
        return this.coerce(result);
    }

    protected Object coerce(Object result) {
        if (result instanceof LuaValue) {
            LuaValue value = (LuaValue)result;
            if (value.isboolean() && !value.toboolean()) {
                return null;
            }
            if (value.istable()) {
                LuaValue element = value.get(1);
                if (element.isnumber()) {
                    return Arrays.asList((Number[])CoerceLuaToJava.coerce((LuaValue)value, Number[].class));
                }
                if (element.isstring()) {
                    return Arrays.asList((String[])CoerceLuaToJava.coerce((LuaValue)value, String[].class));
                }
                throw new UnsupportedOperationException("unsupported table of " + element.typename());
            }
            return value.tojstring();
        }
        return result;
    }
}

