/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.embedded;

import java.util.Collection;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.CoerceLuaToJava;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedConnection;

public class RedisEmbeddedLuaLibrary
extends TwoArgFunction {
    protected final RedisEmbeddedConnection connection;

    public RedisEmbeddedLuaLibrary(RedisEmbeddedConnection connection) {
        this.connection = connection;
    }

    public LuaValue call(LuaValue modname, LuaValue env) {
        LuaTable library = RedisEmbeddedLuaLibrary.tableOf();
        library.set("call", (LuaValue)new RedisCall());
        env.set("redis", (LuaValue)library);
        return library;
    }

    protected LuaValue valueOfOrFalse(Object value) {
        if (value == null) {
            return LuaValue.valueOf((boolean)false);
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return CoerceJavaToLua.coerce((Object)collection.toArray());
        }
        return CoerceJavaToLua.coerce((Object)value);
    }

    public class RedisCall
    extends LibFunction {
        public Varargs invoke(Varargs varargs) {
            String opcode = varargs.checkjstring(1);
            switch (opcode.toLowerCase()) {
                case "del": 
                case "hget": 
                case "hset": 
                case "hincrby": 
                case "hdecrby": 
                case "lrem": {
                    return this.call(varargs.arg(1), (LuaValue)LuaValue.tableOf((Varargs)varargs, (int)1));
                }
            }
            throw new UnsupportedOperationException(opcode);
        }

        public LuaValue call(LuaValue luaOpcode, LuaValue luaKey) {
            String opcode = (String)CoerceLuaToJava.coerce((LuaValue)luaOpcode, String.class);
            switch (opcode.toLowerCase()) {
                case "get": {
                    String key = (String)CoerceLuaToJava.coerce((LuaValue)luaKey, String.class);
                    return RedisEmbeddedLuaLibrary.this.valueOfOrFalse(RedisEmbeddedLuaLibrary.this.connection.get(key));
                }
                case "del": {
                    if (luaKey.istable() || luaKey.touserdata() instanceof Object[]) {
                        String[] keys = (String[])CoerceLuaToJava.coerce((LuaValue)luaKey, String[].class);
                        return RedisEmbeddedLuaLibrary.this.valueOfOrFalse(RedisEmbeddedLuaLibrary.this.connection.del(keys));
                    }
                    String key = (String)CoerceLuaToJava.coerce((LuaValue)luaKey, String.class);
                    return RedisEmbeddedLuaLibrary.this.valueOfOrFalse(RedisEmbeddedLuaLibrary.this.connection.del(key));
                }
                case "keys": {
                    String key = (String)CoerceLuaToJava.coerce((LuaValue)luaKey, String.class);
                    LuaTable table = LuaValue.tableOf();
                    int i = 0;
                    for (String value : RedisEmbeddedLuaLibrary.this.connection.keys(key)) {
                        table.rawset(++i, (LuaValue)LuaValue.valueOf((String)value));
                    }
                    return table;
                }
                case "hget": {
                    String key = (String)CoerceLuaToJava.coerce((LuaValue)luaKey.get(2), String.class);
                    String field = (String)CoerceLuaToJava.coerce((LuaValue)luaKey.get(3), String.class);
                    return RedisEmbeddedLuaLibrary.this.valueOfOrFalse(RedisEmbeddedLuaLibrary.this.connection.hget(key.getBytes(), field.getBytes()));
                }
                case "hset": {
                    String key = (String)CoerceLuaToJava.coerce((LuaValue)luaKey.get(2), String.class);
                    String field = (String)CoerceLuaToJava.coerce((LuaValue)luaKey.get(3), String.class);
                    Object value = CoerceLuaToJava.coerce((LuaValue)luaKey.get(4), byte[].class);
                    return RedisEmbeddedLuaLibrary.this.valueOfOrFalse(RedisEmbeddedLuaLibrary.this.connection.hset(key.getBytes(), field.getBytes(), (byte[])value));
                }
                case "hincrby": {
                    String key = (String)CoerceLuaToJava.coerce((LuaValue)luaKey.get(2), String.class);
                    String field = (String)CoerceLuaToJava.coerce((LuaValue)luaKey.get(3), String.class);
                    Long value = (Long)CoerceLuaToJava.coerce((LuaValue)luaKey.get(4), Long.class);
                    return RedisEmbeddedLuaLibrary.this.valueOfOrFalse(RedisEmbeddedLuaLibrary.this.connection.hincrBy(key.getBytes(), field.getBytes(), value));
                }
                case "lrem": {
                    String key = (String)CoerceLuaToJava.coerce((LuaValue)luaKey.get(2), String.class);
                    Long value = (Long)CoerceLuaToJava.coerce((LuaValue)luaKey.get(3), Long.class);
                    String field = (String)CoerceLuaToJava.coerce((LuaValue)luaKey.get(4), String.class);
                    return RedisEmbeddedLuaLibrary.this.valueOfOrFalse(RedisEmbeddedLuaLibrary.this.connection.lrem(key.getBytes(), value, field.getBytes()));
                }
            }
            throw new UnsupportedOperationException(opcode);
        }

        public LuaValue call(LuaValue luaOpcode, LuaValue luaKey, LuaValue luaValue) {
            String opcode = (String)CoerceLuaToJava.coerce((LuaValue)luaOpcode, String.class);
            String key = (String)CoerceLuaToJava.coerce((LuaValue)luaKey, String.class);
            String value = (String)CoerceLuaToJava.coerce((LuaValue)luaValue, String.class);
            switch (opcode.toLowerCase()) {
                case "set": {
                    return RedisEmbeddedLuaLibrary.this.valueOfOrFalse(RedisEmbeddedLuaLibrary.this.connection.set(key, value));
                }
                case "srem": {
                    return RedisEmbeddedLuaLibrary.this.valueOfOrFalse(RedisEmbeddedLuaLibrary.this.connection.srem(key, new String[]{value}));
                }
                case "hdel": {
                    return RedisEmbeddedLuaLibrary.this.valueOfOrFalse(RedisEmbeddedLuaLibrary.this.connection.hdel(key, new String[]{value}));
                }
                case "hget": {
                    return RedisEmbeddedLuaLibrary.this.valueOfOrFalse(RedisEmbeddedLuaLibrary.this.connection.hget(key, value));
                }
                case "sadd": {
                    return RedisEmbeddedLuaLibrary.this.valueOfOrFalse(RedisEmbeddedLuaLibrary.this.connection.sadd(key, new String[]{value}));
                }
                case "lpush": {
                    return RedisEmbeddedLuaLibrary.this.valueOfOrFalse(RedisEmbeddedLuaLibrary.this.connection.lpush(key, new String[]{value}));
                }
            }
            throw new UnsupportedOperationException(opcode);
        }

        public LuaValue call(LuaValue luaOpcode, LuaValue luaKey, LuaValue luaArg1, LuaValue luaArg2) {
            String opcode = (String)CoerceLuaToJava.coerce((LuaValue)luaOpcode, String.class);
            String key = (String)CoerceLuaToJava.coerce((LuaValue)luaKey, String.class);
            switch (opcode.toLowerCase()) {
                case "hincrby": {
                    String field = (String)CoerceLuaToJava.coerce((LuaValue)luaArg1, String.class);
                    Long value = (Long)CoerceLuaToJava.coerce((LuaValue)luaArg2, Long.class);
                    return RedisEmbeddedLuaLibrary.this.valueOfOrFalse(RedisEmbeddedLuaLibrary.this.connection.hincrBy(key, field, value));
                }
                case "lrem": {
                    Long value = (Long)CoerceLuaToJava.coerce((LuaValue)luaArg1, Long.class);
                    String field = (String)CoerceLuaToJava.coerce((LuaValue)luaArg2, String.class);
                    return RedisEmbeddedLuaLibrary.this.valueOfOrFalse(RedisEmbeddedLuaLibrary.this.connection.lrem(key, value, field));
                }
            }
            throw new UnsupportedOperationException(opcode);
        }
    }
}

