/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.transientstore;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.contribs.RedisTransientStore;
import org.nuxeo.ecm.core.redis.transientstore.TransientStoreRedisFeature;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.transientstore.test.TransientStoreFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={TransientStoreFeature.class, TransientStoreRedisFeature.class})
public class TestRedisSpecificTransientStore {
    protected static final String NAMESPACE = "nuxeo:transientStore:testStore:";
    @Inject
    protected TransientStoreService tss;
    @Inject
    protected RedisExecutor redisExecutor;

    @Test
    public void verifyKeySet() {
        TransientStore ts = this.tss.getStore("testStore");
        ts.setCompleted("size2", true);
        ts.setCompleted("key1", true);
        ts.putParameter("key2", "foo", (Serializable)((Object)"bar"));
        ts.setCompleted("key3", true);
        ts.putParameter("key3", "foo", (Serializable)((Object)"bar"));
        ts.putBlobs("key4", Arrays.asList(new StringBlob("joe"), new StringBlob("jack")));
        ts.putParameter("key5", "foo", (Serializable)((Object)"bar"));
        ts.putBlobs("key5", Arrays.asList(new StringBlob("joe"), new StringBlob("jack")));
        HashSet<String> expectedInternalKeys = new HashSet<String>();
        expectedInternalKeys.add("size");
        expectedInternalKeys.add("size2");
        expectedInternalKeys.add("key1");
        expectedInternalKeys.add("key2:params");
        expectedInternalKeys.add("key3");
        expectedInternalKeys.add("key3:params");
        expectedInternalKeys.add("key4");
        expectedInternalKeys.add("key4:blobs:0");
        expectedInternalKeys.add("key4:blobs:1");
        expectedInternalKeys.add("key5");
        expectedInternalKeys.add("key5:params");
        expectedInternalKeys.add("key5:blobs:0");
        expectedInternalKeys.add("key5:blobs:1");
        Set internalKeys = (Set)this.redisExecutor.execute(jedis -> jedis.keys("nuxeo:transientStore:testStore:*"));
        Assert.assertEquals(expectedInternalKeys.stream().map(key -> NAMESPACE + key).collect(Collectors.toSet()), (Object)internalKeys);
        HashSet<String> expectedKeys = new HashSet<String>();
        expectedKeys.add("size2");
        expectedKeys.add("key1");
        expectedKeys.add("key2");
        expectedKeys.add("key3");
        expectedKeys.add("key4");
        expectedKeys.add("key5");
        Assert.assertEquals(expectedKeys, (Object)ts.keySet());
    }

    @Test
    public void testTTL() throws Exception {
        TransientStore ts = this.tss.getStore("testStore");
        RedisTransientStore redisTS = (RedisTransientStore)ts;
        Assert.assertTrue((redisTS.getTTL("unknown") < 0L ? 1 : 0) != 0);
        redisTS.putParameter("params", "param1", (Serializable)((Object)"value1"));
        long ttl = redisTS.getTTL("params");
        Assert.assertTrue((ttl > 0L && ttl <= 7200L ? 1 : 0) != 0);
        redisTS.putBlobs("blobs", Collections.singletonList(new StringBlob("content")));
        ttl = redisTS.getTTL("blobs");
        Assert.assertTrue((ttl > 0L && ttl <= 7200L ? 1 : 0) != 0);
        redisTS.release("params");
        ttl = redisTS.getTTL("params");
        Assert.assertTrue((ttl > 0L && ttl <= 600L ? 1 : 0) != 0);
        redisTS.release("blobs");
        ttl = redisTS.getTTL("blobs");
        Assert.assertTrue((ttl > 0L && ttl <= 600L ? 1 : 0) != 0);
    }
}

