/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.tests;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.codec.digest.DigestUtils;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class Helper {
    public static final String DELETE_TRANSITION = "delete";
    public static final String FILE1_CONTENT = "Noodles with rice";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream in, String charset) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buf = new byte[256];
        try {
            int n;
            while ((n = in.read(buf)) != -1) {
                os.write(buf, 0, n);
            }
        }
        finally {
            in.close();
        }
        return os.toString(charset);
    }

    public static GregorianCalendar getCalendar(int year, int month, int day, int hours, int minutes, int seconds) {
        TimeZone tz = TimeZone.getTimeZone("GMT-02:00");
        return Helper.getCalendar(year, month, day, hours, minutes, seconds, tz);
    }

    public static GregorianCalendar getCalendar(int year, int month, int day, int hours, int minutes, int seconds, TimeZone tz) {
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance(tz);
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hours);
        cal.set(12, minutes);
        cal.set(13, seconds);
        cal.set(14, 0);
        return cal;
    }

    public static Map<String, String> makeNuxeoRepository(CoreSession session) {
        return Helper.makeNuxeoRepository(session, false);
    }

    public static Map<String, String> makeNuxeoRepository(CoreSession session, boolean addProxy) {
        String digest;
        Blob thumbnailBlob;
        PathRef defaultDomain = new PathRef("/default-domain");
        if (session.exists((DocumentRef)defaultDomain)) {
            session.removeDocument((DocumentRef)defaultDomain);
        }
        HashMap<String, String> info = new HashMap<String, String>();
        DocumentModelImpl folder1 = new DocumentModelImpl("/", "testfolder1", "Folder");
        folder1.setPropertyValue("dc:title", (Serializable)((Object)"testfolder1_Title"));
        folder1 = Helper.createDocument(session, (DocumentModel)folder1);
        DocumentModelImpl file1 = new DocumentModelImpl("/testfolder1", "testfile1", "File");
        file1.setPropertyValue("dc:title", (Serializable)((Object)"testfile1_Title"));
        file1.setPropertyValue("dc:description", (Serializable)((Object)"testfile1_description"));
        String content = FILE1_CONTENT;
        String filename = "testfile.txt";
        Blob blob1 = Blobs.createBlob((String)content);
        blob1.setDigest(DigestUtils.md5Hex((String)content));
        blob1.setFilename(filename);
        file1.setPropertyValue("content", (Serializable)blob1);
        GregorianCalendar cal1 = Helper.getCalendar(2007, 3, 1, 12, 0, 0);
        file1.setPropertyValue("dc:created", (Serializable)cal1);
        file1.setPropertyValue("dc:modified", (Serializable)cal1);
        file1.setPropertyValue("dc:creator", (Serializable)((Object)"michael"));
        file1.setPropertyValue("dc:lastContributor", (Serializable)((Object)"john"));
        file1.setPropertyValue("dc:coverage", (Serializable)((Object)"foo/bar"));
        file1.setPropertyValue("dc:subjects", (Serializable)new String[]{"foo", "gee/moo"});
        file1.addFacet("Thumbnail");
        try {
            thumbnailBlob = Blobs.createBlob((InputStream)Helper.class.getResource("/text.png").openStream(), (String)"image/png");
            digest = DigestUtils.md5Hex((InputStream)thumbnailBlob.getStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        thumbnailBlob.setDigest(digest);
        thumbnailBlob.setFilename("test.png");
        file1.setPropertyValue("thumb:thumbnail", (Serializable)thumbnailBlob);
        file1 = Helper.createDocument(session, (DocumentModel)file1);
        ACLImpl acl = new ACLImpl();
        acl.add(new ACE("bob", "Browse", true));
        ACPImpl acp = new ACPImpl();
        acp.addACL((ACL)acl);
        file1.setACP((ACP)acp, true);
        DocumentModelImpl file2 = new DocumentModelImpl("/testfolder1", "testfile2", "File");
        file2.setPropertyValue("dc:title", (Serializable)((Object)"testfile2_Title"));
        file2.setPropertyValue("dc:description", (Serializable)((Object)"something"));
        GregorianCalendar cal2 = Helper.getCalendar(2007, 4, 1, 12, 0, 0);
        file2.setPropertyValue("dc:created", (Serializable)cal2);
        file2.setPropertyValue("dc:creator", (Serializable)((Object)"pete"));
        file2.setPropertyValue("dc:contributors", (Serializable)new String[]{"pete", "bob"});
        file2.setPropertyValue("dc:lastContributor", (Serializable)((Object)"bob"));
        file2.setPropertyValue("dc:coverage", (Serializable)((Object)"football"));
        file2 = Helper.createDocument(session, (DocumentModel)file2);
        acl = new ACLImpl();
        acl.add(new ACE("bob", "Browse", true));
        acp = new ACPImpl();
        acp.addACL((ACL)acl);
        file2.setACP((ACP)acp, true);
        DocumentModelImpl file3 = new DocumentModelImpl("/testfolder1", "testfile3", "Note");
        file3.setPropertyValue("note", (Serializable)((Object)"this is a note"));
        file3.setPropertyValue("dc:title", (Serializable)((Object)"testfile3_Title"));
        file3.setPropertyValue("dc:description", (Serializable)((Object)"testfile3_desc1 testfile3_desc2,  testfile3_desc3"));
        file3.setPropertyValue("dc:contributors", (Serializable)new String[]{"bob", "john"});
        file3.setPropertyValue("dc:lastContributor", (Serializable)((Object)"john"));
        file3 = Helper.createDocument(session, (DocumentModel)file3);
        DocumentModelImpl folder2 = new DocumentModelImpl("/", "testfolder2", "Folder");
        folder2.setPropertyValue("dc:title", (Serializable)((Object)"testfolder2_Title"));
        folder2 = Helper.createDocument(session, (DocumentModel)folder2);
        DocumentModelImpl folder3 = new DocumentModelImpl("/testfolder2", "testfolder3", "Folder");
        folder3.setPropertyValue("dc:title", (Serializable)((Object)"testfolder3_Title"));
        folder3 = Helper.createDocument(session, (DocumentModel)folder3);
        DocumentModelImpl folder4 = new DocumentModelImpl("/testfolder2", "testfolder4", "Folder");
        folder4.setPropertyValue("dc:title", (Serializable)((Object)"testfolder4_Title"));
        folder4 = Helper.createDocument(session, (DocumentModel)folder4);
        DocumentModelImpl file4 = new DocumentModelImpl("/testfolder2/testfolder3", "testfile4", "File");
        file4.setPropertyValue("dc:title", (Serializable)((Object)"testfile4_Title"));
        file4.setPropertyValue("dc:description", (Serializable)((Object)"something"));
        file4 = Helper.createDocument(session, (DocumentModel)file4);
        DocumentModelImpl file5 = new DocumentModelImpl("/testfolder1", "testfile5", "File");
        file5.setPropertyValue("dc:title", (Serializable)((Object)"title5"));
        file5 = Helper.createDocument(session, (DocumentModel)file5);
        file5.followTransition(DELETE_TRANSITION);
        file5 = Helper.saveDocument(session, (DocumentModel)file5);
        info.put("file5id", file5.getId());
        DocumentModelImpl file6 = new DocumentModelImpl("/testfolder2/testfolder3", "testfile6", "Note");
        file6.setPropertyValue("dc:title", (Serializable)((Object)"title6"));
        file6 = Helper.createDocument(session, (DocumentModel)file6);
        if (addProxy) {
            Helper.sleepForAuditGranularity();
            file6.putContextData("disableDublinCoreListener", (Serializable)Boolean.TRUE);
            DocumentRef file6verref = file6.checkIn(VersioningOption.MINOR, null);
            Helper.sleepForAuditGranularity();
            DocumentModel proxy = session.createProxy(file6verref, folder2.getRef());
            info.put("file6verid", proxy.getSourceId());
            info.put("proxyid", proxy.getId());
        }
        return info;
    }

    public static void sleepForAuditGranularity() {
        try {
            Thread.sleep(2L);
        }
        catch (InterruptedException e) {
            ExceptionUtils.checkInterrupt((Exception)e);
        }
    }

    public static DocumentModel createDocument(CoreSession session, DocumentModel doc) {
        Helper.sleepForAuditGranularity();
        doc.putContextData("disableDublinCoreListener", (Serializable)Boolean.TRUE);
        return session.createDocument(doc);
    }

    public static DocumentModel saveDocument(CoreSession session, DocumentModel doc) {
        Helper.sleepForAuditGranularity();
        return session.saveDocument(doc);
    }

    public static String createUserWorkspace(CoreSession repo, String username) {
        DocumentModelImpl container = new DocumentModelImpl("/", "UserWorkspaceRoot", "UserWorkspaceRoot");
        container = repo.createDocument((DocumentModel)container);
        ACPImpl acp = new ACPImpl();
        ACLImpl acl = new ACLImpl();
        acl.setACEs(new ACE[]{new ACE("Everyone", "Everything", false)});
        acp.addACL((ACL)acl);
        container.setACP((ACP)acp, true);
        DocumentModelImpl ws = new DocumentModelImpl(container.getPathAsString(), username, "Workspace");
        ws = repo.createDocument((DocumentModel)ws);
        ACPImpl acp2 = new ACPImpl();
        ACLImpl acl2 = new ACLImpl();
        acl2.setACEs(new ACE[]{new ACE(username, "Everything", true)});
        acp2.addACL((ACL)acl2);
        ws.setACP((ACP)acp2, true);
        repo.save();
        if (TransactionHelper.isTransactionActive()) {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
        return ws.getPathAsString();
    }
}

