/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.search.core;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.search.core.InvalidSearchParameterException;
import org.nuxeo.ecm.platform.search.core.SavedSearch;
import org.nuxeo.ecm.platform.search.core.SavedSearchService;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.runtime.api.Framework;

public class SavedSearchServiceImpl
implements SavedSearchService {
    @Override
    public SavedSearch createSavedSearch(CoreSession session, String title, String queryParams, Map<String, String> namedParams, String query, String queryLanguage, String pageProviderName, Long pageSize, Long currentPageIndex, Long maxResults, String sortBy, String sortOrder, String contentViewData) throws InvalidSearchParameterException, IOException {
        if (StringUtils.isEmpty((String)title)) {
            throw new InvalidSearchParameterException("title cannot be empty");
        }
        if (!(StringUtils.isEmpty((String)query) && StringUtils.isEmpty((String)queryLanguage) || StringUtils.isEmpty((String)pageProviderName))) {
            throw new InvalidSearchParameterException("query and page provider parameters are mutually exclusive (query, queryLanguage, pageProviderName)");
        }
        if (StringUtils.isEmpty((String)query) && StringUtils.isEmpty((String)queryLanguage) && StringUtils.isEmpty((String)pageProviderName)) {
            throw new InvalidSearchParameterException("query or page provider parameters are missing (query, queryLanguage, pageProviderName)");
        }
        if (!StringUtils.isEmpty((String)query) && StringUtils.isEmpty((String)queryLanguage)) {
            throw new InvalidSearchParameterException("queryLanguage parameter is missing");
        }
        if (StringUtils.isEmpty((String)query) && !StringUtils.isEmpty((String)queryLanguage)) {
            throw new InvalidSearchParameterException("query parameter is missing");
        }
        UserWorkspaceService userWorkspaceService = (UserWorkspaceService)Framework.getService(UserWorkspaceService.class);
        DocumentModel uws = userWorkspaceService.getCurrentUserPersonalWorkspace(session, null);
        String searchDocumentType = !StringUtils.isEmpty((String)pageProviderName) ? ((PageProviderService)Framework.getService(PageProviderService.class)).getPageProviderDefinition(pageProviderName).getSearchDocumentType() : null;
        DocumentModel savedSearchDoc = session.createDocumentModel(uws.getPathAsString(), title, searchDocumentType != null ? searchDocumentType : "SavedSearch");
        SavedSearch savedSearch = (SavedSearch)savedSearchDoc.getAdapter(SavedSearch.class);
        savedSearch.setTitle(title);
        savedSearch.setQueryParams(queryParams);
        savedSearch.setNamedParams(namedParams);
        savedSearch.setQuery(query);
        savedSearch.setQueryLanguage(queryLanguage);
        savedSearch.setPageProviderName(pageProviderName);
        savedSearch.setPageSize(pageSize);
        savedSearch.setCurrentPageIndex(currentPageIndex);
        savedSearch.setMaxResults(maxResults);
        savedSearch.setSortBy(sortBy);
        savedSearch.setSortOrder(sortOrder);
        savedSearch.setContentViewData(contentViewData);
        savedSearchDoc = session.createDocument(savedSearchDoc);
        savedSearch = (SavedSearch)savedSearchDoc.getAdapter(SavedSearch.class);
        ACP acp = savedSearchDoc.getACP();
        ACL acl = acp.getOrCreateACL("local");
        Principal principal = session.getPrincipal();
        if (principal != null) {
            acl.add(new ACE(principal.getName(), "Everything", true));
        }
        acp.addACL(acl);
        savedSearchDoc.setACP(acp, true);
        return savedSearch;
    }

    @Override
    public SavedSearch getSavedSearch(CoreSession session, String id) {
        IdRef docRef = new IdRef(id);
        DocumentModel savedSearchDoc = session.getDocument((DocumentRef)docRef);
        if (savedSearchDoc != null) {
            return (SavedSearch)savedSearchDoc.getAdapter(SavedSearch.class);
        }
        return null;
    }

    @Override
    public SavedSearch saveSavedSearch(CoreSession session, SavedSearch search) throws InvalidSearchParameterException, IOException {
        if (StringUtils.isEmpty((String)search.getTitle())) {
            throw new InvalidSearchParameterException("title cannot be empty");
        }
        if (!(StringUtils.isEmpty((String)search.getQuery()) && StringUtils.isEmpty((String)search.getQueryLanguage()) || StringUtils.isEmpty((String)search.getPageProviderName()))) {
            throw new InvalidSearchParameterException("query and page provider parameters are mutually exclusive (query, queryLanguage, pageProviderName)");
        }
        if (StringUtils.isEmpty((String)search.getQuery()) && StringUtils.isEmpty((String)search.getQueryLanguage()) && StringUtils.isEmpty((String)search.getPageProviderName())) {
            throw new InvalidSearchParameterException("query or page provider parameters are missing (query, queryLanguage, pageProviderName)");
        }
        if (!StringUtils.isEmpty((String)search.getQuery()) && StringUtils.isEmpty((String)search.getQueryLanguage())) {
            throw new InvalidSearchParameterException("queryLanguage parameter is missing");
        }
        if (StringUtils.isEmpty((String)search.getQuery()) && !StringUtils.isEmpty((String)search.getQueryLanguage())) {
            throw new InvalidSearchParameterException("query parameter is missing");
        }
        DocumentModel doc = session.saveDocument(search.getDocument());
        search.setDocument(doc);
        return search;
    }

    @Override
    public void deleteSavedSearch(CoreSession session, SavedSearch search) {
        session.removeDocument((DocumentRef)new IdRef(search.getId()));
    }
}

