/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang.SerializationUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.validation.DocumentValidationService;
import org.nuxeo.ecm.core.schema.types.SimpleType;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.directory.DirectoryEntryResolver;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryEntry;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.sql.SQLDirectoryFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={SQLDirectoryFeature.class, CoreFeature.class})
@RepositoryConfig(cleanup=Granularity.METHOD)
@LocalDeploy(value={"org.nuxeo.ecm.directory.sql.tests:test-directory-resolver-contrib.xml"})
public class TestDirectoryEntryResolver {
    private static final String REFERENCED_DIRECTORY2 = "referencedDirectory2";
    private static final String REFERENCED_DIRECTORY1 = "referencedDirectory1";
    private static final String HIERARCHICAL_DIRECTORY = "hierarchicalDirectory";
    private static final String REF1_XPATH = "dr:directory1Ref";
    private static final String REF2_XPATH = "dr:directory2Ref";
    private static final String HIERARCHICAL_REF_XPATH = "dr:hierarchicalDirectoryRef";
    private static final String ENTRY_ID = "123";
    private static final String ENTRY_LABEL = "Label123";
    @Inject
    protected CoreSession coreSession;
    @Inject
    protected DocumentValidationService validator;
    @Inject
    protected DirectoryService directoryService;
    protected DocumentModel doc;
    protected DocumentModel entry1;

    @Before
    public void setup() throws Exception {
        try (Session session1 = this.directoryService.open(REFERENCED_DIRECTORY1);){
            this.entry1 = session1.getEntry(ENTRY_ID);
        }
        this.doc = this.coreSession.createDocumentModel("/", "doc1", "DirectoryReferencer");
    }

    @Test
    public void supportedClasses() throws Exception {
        List classes = new DirectoryEntryResolver().getManagedClasses();
        Assert.assertEquals((long)1L, (long)classes.size());
        Assert.assertTrue((boolean)classes.contains(DirectoryEntry.class));
    }

    @Test(expected=IllegalStateException.class)
    public void testLifecycleNoConfigurationFetch() {
        new DirectoryEntryResolver().fetch((Object)ENTRY_ID);
    }

    @Test(expected=IllegalStateException.class)
    public void testLifecycleNoConfigurationFetchCast() {
        new DirectoryEntryResolver().fetch(DocumentModel.class, (Object)ENTRY_ID);
    }

    @Test(expected=IllegalStateException.class)
    public void testLifecycleNoConfigurationGetReference() {
        new DirectoryEntryResolver().getReference((Object)this.entry1);
    }

    @Test(expected=IllegalStateException.class)
    public void testLifecycleNoConfigurationGetParameters() {
        new DirectoryEntryResolver().getParameters();
    }

    @Test(expected=IllegalStateException.class)
    public void testLifecycleNoConfigurationGetConstraintErrorMessage() {
        new DirectoryEntryResolver().getConstraintErrorMessage(null, Locale.ENGLISH);
    }

    @Test(expected=IllegalStateException.class)
    public void testLifecycleConfigurationTwice() {
        DirectoryEntryResolver derr = new DirectoryEntryResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("directory", REFERENCED_DIRECTORY1);
        derr.configure(parameters);
        derr.configure(parameters);
    }

    @Test
    public void testConfigurationDir1() {
        DirectoryEntryResolver derr = new DirectoryEntryResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("directory", REFERENCED_DIRECTORY1);
        derr.configure(parameters);
        Assert.assertEquals((Object)REFERENCED_DIRECTORY1, (Object)derr.getDirectory().getName());
        Map outputParameters = derr.getParameters();
        Assert.assertEquals((Object)REFERENCED_DIRECTORY1, outputParameters.get("directory"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConfigurationMissingDirectory() {
        DirectoryEntryResolver derr = new DirectoryEntryResolver();
        derr.configure(new HashMap());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConfigurationNonExistingDirectory() {
        DirectoryEntryResolver derr = new DirectoryEntryResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("directory", "aBadDirectoryName");
        derr.configure(parameters);
    }

    @Test
    public void testName() {
        DirectoryEntryResolver derr = new DirectoryEntryResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("directory", REFERENCED_DIRECTORY1);
        derr.configure(parameters);
        Assert.assertEquals((Object)"directoryResolver", (Object)derr.getName());
    }

    @Test
    public void testValidateGoodDir1Ref() {
        DirectoryEntryResolver derr = new DirectoryEntryResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("directory", REFERENCED_DIRECTORY1);
        derr.configure(parameters);
        Assert.assertTrue((boolean)derr.validate((Object)ENTRY_ID));
    }

    @Test
    public void testValidateDir1RefFailedWithBadValue() {
        DirectoryEntryResolver derr = new DirectoryEntryResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("directory", REFERENCED_DIRECTORY1);
        derr.configure(parameters);
        Assert.assertFalse((boolean)derr.validate((Object)"BAD id !"));
    }

    @Test
    public void testFetchGoodDir1Ref() {
        DirectoryEntryResolver derr = new DirectoryEntryResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("directory", REFERENCED_DIRECTORY1);
        derr.configure(parameters);
        Object entity = derr.fetch((Object)ENTRY_ID);
        Assert.assertTrue((boolean)(entity instanceof DirectoryEntry));
        Assert.assertEquals((Object)ENTRY_LABEL, (Object)((DirectoryEntry)entity).getDocumentModel().getPropertyValue("drs:label"));
    }

    @Test
    public void testFetchDir1RefFailedWithBadValue() {
        DirectoryEntryResolver derr = new DirectoryEntryResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("directory", REFERENCED_DIRECTORY1);
        derr.configure(parameters);
        Assert.assertNull((Object)derr.fetch((Object)"BAD id !"));
    }

    @Test
    public void testFetchCastDocumentModel() {
        DirectoryEntryResolver derr = new DirectoryEntryResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("directory", REFERENCED_DIRECTORY1);
        derr.configure(parameters);
        DocumentModel document = (DocumentModel)derr.fetch(DocumentModel.class, (Object)ENTRY_ID);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)ENTRY_LABEL, (Object)document.getPropertyValue("drs:label"));
        Assert.assertNull((Object)derr.fetch(DocumentModel.class, (Object)"toto"));
    }

    @Test
    public void testFetchCastDoesntSupportReferenceType() {
        DirectoryEntryResolver derr = new DirectoryEntryResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("directory", REFERENCED_DIRECTORY1);
        derr.configure(parameters);
        Assert.assertNull((Object)derr.fetch(Reference.class, (Object)ENTRY_ID));
    }

    @Test
    public void testFetchCastDoesntSupportStupidTypes() {
        DirectoryEntryResolver derr = new DirectoryEntryResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("directory", REFERENCED_DIRECTORY1);
        derr.configure(parameters);
        Assert.assertNull((Object)derr.fetch(List.class, (Object)ENTRY_ID));
    }

    @Test
    public void testGetReferenceDir1Ref() {
        DirectoryEntryResolver derr = new DirectoryEntryResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("directory", REFERENCED_DIRECTORY1);
        derr.configure(parameters);
        Assert.assertEquals((Object)ENTRY_ID, (Object)derr.getReference((Object)this.entry1));
    }

    @Test
    public void testGetReferenceInvalid() {
        DirectoryEntryResolver derr = new DirectoryEntryResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("directory", REFERENCED_DIRECTORY1);
        derr.configure(parameters);
        Assert.assertNull((Object)derr.getReference((Object)"nothing"));
    }

    @Test
    public void testGetHierarchicalReference() {
        DirectoryEntryResolver derr = new DirectoryEntryResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("directory", HIERARCHICAL_DIRECTORY);
        parameters.put("parentField", "parent");
        parameters.put("separator", "/");
        derr.configure(parameters);
        try (Session session = this.directoryService.open(HIERARCHICAL_DIRECTORY);){
            DocumentModel root = session.getEntry("level0");
            Assert.assertEquals((Object)"level0", (Object)derr.getReference((Object)root));
            DocumentModel leaf = session.getEntry("level2");
            Assert.assertEquals((Object)"level0/level1/level2", (Object)derr.getReference((Object)leaf));
        }
    }

    @Test
    public void testConfigurationIsLoaded() {
        DirectoryEntryResolver idResolver = (DirectoryEntryResolver)((SimpleType)this.doc.getProperty(REF1_XPATH).getType()).getObjectResolver();
        Assert.assertEquals((Object)REFERENCED_DIRECTORY1, (Object)idResolver.getDirectory().getName());
        Assert.assertEquals((Object)REFERENCED_DIRECTORY1, idResolver.getParameters().get("directory"));
        DirectoryEntryResolver pathResolver = (DirectoryEntryResolver)((SimpleType)this.doc.getProperty(REF2_XPATH).getType()).getObjectResolver();
        Assert.assertEquals((Object)REFERENCED_DIRECTORY2, (Object)pathResolver.getDirectory().getName());
        Assert.assertEquals((Object)REFERENCED_DIRECTORY2, pathResolver.getParameters().get("directory"));
    }

    @Test
    public void testNullValueReturnNull() {
        Assert.assertNull((Object)this.doc.getObjectResolver(REF1_XPATH).fetch());
        Assert.assertNull((Object)this.doc.getObjectResolver(REF1_XPATH).fetch(DocumentModel.class));
        Assert.assertNull((Object)this.doc.getProperty(REF1_XPATH).getObjectResolver().fetch());
        Assert.assertNull((Object)this.doc.getProperty(REF1_XPATH).getObjectResolver().fetch(DocumentModel.class));
        Assert.assertNull((Object)this.doc.getObjectResolver(REF2_XPATH).fetch());
        Assert.assertNull((Object)this.doc.getObjectResolver(REF2_XPATH).fetch(DocumentModel.class));
        Assert.assertNull((Object)this.doc.getProperty(REF2_XPATH).getObjectResolver().fetch());
        Assert.assertNull((Object)this.doc.getProperty(REF2_XPATH).getObjectResolver().fetch(DocumentModel.class));
    }

    @Test
    public void testBadValuesValidationFailed() {
        this.doc.setPropertyValue(REF1_XPATH, (Serializable)((Object)"BAD id !"));
        Assert.assertNull((Object)this.doc.getProperty(REF1_XPATH).getObjectResolver().fetch());
        Assert.assertFalse((boolean)this.doc.getProperty(REF1_XPATH).getObjectResolver().validate());
        this.doc.setPropertyValue(REF2_XPATH, (Serializable)((Object)"BAD path !"));
        Assert.assertNull((Object)this.doc.getProperty(REF2_XPATH).getObjectResolver().fetch());
        Assert.assertFalse((boolean)this.doc.getProperty(REF2_XPATH).getObjectResolver().validate());
        Assert.assertEquals((long)2L, (long)this.validator.validate(this.doc).numberOfErrors());
    }

    @Test
    public void testRefCorrectValues() {
        this.doc.setPropertyValue(REF1_XPATH, (Serializable)((Object)ENTRY_ID));
        DirectoryEntry entry = (DirectoryEntry)this.doc.getProperty(REF1_XPATH).getObjectResolver().fetch();
        DocumentModel document = entry.getDocumentModel();
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)ENTRY_LABEL, (Object)document.getPropertyValue("drs:label"));
        entry = (DirectoryEntry)this.doc.getObjectResolver(REF1_XPATH).fetch();
        document = entry.getDocumentModel();
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)ENTRY_LABEL, (Object)document.getPropertyValue("drs:label"));
        document = (DocumentModel)this.doc.getProperty(REF1_XPATH).getObjectResolver().fetch(DocumentModel.class);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)ENTRY_LABEL, (Object)document.getPropertyValue("drs:label"));
        document = (DocumentModel)this.doc.getObjectResolver(REF1_XPATH).fetch(DocumentModel.class);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)ENTRY_LABEL, (Object)document.getPropertyValue("drs:label"));
    }

    @Test
    public void testDocumentHierarchicalRef() {
        this.doc.setPropertyValue(HIERARCHICAL_REF_XPATH, (Serializable)((Object)"level0/level1/level2"));
        DirectoryEntry level2Entry = (DirectoryEntry)this.doc.getProperty(HIERARCHICAL_REF_XPATH).getObjectResolver().fetch();
        DocumentModel document = level2Entry.getDocumentModel();
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)"level2", (Object)document.getPropertyValue("hd:id"));
        DocumentModel newDoc = this.coreSession.createDocumentModel("/", "doc2", "DirectoryReferencer");
        newDoc.getProperty(HIERARCHICAL_REF_XPATH).getObjectResolver().setObject((Object)level2Entry);
        Assert.assertEquals((Object)"level0/level1/level2", (Object)newDoc.getPropertyValue(HIERARCHICAL_REF_XPATH));
    }

    @Test
    public void testTranslation() {
        DirectoryEntryResolver idderr = new DirectoryEntryResolver();
        HashMap<String, String> userParams = new HashMap<String, String>();
        userParams.put("directory", REFERENCED_DIRECTORY1);
        idderr.configure(userParams);
        this.checkMessage(idderr);
        DirectoryEntryResolver pathderr = new DirectoryEntryResolver();
        HashMap<String, String> groupParams = new HashMap<String, String>();
        groupParams.put("directory", REFERENCED_DIRECTORY2);
        pathderr.configure(groupParams);
        this.checkMessage(pathderr);
    }

    @Test
    public void testSerialization() throws Exception {
        DirectoryEntryResolver derr = new DirectoryEntryResolver();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("directory", REFERENCED_DIRECTORY1);
        derr.configure(parameters);
        byte[] buffer = SerializationUtils.serialize((Serializable)derr);
        derr = null;
        Object readObject = SerializationUtils.deserialize((byte[])buffer);
        Assert.assertTrue((boolean)(readObject instanceof DirectoryEntryResolver));
        DirectoryEntryResolver readDerr = (DirectoryEntryResolver)readObject;
        Assert.assertEquals((Object)REFERENCED_DIRECTORY1, (Object)readDerr.getDirectory().getName());
        Map outputParameters = readDerr.getParameters();
        Assert.assertEquals((Object)REFERENCED_DIRECTORY1, outputParameters.get("directory"));
        Assert.assertTrue((boolean)readDerr.validate((Object)ENTRY_ID));
        Object entity = readDerr.fetch((Object)ENTRY_ID);
        Assert.assertTrue((boolean)(entity instanceof DirectoryEntry));
        Assert.assertEquals((Object)ENTRY_LABEL, (Object)((DirectoryEntry)entity).getDocumentModel().getPropertyValue("drs:label"));
        Assert.assertEquals((Object)ENTRY_ID, (Object)readDerr.getReference((Object)this.entry1));
    }

    private void checkMessage(DirectoryEntryResolver derr) {
        for (Locale locale : Arrays.asList(Locale.FRENCH, Locale.ENGLISH)) {
            String message = derr.getConstraintErrorMessage((Object)"abc123", locale);
            Assert.assertNotNull((Object)message);
            Assert.assertFalse((boolean)message.trim().isEmpty());
            System.out.println(message);
        }
    }
}

